/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.demo;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.ArrayList;
import java.util.List;

public class TokensRegexMatcherDemo {
    private TokensRegexMatcherDemo() {
    }

    public static void main(String[] args) {
        String[] patterns;
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,ner"));
        Annotation annotation = new Annotation("Casey is 21. Sally Atkinson's age is 30.");
        pipeline.annotate(annotation);
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        ArrayList<TokenSequencePattern> tokenSequencePatterns = new ArrayList<TokenSequencePattern>();
        for (String line : patterns = new String[]{"(?$who [ ner: PERSON]+ ) /is/ (?$age [ pos: CD ] )", "(?$who [ ner: PERSON]+ ) /'s/ /age/ /is/ (?$age [ pos: CD ] )"}) {
            TokenSequencePattern pattern = TokenSequencePattern.compile(line);
            tokenSequencePatterns.add(pattern);
        }
        MultiPatternMatcher<CoreMap> multiMatcher = TokenSequencePattern.getMultiPatternMatcher(tokenSequencePatterns);
        int i = 0;
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            System.out.println("Sentence #" + ++i);
            System.out.print("  Tokens:");
            for (CoreLabel token : tokens) {
                System.out.print(' ');
                System.out.print(token.toShortString("Text", "PartOfSpeech", "NamedEntityTag"));
            }
            System.out.println();
            List<SequenceMatchResult<CoreMap>> answers = multiMatcher.findNonOverlapping(tokens);
            int j = 0;
            for (SequenceMatchResult<CoreMap> matched : answers) {
                System.out.println("  Match #" + ++j);
                System.out.println("    match: " + matched.group(0));
                System.out.println("      who: " + matched.group("$who"));
                System.out.println("      age: " + matched.group("$age"));
            }
        }
    }
}

