/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.StringUtils;
import java.util.List;

public class Match<K, V>
implements HasInterval<Integer> {
    List<K> matched;
    V value;
    int begin;
    int end;
    Object customMatchObject;
    transient Interval<Integer> span;

    public Match() {
    }

    public Match(List<K> matched, V value, int begin, int end) {
        this.matched = matched;
        this.value = value;
        this.begin = begin;
        this.end = end;
    }

    public List<K> getMatched() {
        return this.matched;
    }

    public int getMatchedLength() {
        return this.matched != null ? this.matched.size() : 0;
    }

    public V getValue() {
        return this.value;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public Object getCustom() {
        return this.customMatchObject;
    }

    public void setCustom(Object customMatchObject) {
        this.customMatchObject = customMatchObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match match = (Match)o;
        if (this.begin != match.begin) {
            return false;
        }
        if (this.end != match.end) {
            return false;
        }
        if (this.matched != null ? !this.matched.equals(match.matched) : match.matched != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(match.value) : match.value != null);
    }

    public int hashCode() {
        int result = this.matched != null ? this.matched.hashCode() : 0;
        result = 31 * result + this.begin;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + (this.matched != null ? StringUtils.join(this.matched, " - ") : "") + "]");
        sb.append(" -> ").append(this.value);
        sb.append(" at (").append(this.begin);
        sb.append(",").append(this.end).append(")");
        return sb.toString();
    }

    @Override
    public Interval<Integer> getInterval() {
        if (this.span == null) {
            this.span = Interval.toInterval(this.begin, this.end, 2);
        }
        return this.span;
    }
}

