/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.ling.tokensregex.matcher.ApproxMatch;
import edu.stanford.nlp.ling.tokensregex.matcher.Match;
import edu.stanford.nlp.ling.tokensregex.matcher.TrieMap;
import edu.stanford.nlp.ling.tokensregex.matcher.TrieMapMatcher;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class TrieMapTest
extends TestCase {
    public void testTrieBasic() throws Exception {
        TrieMap<String, Boolean> trieMap = new TrieMap<String, Boolean>();
        trieMap.put(new String[]{"a", "white", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "white", "hat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat", "climbed", "on", "the", "sofa"}, Boolean.TRUE);
        System.out.println(trieMap);
        System.out.println(trieMap.toFormattedString());
        TrieMapTest.assertTrue((boolean)((Boolean)trieMap.get((K[])new String[]{"a", "white", "hat"})));
        TrieMapTest.assertNull(trieMap.get((K[])new String[]{"a", "white"}));
        trieMap.remove((K[])new String[]{"a", "white", "hat"});
        TrieMapTest.assertTrue((boolean)((Boolean)trieMap.get((K[])new String[]{"a", "white", "cat"})));
        TrieMapTest.assertNull(trieMap.get((K[])new String[]{"a", "white", "hat"}));
        TrieMapTest.assertTrue((boolean)trieMap.containsKey(new String[]{"a", "white", "cat"}));
        TrieMapTest.assertFalse((boolean)trieMap.containsKey(new String[]{"white", "cat"}));
        TrieMapTest.assertEquals((int)3, (int)trieMap.size());
        TrieMapTest.assertEquals((int)3, (int)trieMap.keySet().size());
        HashMap<List<String>, Boolean> m = new HashMap<List<String>, Boolean>();
        m.put(Arrays.asList("a", "purple", "giraffe"), Boolean.TRUE);
        m.put(Arrays.asList("four", "orange", "bears"), Boolean.TRUE);
        trieMap.putAll((Map<Iterable<String>, Boolean>)m);
        TrieMapTest.assertTrue((boolean)trieMap.containsKey(new String[]{"a", "purple", "giraffe"}));
        TrieMapTest.assertTrue((boolean)trieMap.containsKey(new String[]{"four", "orange", "bears"}));
        TrieMapTest.assertEquals((int)5, (int)trieMap.size());
        TrieMapTest.assertEquals((int)5, (int)trieMap.keySet().size());
    }

    public void testTrieFindAll() throws Exception {
        TrieMap<String, Boolean> trieMap = new TrieMap<String, Boolean>();
        trieMap.put(new String[]{"a", "white", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "white", "hat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat", "climbed", "on", "the", "sofa"}, Boolean.TRUE);
        trieMap.put(new String[]{"white"}, Boolean.TRUE);
        TrieMapMatcher matcher = new TrieMapMatcher(trieMap);
        List matches = matcher.findAllMatches("a", "white", "cat", "is", "wearing", "a", "white", "hat");
        ArrayList<Match<String, Boolean>> expected = new ArrayList<Match<String, Boolean>>();
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "white", "cat"), Boolean.TRUE, 0, 3));
        expected.add(new Match<String, Boolean>(Arrays.asList("white"), Boolean.TRUE, 1, 2));
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 5, 8));
        expected.add(new Match<String, Boolean>(Arrays.asList("white"), Boolean.TRUE, 6, 7));
        TrieMapTest.assertEquals((String)("Expecting " + expected.size() + " matches: got " + matches), (int)expected.size(), (int)matches.size());
        TrieMapTest.assertEquals((String)("Expecting " + expected + ", got " + matches), expected, matches);
    }

    public void testTrieFindNonOverlapping() throws Exception {
        TrieMap<String, Boolean> trieMap = new TrieMap<String, Boolean>();
        trieMap.put(new String[]{"a", "white", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "white", "hat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat", "climbed", "on", "the", "sofa"}, Boolean.TRUE);
        trieMap.put(new String[]{"white"}, Boolean.TRUE);
        TrieMapMatcher matcher = new TrieMapMatcher(trieMap);
        List matches = matcher.findNonOverlapping("a", "white", "cat", "is", "wearing", "a", "white", "hat", "and", "a", "black", "cat", "climbed", "on", "the", "sofa");
        ArrayList<Match<String, Boolean>> expected = new ArrayList<Match<String, Boolean>>();
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "white", "cat"), Boolean.TRUE, 0, 3));
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 5, 8));
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "black", "cat", "climbed", "on", "the", "sofa"), Boolean.TRUE, 9, 16));
        TrieMapTest.assertEquals((String)("Expecting " + expected.size() + " matches: got " + matches), (int)expected.size(), (int)matches.size());
        TrieMapTest.assertEquals((String)("Expecting " + expected + ", got " + matches), expected, matches);
    }

    public void testTrieSegment() throws Exception {
        TrieMap<String, Boolean> trieMap = new TrieMap<String, Boolean>();
        trieMap.put(new String[]{"a", "white", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "white", "hat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat", "climbed", "on", "the", "sofa"}, Boolean.TRUE);
        trieMap.put(new String[]{"white"}, Boolean.TRUE);
        TrieMapMatcher matcher = new TrieMapMatcher(trieMap);
        List matches = matcher.segment("a", "white", "cat", "is", "wearing", "a", "white", "hat", "and", "a", "black", "cat", "climbed", "on", "the", "sofa");
        ArrayList<Match<String, Boolean>> expected = new ArrayList<Match<String, Boolean>>();
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "white", "cat"), Boolean.TRUE, 0, 3));
        expected.add(new Match<String, Object>(Arrays.asList("is", "wearing"), null, 3, 5));
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 5, 8));
        expected.add(new Match<String, Object>(Arrays.asList("and"), null, 8, 9));
        expected.add(new Match<String, Boolean>(Arrays.asList("a", "black", "cat", "climbed", "on", "the", "sofa"), Boolean.TRUE, 9, 16));
        TrieMapTest.assertEquals((String)("Expecting " + expected.size() + " matches: got " + matches), (int)expected.size(), (int)matches.size());
        TrieMapTest.assertEquals((String)("Expecting " + expected + ", got " + matches), expected, matches);
    }

    public void testTrieFindClosest() throws Exception {
        TrieMap<String, Boolean> trieMap = new TrieMap<String, Boolean>();
        trieMap.put(new String[]{"a", "white", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "white", "hat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "cat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "black", "hat"}, Boolean.TRUE);
        trieMap.put(new String[]{"a", "colored", "hat"}, Boolean.TRUE);
        TrieMapMatcher matcher = new TrieMapMatcher(trieMap);
        List matches = matcher.findClosestMatches(new String[]{"the", "black", "hat"}, 2);
        ArrayList<ApproxMatch<String, Boolean>> expected = new ArrayList<ApproxMatch<String, Boolean>>();
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "hat"), Boolean.TRUE, 0, 3, 1.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 3, 2.0));
        TrieMapTest.assertEquals((String)("\nExpecting " + expected + ",\n got " + matches), expected, matches);
        matches = matcher.findClosestMatches(new String[]{"the", "black"}, 5);
        expected = new ArrayList();
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 2, 2.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "hat"), Boolean.TRUE, 0, 2, 2.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "colored", "hat"), Boolean.TRUE, 0, 2, 3.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "white", "cat"), Boolean.TRUE, 0, 2, 3.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 0, 2, 3.0));
        TrieMapTest.assertEquals((String)("\nExpecting " + StringUtils.join(expected, "\n") + ",\ngot " + StringUtils.join(matches, "\n")), expected, matches);
        matches = matcher.findClosestMatches(new String[]{"the", "black", "cat", "is", "wearing", "a", "white", "hat"}, 5);
        expected = new ArrayList();
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 0, 8, 5.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 8, 6.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "hat"), Boolean.TRUE, 0, 8, 6.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "colored", "hat"), Boolean.TRUE, 0, 8, 6.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "white", "cat"), Boolean.TRUE, 0, 8, 6.0));
        TrieMapTest.assertEquals((String)("Expecting " + StringUtils.join(expected, "\n") + ",\ngot " + StringUtils.join(matches, "\n")), expected, matches);
        matches = matcher.findClosestMatches(new String[]{"the", "black", "cat", "is", "wearing", "a", "white", "hat"}, 6, true, true);
        expected = new ArrayList();
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat", "a", "white", "hat"), Boolean.TRUE, 0, 8, Arrays.asList(new Match<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 3), new Match<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 5, 8)), 3.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat", "a", "black", "hat"), Boolean.TRUE, 0, 8, Arrays.asList(new Match<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 3), new Match<String, Boolean>(Arrays.asList("a", "black", "hat"), Boolean.TRUE, 5, 8)), 4.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat", "a", "colored", "hat"), Boolean.TRUE, 0, 8, Arrays.asList(new Match<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 3), new Match<String, Boolean>(Arrays.asList("a", "colored", "hat"), Boolean.TRUE, 5, 8)), 4.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat", "a", "white", "cat"), Boolean.TRUE, 0, 8, Arrays.asList(new Match<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 3), new Match<String, Boolean>(Arrays.asList("a", "white", "cat"), Boolean.TRUE, 5, 8)), 4.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "hat", "a", "white", "hat"), Boolean.TRUE, 0, 8, Arrays.asList(new Match<String, Boolean>(Arrays.asList("a", "black", "hat"), Boolean.TRUE, 0, 3), new Match<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 5, 8)), 4.0));
        expected.add(new ApproxMatch<String, Boolean>(Arrays.asList("a", "black", "cat", "a", "black", "cat", "a", "white", "hat"), Boolean.TRUE, 0, 8, Arrays.asList(new Match<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 0, 3), new Match<String, Boolean>(Arrays.asList("a", "black", "cat"), Boolean.TRUE, 3, 5), new Match<String, Boolean>(Arrays.asList("a", "white", "hat"), Boolean.TRUE, 5, 8)), 4.0));
        TrieMapTest.assertEquals((String)("\nExpecting " + StringUtils.join(expected, "\n") + ",\ngot " + StringUtils.join(matches, "\n")), expected, matches);
    }
}

