/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorTable;
import edu.stanford.nlp.loglinear.model.GraphicalModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class GraphicalModelTest {
    @Theory
    public void testProtoModel(@ForAll(sampleSize=50) @From(value={GraphicalModelGenerator.class}) GraphicalModel graphicalModel) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        graphicalModel.writeToStream(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        GraphicalModel recovered = GraphicalModel.readFromStream(byteArrayInputStream);
        Assert.assertTrue((boolean)graphicalModel.valueEquals(recovered, 1.0E-5));
    }

    @Theory
    public void testClone(@ForAll(sampleSize=50) @From(value={GraphicalModelGenerator.class}) GraphicalModel graphicalModel) throws IOException {
        GraphicalModel clone = graphicalModel.cloneModel();
        Assert.assertTrue((boolean)graphicalModel.valueEquals(clone, 1.0E-5));
    }

    @Theory
    public void testGetVariableSizes(@ForAll(sampleSize=50) @From(value={GraphicalModelGenerator.class}) GraphicalModel graphicalModel) throws IOException {
        int[] sizes = graphicalModel.getVariableSizes();
        for (GraphicalModel.Factor f : graphicalModel.factors) {
            for (int i = 0; i < f.neigborIndices.length; ++i) {
                Assert.assertEquals((long)f.featuresTable.getDimensions()[i], (long)sizes[f.neigborIndices[i]]);
            }
        }
    }

    public static class GraphicalModelGenerator
    extends Generator<GraphicalModel> {
        public GraphicalModelGenerator(Class<GraphicalModel> type) {
            super(type);
        }

        private Map<String, String> generateMetaData(SourceOfRandomness sourceOfRandomness, Map<String, String> metaData) {
            int numPairs = sourceOfRandomness.nextInt(9);
            for (int i = 0; i < numPairs; ++i) {
                int key = sourceOfRandomness.nextInt();
                int value = sourceOfRandomness.nextInt();
                metaData.put("key:" + key, "value:" + value);
            }
            return metaData;
        }

        public GraphicalModel generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int i;
            GraphicalModel model = new GraphicalModel();
            int[] variableSizes = new int[20];
            for (int i2 = 0; i2 < 20; ++i2) {
                variableSizes[i2] = sourceOfRandomness.nextInt(1, 5);
            }
            int numFactors = sourceOfRandomness.nextInt(12);
            for (i = 0; i < numFactors; ++i) {
                int[] neighbors = new int[sourceOfRandomness.nextInt(1, 3)];
                int[] neighborSizes = new int[neighbors.length];
                for (int j = 0; j < neighbors.length; ++j) {
                    neighbors[j] = sourceOfRandomness.nextInt(20);
                    neighborSizes[j] = variableSizes[neighbors[j]];
                }
                ConcatVectorTable table = new ConcatVectorTable(neighborSizes);
                for (int[] assignment : table) {
                    int numComponents = sourceOfRandomness.nextInt(7);
                    ConcatVector v = new ConcatVector(numComponents);
                    for (int x = 0; x < numComponents; ++x) {
                        if (sourceOfRandomness.nextBoolean()) {
                            v.setSparseComponent(x, sourceOfRandomness.nextInt(32), sourceOfRandomness.nextDouble());
                            continue;
                        }
                        double[] val = new double[sourceOfRandomness.nextInt(12)];
                        for (int y = 0; y < val.length; ++y) {
                            val[y] = sourceOfRandomness.nextDouble();
                        }
                        v.setDenseComponent(x, val);
                    }
                    table.setAssignmentValue(assignment, () -> v);
                }
                model.addFactor(table, neighbors);
            }
            this.generateMetaData(sourceOfRandomness, model.getModelMetaDataByReference());
            for (i = 0; i < 20; ++i) {
                this.generateMetaData(sourceOfRandomness, model.getVariableMetaDataByReference(i));
            }
            for (GraphicalModel.Factor factor : model.factors) {
                this.generateMetaData(sourceOfRandomness, factor.getMetaDataByReference());
            }
            return model;
        }
    }
}

