/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.neural;

import edu.stanford.nlp.neural.NeuralUtils;
import org.ejml.simple.SimpleMatrix;
import org.junit.Assert;
import org.junit.Test;

public class NeuralUtilsTest {
    @Test
    public void testCosine() {
        double[][] values = new double[1][5];
        values[0] = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};
        SimpleMatrix vector1 = new SimpleMatrix(values);
        values[0] = new double[]{0.5, 0.4, 0.3, 0.2, 0.1};
        SimpleMatrix vector2 = new SimpleMatrix(values);
        Assert.assertEquals((double)0.35000000000000003, (double)NeuralUtils.dot(vector1, vector2), (double)1.0E-5);
        Assert.assertEquals((double)0.6363636363636364, (double)NeuralUtils.cosine(vector1, vector2), (double)1.0E-5);
        vector1 = (SimpleMatrix)vector1.transpose();
        vector2 = (SimpleMatrix)vector2.transpose();
        Assert.assertEquals((double)0.35000000000000003, (double)NeuralUtils.dot(vector1, vector2), (double)1.0E-5);
        Assert.assertEquals((double)0.6363636363636364, (double)NeuralUtils.cosine(vector1, vector2), (double)1.0E-5);
    }

    public void testIsZero() {
        double[][] values = new double[][]{{0.1, 0.2, 0.3, 0.4, 0.5}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        SimpleMatrix vector1 = new SimpleMatrix((double[][])values);
        Assert.assertFalse((boolean)NeuralUtils.isZero(vector1));
        values = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        vector1 = new SimpleMatrix((double[][])values);
        Assert.assertTrue((boolean)NeuralUtils.isZero(vector1));
    }
}

