/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.neural;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.math.ArrayMath;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class VectorMap
extends HashMap<String, float[]> {
    public VectorMap() {
        super(1024);
    }

    public VectorMap(Map<String, float[]> vectors) {
        super(vectors);
    }

    public void serialize(String file) throws IOException {
        block25: {
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(new File(file)));){
                if (file.endsWith(".gz")) {
                    try (GZIPOutputStream gzip = new GZIPOutputStream(output);){
                        this.serialize(gzip);
                        break block25;
                    }
                }
                this.serialize(output);
            }
        }
    }

    public void serialize(OutputStream out2) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(out2);
        int maxKeyLength = 0;
        int vectorLength = 0;
        for (Map.Entry entry : this.entrySet()) {
            maxKeyLength = Math.max(((String)entry.getKey()).getBytes().length, maxKeyLength);
            vectorLength = ((float[])entry.getValue()).length;
        }
        itype keyIntType = itype.getType(maxKeyLength);
        dataOut.writeInt(maxKeyLength);
        dataOut.writeInt(vectorLength);
        dataOut.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            byte[] key = ((String)entry.getKey()).getBytes();
            keyIntType.write(dataOut, key.length);
            dataOut.write(key);
            for (float v : (float[])entry.getValue()) {
                dataOut.writeShort(VectorMap.fromFloat(v));
            }
        }
    }

    public static VectorMap deserialize(String file) throws IOException {
        try (InputStream input = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(file);){
            VectorMap vectorMap = VectorMap.deserialize(input);
            return vectorMap;
        }
    }

    public static VectorMap deserialize(InputStream in) throws IOException {
        DataInputStream dataIn = new DataInputStream(in);
        itype keyIntType = itype.getType(dataIn.readInt());
        int dim = dataIn.readInt();
        int size = dataIn.readInt();
        VectorMap vectors = new VectorMap();
        for (int i = 0; i < size; ++i) {
            int strlen = keyIntType.read(dataIn);
            byte[] buffer = new byte[strlen];
            if (dataIn.read(buffer, 0, strlen) != strlen) {
                throw new IOException("Could not read string buffer fully!");
            }
            String key = new String(buffer);
            float[] vector = new float[dim];
            for (int k = 0; k < vector.length; ++k) {
                vector[k] = VectorMap.toFloat(dataIn.readShort());
            }
            vectors.put(key, vector);
        }
        return vectors;
    }

    public static VectorMap readWord2Vec(String file) {
        VectorMap vectors = new VectorMap();
        int dim = -1;
        for (String line : IOUtils.readLines(file)) {
            String[] split = line.toLowerCase().split("\\s+");
            if (split.length < 100) continue;
            float[] vector = new float[split.length - 1];
            if (dim == -1) {
                dim = vector.length;
            }
            assert (dim == vector.length);
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            ArrayMath.L2normalize(vector);
            vectors.put(split[0], vector);
        }
        return vectors;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Map) {
            try {
                Map otherMap = (Map)other;
                if (this.keySet().size() != otherMap.keySet().size()) {
                    return false;
                }
                for (Map.Entry entry : this.entrySet()) {
                    float[] otherValue = (float[])otherMap.get(entry.getKey());
                    if (otherValue == null && entry.getValue() != null) {
                        return false;
                    }
                    if (otherValue != null && entry.getValue() == null) {
                        return false;
                    }
                    if (entry.getValue() == null || otherValue == null) continue;
                    if (((float[])entry.getValue()).length != otherValue.length) {
                        return false;
                    }
                    for (int i = 0; i < otherValue.length; ++i) {
                        if (VectorMap.sameFloat(((float[])entry.getValue())[i], otherValue[i])) continue;
                        return false;
                    }
                }
                return true;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.keySet().hashCode();
    }

    @Override
    public String toString() {
        return "VectorMap[" + this.size() + "]";
    }

    private static boolean sameFloat(float a, float b) {
        float absDiff = Math.abs(a - b);
        float absA = Math.abs(a);
        float absB = Math.abs(b);
        return (double)absDiff < 1.0E-10 || absDiff < Math.max(absA, absB) / 100.0f || (double)absA < 1.0E-5 && (double)absB < 1.0E-5;
    }

    private static float toFloat(short hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((hbits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    private static short fromFloat(float fval) {
        int fbits = Float.floatToIntBits(fval);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return (short)(sign | 0x7C00);
                }
                return (short)(sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13);
            }
            return (short)(sign | 0x7BFF);
        }
        if (val >= 0x38800000) {
            return (short)(sign | val - 0x38000000 >>> 13);
        }
        if (val < 0x33000000) {
            return (short)sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return (short)(sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val);
    }

    private static enum itype {
        INT8,
        INT16,
        INT32;


        static itype getType(int num) {
            itype t = INT32;
            if (num < Short.MAX_VALUE) {
                t = INT16;
            }
            if (num < 127) {
                t = INT8;
            }
            return t;
        }

        public int read(DataInputStream in) throws IOException {
            switch (this) {
                case INT8: {
                    return in.readByte();
                }
                case INT16: {
                    return in.readShort();
                }
                case INT32: {
                    return in.readInt();
                }
            }
            throw new RuntimeException("Unknown itype: " + (Object)((Object)this));
        }

        public void write(DataOutputStream out2, int value) throws IOException {
            switch (this) {
                case INT8: {
                    out2.writeByte(value);
                    break;
                }
                case INT16: {
                    out2.writeShort(value);
                    break;
                }
                case INT32: {
                    out2.writeInt(value);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown itype: " + (Object)((Object)this));
                }
            }
        }
    }
}

