/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.trees.CollinsDependency;
import edu.stanford.nlp.trees.CollinsRelation;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class CollinsDepEval
extends AbstractEval {
    private static Redwood.RedwoodChannels log = Redwood.channels(CollinsDepEval.class);
    private static final boolean DEBUG = false;
    private final HeadFinder hf;
    private final String startSymbol;
    private final Counter<CollinsRelation> precisions;
    private final Counter<CollinsRelation> recalls;
    private final Counter<CollinsRelation> f1s;
    private final Counter<CollinsRelation> precisions2;
    private final Counter<CollinsRelation> recalls2;
    private final Counter<CollinsRelation> pnums2;
    private final Counter<CollinsRelation> rnums2;
    private static final int MIN_ARGS = 2;

    public CollinsDepEval(String str, boolean runningAverages, HeadFinder hf, String startSymbol) {
        super(str, runningAverages);
        this.hf = hf;
        this.startSymbol = startSymbol;
        this.precisions = new ClassicCounter<CollinsRelation>();
        this.recalls = new ClassicCounter<CollinsRelation>();
        this.f1s = new ClassicCounter<CollinsRelation>();
        this.precisions2 = new ClassicCounter<CollinsRelation>();
        this.recalls2 = new ClassicCounter<CollinsRelation>();
        this.pnums2 = new ClassicCounter<CollinsRelation>();
        this.rnums2 = new ClassicCounter<CollinsRelation>();
    }

    @Override
    protected Set<?> makeObjects(Tree tree) {
        log.info(this.getClass().getName() + ": Function makeObjects() not implemented");
        return null;
    }

    private Map<CollinsRelation, Set<CollinsDependency>> makeCollinsObjects(Tree t) {
        Map<CollinsRelation, Set<CollinsDependency>> relMap = Generics.newHashMap();
        Set<CollinsDependency> deps = CollinsDependency.extractNormalizedFromTree(t, this.startSymbol, this.hf);
        for (CollinsDependency dep : deps) {
            if (relMap.get(dep.getRelation()) == null) {
                relMap.put(dep.getRelation(), Generics.newHashSet());
            }
            relMap.get(dep.getRelation()).add(dep);
        }
        return relMap;
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!\n", this.getClass().getName());
            return;
        }
        Map<CollinsRelation, Set<CollinsDependency>> guessDeps = this.makeCollinsObjects(guess);
        Map<CollinsRelation, Set<CollinsDependency>> goldDeps = this.makeCollinsObjects(gold);
        Set<CollinsRelation> relations = Generics.newHashSet();
        relations.addAll(guessDeps.keySet());
        relations.addAll(goldDeps.keySet());
        this.num += 1.0;
        for (CollinsRelation rel : relations) {
            Set<CollinsDependency> thisGuessDeps = guessDeps.get(rel);
            Set<CollinsDependency> thisGoldDeps = goldDeps.get(rel);
            if (thisGuessDeps == null) {
                thisGuessDeps = Generics.newHashSet();
            }
            if (thisGoldDeps == null) {
                thisGoldDeps = Generics.newHashSet();
            }
            double currentPrecision = CollinsDepEval.precision(thisGuessDeps, thisGoldDeps);
            double currentRecall = CollinsDepEval.precision(thisGoldDeps, thisGuessDeps);
            double currentF1 = currentPrecision > 0.0 && currentRecall > 0.0 ? 2.0 / (1.0 / currentPrecision + 1.0 / currentRecall) : 0.0;
            this.precisions.incrementCount(rel, currentPrecision);
            this.recalls.incrementCount(rel, currentRecall);
            this.f1s.incrementCount(rel, currentF1);
            this.precisions2.incrementCount(rel, (double)thisGuessDeps.size() * currentPrecision);
            this.pnums2.incrementCount(rel, thisGuessDeps.size());
            this.recalls2.incrementCount(rel, (double)thisGoldDeps.size() * currentRecall);
            this.rnums2.incrementCount(rel, thisGoldDeps.size());
            if (pw == null || !this.runningAverages) continue;
            pw.println(rel + "\tP: " + (double)((int)(currentPrecision * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.precisions.getCount(rel) * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.precisions2.getCount(rel) * 10000.0 / this.pnums2.getCount(rel))) / 100.0 + ")");
            pw.println("\tR: " + (double)((int)(currentRecall * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.recalls.getCount(rel) * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.recalls2.getCount(rel) * 10000.0 / this.rnums2.getCount(rel))) / 100.0 + ")");
            double cF1 = 2.0 / (this.rnums2.getCount(rel) / this.recalls2.getCount(rel) + this.pnums2.getCount(rel) / this.precisions2.getCount(rel));
            String emit = this.str + " F1: " + (double)((int)(currentF1 * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(10000.0 * this.f1s.getCount(rel) / this.num)) / 100.0 + ", evalb " + (double)((int)(10000.0 * cF1)) / 100.0 + ")";
            pw.println(emit);
        }
        if (pw != null && this.runningAverages) {
            pw.println("================================================================================");
        }
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        double f1;
        double rec;
        double prec;
        double rnum2;
        double pnum2;
        DecimalFormat nf = new DecimalFormat("0.00");
        Set<CollinsRelation> cats = Generics.newHashSet();
        Random rand = new Random();
        cats.addAll(this.precisions.keySet());
        cats.addAll(this.recalls.keySet());
        TreeMap<Double, CollinsRelation> f1Map = new TreeMap<Double, CollinsRelation>();
        for (CollinsRelation cat : cats) {
            pnum2 = this.pnums2.getCount(cat);
            rnum2 = this.rnums2.getCount(cat);
            prec = this.precisions2.getCount(cat) / pnum2;
            f1 = 2.0 / (1.0 / prec + 1.0 / (rec = this.recalls2.getCount(cat) / rnum2));
            if (new Double(f1).equals(Double.NaN)) {
                f1 = -1.0;
            }
            if (f1Map.containsKey(f1)) {
                f1Map.put(f1 + rand.nextDouble() / 1000.0, cat);
                continue;
            }
            f1Map.put(f1, cat);
        }
        pw.println(" Abstract Collins Dependencies -- final statistics");
        pw.println("================================================================================");
        for (CollinsRelation cat : f1Map.values()) {
            pnum2 = this.pnums2.getCount(cat);
            rnum2 = this.rnums2.getCount(cat);
            prec = this.precisions2.getCount(cat) / pnum2;
            rec = this.recalls2.getCount(cat) / rnum2;
            f1 = 2.0 / (1.0 / prec + 1.0 / rec);
            pw.println(cat + "\tLP: " + (pnum2 == 0.0 ? " N/A" : nf.format(prec)) + "\tguessed: " + (int)pnum2 + "\tLR: " + (rnum2 == 0.0 ? " N/A" : nf.format(rec)) + "\tgold:  " + (int)rnum2 + "\tF1: " + (pnum2 == 0.0 || rnum2 == 0.0 ? " N/A" : nf.format(f1)));
        }
        pw.println("================================================================================");
    }

    private static String usage() {
        StringBuilder usage = new StringBuilder();
        String nl = System.getProperty("line.separator");
        usage.append(String.format("Usage: java %s [OPTS] goldFile guessFile%n%n", CollinsDepEval.class.getName()));
        usage.append("Options:").append(nl);
        usage.append("  -v        : Verbose output").append(nl);
        usage.append("  -l lang   : Language name " + Language.langList).append(nl);
        usage.append("  -y num    : Max yield of gold trees").append(nl);
        usage.append("  -g num    : Max yield of guess trees").append(nl);
        return usage.toString();
    }

    private static Map<String, Integer> optionArgDefs() {
        Map<String, Integer> optionArgDefs = Generics.newHashMap();
        optionArgDefs.put("v", 0);
        optionArgDefs.put("l", 1);
        optionArgDefs.put("g", 1);
        optionArgDefs.put("y", 1);
        return optionArgDefs;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            log.info(CollinsDepEval.usage());
            System.exit(-1);
        }
        Properties options = StringUtils.argsToProperties(args, CollinsDepEval.optionArgDefs());
        boolean VERBOSE = PropertiesUtils.getBool(options, "v", false);
        Language LANGUAGE = PropertiesUtils.get(options, "l", Language.English, Language.class);
        int MAX_GOLD_YIELD = PropertiesUtils.getInt(options, "g", Integer.MAX_VALUE);
        int MAX_GUESS_YIELD = PropertiesUtils.getInt(options, "y", Integer.MAX_VALUE);
        String[] parsedArgs = options.getProperty("", "").split("\\s+");
        if (parsedArgs.length != 2) {
            log.info(CollinsDepEval.usage());
            System.exit(-1);
        }
        File goldFile = new File(parsedArgs[0]);
        File guessFile = new File(parsedArgs[1]);
        TreebankLangParserParams tlpp = LANGUAGE.params;
        PrintWriter pwOut = tlpp.pw();
        DiskTreebank guessTreebank = tlpp.diskTreebank();
        guessTreebank.loadPath(guessFile);
        pwOut.println("GUESS TREEBANK:");
        pwOut.println(guessTreebank.textualSummary());
        DiskTreebank goldTreebank = tlpp.diskTreebank();
        goldTreebank.loadPath(goldFile);
        pwOut.println("GOLD TREEBANK:");
        pwOut.println(goldTreebank.textualSummary());
        CollinsDepEval depEval = new CollinsDepEval("CollinsDep", true, tlpp.headFinder(), tlpp.treebankLanguagePack().startSymbol());
        TreeTransformer tc = tlpp.collinizer();
        Iterator goldItr = ((AbstractCollection)goldTreebank).iterator();
        int goldLineId = 0;
        int skippedGuessTrees = 0;
        block0: for (Tree guess : guessTreebank) {
            Tree evalGuess = tc.transformTree(guess);
            if (guess.yield().size() > MAX_GUESS_YIELD) {
                ++skippedGuessTrees;
                continue;
            }
            boolean doneEval = false;
            while (goldItr.hasNext() && !doneEval) {
                Tree gold = (Tree)goldItr.next();
                Tree evalGold = tc.transformTree(gold);
                ++goldLineId;
                if (gold.yield().size() > MAX_GOLD_YIELD) continue;
                if (evalGold.yield().size() != evalGuess.yield().size()) {
                    pwOut.println("Yield mismatch at gold line " + goldLineId);
                    ++skippedGuessTrees;
                    continue block0;
                }
                depEval.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
                doneEval = true;
            }
        }
        pwOut.println("================================================================================");
        if (skippedGuessTrees != 0) {
            pwOut.printf("%s %d guess trees\n", MAX_GUESS_YIELD < Integer.MAX_VALUE ? "Skipped" : "Unable to evaluate", skippedGuessTrees);
        }
        depEval.display(true, pwOut);
        pwOut.close();
    }
}

