/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.tools;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class RHSFrequency {
    private static final int minArgs = 2;
    private static final StringBuilder usage = new StringBuilder();

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(usage.toString());
            System.exit(-1);
        }
        TreebankLangParserParams tlpp = new EnglishTreebankParserParams();
        DiskTreebank tb = null;
        String encoding = "UTF-8";
        TregexPattern rootMatch = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                switch (args[i]) {
                    case "-l": {
                        Language lang = Language.valueOf(args[++i].trim());
                        tlpp = lang.params;
                        break;
                    }
                    case "-e": {
                        encoding = args[++i];
                        break;
                    }
                    default: {
                        System.out.println(usage.toString());
                        System.exit(-1);
                        break;
                    }
                }
                continue;
            }
            rootMatch = TregexPattern.compile("@" + args[i++]);
            if (tb == null) {
                if (tlpp == null) {
                    System.out.println(usage.toString());
                    System.exit(-1);
                } else {
                    tlpp.setInputEncoding(encoding);
                    tlpp.setOutputEncoding(encoding);
                    tb = tlpp.diskTreebank();
                }
            }
            tb.loadPath(args[i++]);
        }
        ClassicCounter<String> rhsCounter = new ClassicCounter<String>();
        for (Tree t : tb) {
            TregexMatcher m = rootMatch.matcher(t);
            while (m.findNextMatchingNode()) {
                Tree match = m.getMatch();
                StringBuilder sb = new StringBuilder();
                for (Tree kid : match.children()) {
                    sb.append(kid.value()).append(" ");
                }
                rhsCounter.incrementCount(sb.toString().trim());
            }
        }
        ArrayList biggestKeys = new ArrayList(rhsCounter.keySet());
        Collections.sort(biggestKeys, Counters.toComparatorDescending(rhsCounter));
        PrintWriter pw = tlpp.pw();
        for (String rhs : biggestKeys) {
            pw.printf("%s\t%d%n", rhs, (int)rhsCounter.getCount(rhs));
        }
        pw.close();
    }

    static {
        usage.append(String.format("Usage: java %s [OPTS] lhs tree_file \n\n", RHSFrequency.class.getName()));
        usage.append("Options:\n");
        usage.append("  -l lang    : Select language settings from " + Language.langList + "\n");
        usage.append("  -e enc     : Encoding.\n");
    }
}

