/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.surface.PatternsForEachToken;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.LuceneFieldType;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;

public class PatternsForEachTokenLucene<E extends Pattern>
extends PatternsForEachToken<E> {
    static IndexWriter indexWriter;
    static File indexDir;
    static Directory dir;
    static Analyzer analyzer;
    static IndexWriterConfig iwc;
    static DirectoryReader reader;
    static IndexSearcher searcher;
    static AtomicBoolean openIndexWriter;
    @ArgumentParser.Option(name="allPatternsDir")
    String allPatternsDir;
    @ArgumentParser.Option(name="createPatLuceneIndex", required=true)
    boolean createPatLuceneIndex;

    public PatternsForEachTokenLucene(Properties props, Map<String, Map<Integer, Set<E>>> pats) {
        ArgumentParser.fillOptions((Object)this, props);
        if (this.allPatternsDir == null) {
            File f;
            try {
                f = File.createTempFile("allpatterns", "index");
                System.out.println("No directory provided for creating patternsForEachToken lucene index. Making it at " + f.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            f.deleteOnExit();
            this.allPatternsDir = f.getAbsolutePath();
        }
        if (this.createPatLuceneIndex) {
            Redwood.log("Deleting any exising index at " + this.allPatternsDir);
            IOUtils.deleteDirRecursively(new File(this.allPatternsDir));
        }
        indexDir = new File(this.allPatternsDir);
        if (pats != null) {
            this.addPatterns(pats);
        }
    }

    public void checkClean() {
        try {
            dir = FSDirectory.open((File)indexDir);
            CheckIndex checkIndex = new CheckIndex(dir);
            CheckIndex.Status status = checkIndex.checkIndex();
            assert (status.clean) : "index is not clean";
            dir.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PatternsForEachTokenLucene(Properties props) {
        this(props, null);
    }

    @Override
    public void setupSearch() {
        PatternsForEachTokenLucene.setIndexReaderSearcher();
    }

    static synchronized void setIndexReaderSearcher() {
        try {
            FSDirectory index = NIOFSDirectory.open((File)indexDir);
            if (reader == null) {
                reader = DirectoryReader.open((Directory)index);
                searcher = new IndexSearcher((IndexReader)reader);
            } else {
                DirectoryReader newreader = DirectoryReader.openIfChanged((DirectoryReader)reader);
                if (newreader != null) {
                    reader.close();
                    reader = newreader;
                    searcher = new IndexSearcher((IndexReader)reader);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addPatterns(Map<String, Map<Integer, Set<E>>> pats) {
        try {
            PatternsForEachTokenLucene.setIndexWriter();
            for (Map.Entry<String, Map<Integer, Set<E>>> en : pats.entrySet()) {
                this.addPatterns(en.getKey(), en.getValue(), false);
            }
            indexWriter.commit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static synchronized void setIndexWriter() {
        try {
            if (!openIndexWriter.get()) {
                dir = FSDirectory.open((File)indexDir);
                Redwood.log(new Object[]{Redwood.DBG, "Updating lucene index at " + indexDir});
                indexWriter = new IndexWriter(dir, iwc);
                openIndexWriter.set(true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static synchronized void closeIndexWriter() {
        try {
            if (openIndexWriter.get()) {
                indexWriter.close();
                openIndexWriter.set(false);
                indexWriter = null;
                Redwood.log(new Object[]{Redwood.DBG, "closing index writer"});
            }
            if (dir != null) {
                dir.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        PatternsForEachTokenLucene.closeIndexWriter();
    }

    @Override
    public void load(String allPatternsDir) {
        assert (new File(allPatternsDir).exists());
    }

    @Override
    public void addPatterns(String id, Map<Integer, Set<E>> p) {
        this.addPatterns(id, p, true);
    }

    private void addPatterns(String id, Map<Integer, Set<E>> p, boolean commit) {
        try {
            PatternsForEachTokenLucene.setIndexWriter();
            Document doc = new Document();
            doc.add((IndexableField)new StringField("sentid", id, Field.Store.YES));
            doc.add((IndexableField)new Field("patterns", this.getBytes(p), LuceneFieldType.NOT_INDEXED));
            indexWriter.addDocument((Iterable)doc);
            if (commit) {
                indexWriter.commit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getBytes(Map<Integer, Set<E>> p) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(p);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createIndexIfUsingDBAndNotExists() {
    }

    @Override
    public Map<Integer, Set<E>> getPatternsForAllTokens(String sentId) {
        block5: {
            try {
                TermQuery query = new TermQuery(new Term("sentid", sentId));
                TopDocs tp = searcher.search((Query)query, 1);
                if (tp.totalHits > 0) {
                    int n = 0;
                    ScoreDoc[] scoreDocArray = tp.scoreDocs;
                    int n2 = scoreDocArray.length;
                    if (n < n2) {
                        ScoreDoc s = scoreDocArray[n];
                        int docId = s.doc;
                        Document d = searcher.doc(docId);
                        byte[] st = d.getBinaryValue((String)"patterns").bytes;
                        ByteArrayInputStream baip = new ByteArrayInputStream(st);
                        ObjectInputStream ois = new ObjectInputStream(baip);
                        return (Map)ois.readObject();
                    }
                    break block5;
                }
                throw new RuntimeException("Why no patterns for sentid " + sentId + ". Number of documents in index are " + this.size());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public boolean save(String dir) {
        return false;
    }

    @Override
    public Map<String, Map<Integer, Set<E>>> getPatternsForAllTokens(Collection<String> sentIds) {
        this.close();
        PatternsForEachTokenLucene.setIndexReaderSearcher();
        HashMap<String, Map<Integer, Set<E>>> pats = new HashMap<String, Map<Integer, Set<E>>>();
        for (String s : sentIds) {
            pats.put(s, this.getPatternsForAllTokens(s));
        }
        PatternsForEachTokenLucene.setIndexWriter();
        return pats;
    }

    @Override
    int size() {
        PatternsForEachTokenLucene.setIndexReaderSearcher();
        return searcher.getIndexReader().numDocs();
    }

    static {
        indexDir = null;
        analyzer = new KeywordAnalyzer();
        iwc = new IndexWriterConfig(Version.LUCENE_42, analyzer);
        reader = null;
        openIndexWriter = new AtomicBoolean(false);
    }
}

