/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.common.NoSuchParseException;
import edu.stanford.nlp.parser.common.ParserAnnotations;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.common.ParserGrammar;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.common.ParserUtils;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.ParserAnnotatorUtils;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class ParserAnnotator
extends SentenceAnnotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ParserAnnotator.class);
    private final boolean VERBOSE;
    private final boolean BUILD_GRAPHS;
    private final ParserGrammar parser;
    private final Function<Tree, Tree> treeMap;
    private final int maxSentenceLength;
    private final long maxParseTime;
    private final int kBest;
    private final GrammaticalStructureFactory gsf;
    private final int nThreads;
    private final boolean saveBinaryTrees;
    private final boolean keepPunct;
    private final boolean noSquash;
    private final GrammaticalStructure.Extras extraDependencies;

    public ParserAnnotator(boolean verbose, int maxSent) {
        this(System.getProperty("parse.model", LexicalizedParser.DEFAULT_PARSER_LOC), verbose, maxSent, StringUtils.EMPTY_STRING_ARRAY);
    }

    public ParserAnnotator(String parserLoc, boolean verbose, int maxSent, String[] flags) {
        this(ParserAnnotator.loadModel(parserLoc, verbose, flags), verbose, maxSent);
    }

    public ParserAnnotator(ParserGrammar parser, boolean verbose, int maxSent) {
        this(parser, verbose, maxSent, null);
    }

    public ParserAnnotator(ParserGrammar parser, boolean verbose, int maxSent, Function<Tree, Tree> treeMap) {
        this.VERBOSE = verbose;
        this.BUILD_GRAPHS = parser.getTLPParams().supportsBasicDependencies();
        this.parser = parser;
        this.maxSentenceLength = maxSent;
        this.treeMap = treeMap;
        this.maxParseTime = 0L;
        this.kBest = 1;
        this.keepPunct = true;
        if (this.BUILD_GRAPHS) {
            TreebankLanguagePack tlp = parser.getTLPParams().treebankLanguagePack();
            this.gsf = tlp.grammaticalStructureFactory(tlp.punctuationWordRejectFilter(), parser.getTLPParams().typedDependencyHeadFinder());
        } else {
            this.gsf = null;
        }
        this.nThreads = 1;
        this.saveBinaryTrees = false;
        this.noSquash = false;
        this.extraDependencies = GrammaticalStructure.Extras.NONE;
    }

    public ParserAnnotator(String annotatorName, Properties props) {
        String model = props.getProperty(annotatorName + ".model", LexicalizedParser.DEFAULT_PARSER_LOC);
        if (model == null) {
            throw new IllegalArgumentException("No model specified for Parser annotator " + annotatorName);
        }
        this.VERBOSE = PropertiesUtils.getBool(props, annotatorName + ".debug", false);
        String[] flags = ParserAnnotator.convertFlagsToArray(props.getProperty(annotatorName + ".flags"));
        this.parser = ParserAnnotator.loadModel(model, this.VERBOSE, flags);
        this.maxSentenceLength = PropertiesUtils.getInt(props, annotatorName + ".maxlen", -1);
        String treeMapClass = props.getProperty(annotatorName + ".treemap");
        this.treeMap = treeMapClass == null ? null : (Function)ReflectionLoading.loadByReflection(treeMapClass, props);
        this.maxParseTime = PropertiesUtils.getLong(props, annotatorName + ".maxtime", -1L);
        this.kBest = PropertiesUtils.getInt(props, annotatorName + ".kbest", 1);
        this.keepPunct = PropertiesUtils.getBool(props, annotatorName + ".keepPunct", true);
        String buildGraphsProperty = annotatorName + ".buildgraphs";
        if (!this.parser.getTLPParams().supportsBasicDependencies()) {
            if (PropertiesUtils.getBool(props, buildGraphsProperty)) {
                log.info("WARNING: " + buildGraphsProperty + " set to true, but " + this.parser.getTLPParams().getClass() + " does not support dependencies");
            }
            this.BUILD_GRAPHS = false;
        } else {
            this.BUILD_GRAPHS = PropertiesUtils.getBool(props, buildGraphsProperty, true);
        }
        if (this.BUILD_GRAPHS) {
            boolean generateOriginalDependencies = PropertiesUtils.getBool(props, annotatorName + ".originalDependencies", false);
            this.parser.getTLPParams().setGenerateOriginalDependencies(generateOriginalDependencies);
            TreebankLanguagePack tlp = this.parser.getTLPParams().treebankLanguagePack();
            Predicate<String> punctFilter = this.keepPunct ? Filters.acceptFilter() : tlp.punctuationWordRejectFilter();
            this.gsf = tlp.grammaticalStructureFactory(punctFilter, this.parser.getTLPParams().typedDependencyHeadFinder());
        } else {
            this.gsf = null;
        }
        this.nThreads = PropertiesUtils.getInt(props, annotatorName + ".nthreads", PropertiesUtils.getInt(props, "nthreads", 1));
        boolean usesBinary = StanfordCoreNLP.usesBinaryTrees(props);
        this.saveBinaryTrees = PropertiesUtils.getBool(props, annotatorName + ".binaryTrees", usesBinary);
        this.noSquash = PropertiesUtils.getBool(props, annotatorName + ".nosquash", false);
        this.extraDependencies = (GrammaticalStructure.Extras)((Object)MetaClass.cast(props.getProperty(annotatorName + ".extradependencies", "NONE"), GrammaticalStructure.Extras.class));
    }

    public static String signature(String annotatorName, Properties props) {
        StringBuilder os = new StringBuilder();
        os.append(annotatorName + ".model:" + props.getProperty(annotatorName + ".model", LexicalizedParser.DEFAULT_PARSER_LOC));
        os.append(annotatorName + ".debug:" + props.getProperty(annotatorName + ".debug", "false"));
        os.append(annotatorName + ".flags:" + props.getProperty(annotatorName + ".flags", ""));
        os.append(annotatorName + ".maxlen:" + props.getProperty(annotatorName + ".maxlen", "-1"));
        os.append(annotatorName + ".treemap:" + props.getProperty(annotatorName + ".treemap", ""));
        os.append(annotatorName + ".maxtime:" + props.getProperty(annotatorName + ".maxtime", "-1"));
        os.append(annotatorName + ".originalDependencies:" + props.getProperty(annotatorName + ".originalDependencies", "false"));
        os.append(annotatorName + ".buildgraphs:" + props.getProperty(annotatorName + ".buildgraphs", "true"));
        os.append(annotatorName + ".nthreads:" + props.getProperty(annotatorName + ".nthreads", props.getProperty("nthreads", "")));
        os.append(annotatorName + ".nosquash:" + props.getProperty(annotatorName + ".nosquash", "false"));
        os.append(annotatorName + ".keepPunct:" + props.getProperty(annotatorName + ".keepPunct", "true"));
        os.append(annotatorName + ".extradependencies:" + props.getProperty(annotatorName + ".extradependencies", "NONE").toLowerCase());
        boolean usesBinary = StanfordCoreNLP.usesBinaryTrees(props);
        boolean saveBinaryTrees = PropertiesUtils.getBool(props, annotatorName + ".binaryTrees", usesBinary);
        os.append(annotatorName + ".binaryTrees:" + saveBinaryTrees);
        return os.toString();
    }

    private static String[] convertFlagsToArray(String parserFlags) {
        if (parserFlags == null || parserFlags.trim().isEmpty()) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return parserFlags.trim().split("\\s+");
    }

    private static ParserGrammar loadModel(String parserLoc, boolean verbose, String[] flags) {
        if (verbose) {
            log.info("Loading Parser Model [" + parserLoc + "] ...");
            log.info("  Flags:");
            for (String flag : flags) {
                log.info("  " + flag);
            }
            log.info(new Object[0]);
        }
        ParserGrammar result = ParserGrammar.loadModel(parserLoc, new String[0]);
        result.setOptionFlags(result.defaultCoreNLPFlags());
        result.setOptionFlags(flags);
        return result;
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxParseTime;
    }

    @Override
    protected void doOneSentence(Annotation annotation, CoreMap sentence) {
        if (this.noSquash && sentence.get(TreeCoreAnnotations.TreeAnnotation.class) != null && !"X".equalsIgnoreCase(((Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class)).label().value())) {
            return;
        }
        List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (this.VERBOSE) {
            log.info("Parsing: " + words);
        }
        List<Tree> trees = null;
        if (this.maxSentenceLength <= 0 || words.size() <= this.maxSentenceLength) {
            try {
                List constraints = (List)sentence.get(ParserAnnotations.ConstraintAnnotation.class);
                trees = this.doOneSentence(constraints, words);
            }
            catch (RuntimeInterruptedException e) {
                if (this.VERBOSE) {
                    log.info("Took too long parsing: " + words);
                }
                trees = null;
            }
        }
        if (trees == null || trees.size() < 1) {
            this.doOneFailedSentence(annotation, sentence);
        } else {
            this.finishSentence(sentence, trees);
        }
    }

    @Override
    public void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = ParserUtils.xTree(words);
        for (CoreLabel word : words) {
            if (word.tag() != null) continue;
            word.setTag("XX");
        }
        ArrayList<Tree> trees = Generics.newArrayList(1);
        trees.add(tree);
        this.finishSentence(sentence, trees);
    }

    private void finishSentence(CoreMap sentence, List<Tree> trees) {
        SemanticGraph sg;
        if (this.treeMap != null) {
            LinkedList<Tree> mappedTrees = Generics.newLinkedList();
            for (Tree tree : trees) {
                Tree mappedTree = this.treeMap.apply(tree);
                mappedTrees.add(mappedTree);
            }
            trees = mappedTrees;
        }
        ParserAnnotatorUtils.fillInParseAnnotations(this.VERBOSE, this.BUILD_GRAPHS, this.gsf, sentence, trees, this.extraDependencies);
        if (this.saveBinaryTrees) {
            TreeBinarizer binarizer = TreeBinarizer.simpleTreeBinarizer(this.parser.getTLPParams().headFinder(), this.parser.treebankLanguagePack());
            Tree binarized = binarizer.transformTree(trees.get(0));
            Trees.convertToCoreLabels(binarized);
            sentence.set(TreeCoreAnnotations.BinarizedTreeAnnotation.class, binarized);
        }
        if ((sg = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)) != null) {
            for (IndexedWord iw : sg.vertexSet()) {
                if (iw.get(CoreAnnotations.SentenceIndexAnnotation.class) != null || sentence.get(CoreAnnotations.SentenceIndexAnnotation.class) == null) continue;
                iw.setSentIndex((Integer)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
            }
        }
    }

    private List<Tree> doOneSentence(List<ParserConstraint> constraints, List<CoreLabel> words) {
        ParserQuery pq = this.parser.parserQuery();
        pq.setConstraints(constraints);
        pq.parse(words);
        LinkedList<Tree> trees = Generics.newLinkedList();
        try {
            if (this.kBest == 1) {
                Tree t = pq.getBestParse();
                if (t == null) {
                    log.warn("Parsing of sentence failed.  Will ignore and continue: " + SentenceUtils.listToString(words));
                } else {
                    double score = pq.getBestScore();
                    t.setScore(score % -10000.0);
                    trees.add(t);
                }
            } else {
                List<ScoredObject<Tree>> scoredObjects = pq.getKBestParses(this.kBest);
                if (scoredObjects == null || scoredObjects.size() < 1) {
                    log.warn("Parsing of sentence failed.  Will ignore and continue: " + SentenceUtils.listToString(words));
                } else {
                    for (ScoredObject<Tree> so : scoredObjects) {
                        Tree tree = so.object();
                        tree.setScore(so.score() % -10000.0);
                        trees.add(tree);
                    }
                }
            }
        }
        catch (OutOfMemoryError e) {
            log.error(e);
            log.warn("Parsing of sentence ran out of memory (length=" + words.size() + ").  Will ignore and try to continue.");
        }
        catch (NoSuchParseException e) {
            log.warn("Parsing of sentence failed, possibly because of out of memory.  Will ignore and continue: " + SentenceUtils.listToString(words));
        }
        return trees;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        if (this.parser.requiresTags()) {
            return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class)));
        }
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        if (this.BUILD_GRAPHS) {
            if (this.saveBinaryTrees) {
                return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, TreeCoreAnnotations.BinarizedTreeAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, CoreAnnotations.BeginIndexAnnotation.class, CoreAnnotations.EndIndexAnnotation.class, CoreAnnotations.CategoryAnnotation.class)));
            }
            return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, CoreAnnotations.BeginIndexAnnotation.class, CoreAnnotations.EndIndexAnnotation.class, CoreAnnotations.CategoryAnnotation.class)));
        }
        if (this.saveBinaryTrees) {
            return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, TreeCoreAnnotations.BinarizedTreeAnnotation.class, CoreAnnotations.CategoryAnnotation.class)));
        }
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, CoreAnnotations.CategoryAnnotation.class)));
    }
}

