/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TokensRegexNERAnnotator;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TokensRegexNERAnnotatorITest {
    private static final String REGEX_ANNOTATOR_NAME = "tokensregexner";
    private static final String MAPPING = "/u/nlp/data/TAC-KBP2010/sentence_extraction/itest_map";
    private static StanfordCoreNLP pipeline;
    private static Annotator caseless;
    private static Annotator cased;
    private static Annotator annotator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        Class<TokensRegexNERAnnotatorITest> clazz = TokensRegexNERAnnotatorITest.class;
        synchronized (TokensRegexNERAnnotatorITest.class) {
            if (pipeline == null) {
                Properties props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, pos, lemma, ner");
                props.setProperty("ner.applyFineGrained", "false");
                props.setProperty("ner.buildEntityMentions", "false");
                pipeline = new StanfordCoreNLP(props);
                caseless = new TokensRegexNERAnnotator(MAPPING, true);
                annotator = cased = new TokensRegexNERAnnotator(MAPPING);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static TokensRegexNERAnnotator getTokensRegexNerAnnotator(Properties props) {
        return new TokensRegexNERAnnotator(REGEX_ANNOTATOR_NAME, props);
    }

    private static TokensRegexNERAnnotator getTokensRegexNerAnnotator(String[][] patterns, boolean ignoreCase) throws Exception {
        return TokensRegexNERAnnotatorITest.getTokensRegexNerAnnotator(new Properties(), patterns, ignoreCase);
    }

    private static TokensRegexNERAnnotator getTokensRegexNerAnnotator(Properties props, String[][] patterns, boolean ignoreCase) throws Exception {
        File tempFile = File.createTempFile("tokensregexnertest.patterns", "txt");
        tempFile.deleteOnExit();
        PrintWriter pw = IOUtils.getPrintWriter(tempFile.getAbsolutePath());
        for (String[] p : patterns) {
            pw.println(StringUtils.join(p, "\t"));
        }
        pw.close();
        props.setProperty("tokensregexner.mapping", tempFile.getAbsolutePath());
        props.setProperty("tokensregexner.ignorecase", String.valueOf(ignoreCase));
        return new TokensRegexNERAnnotator(REGEX_ANNOTATOR_NAME, props);
    }

    protected static Annotation createDocument(String text) {
        Annotation annotation = new Annotation(text);
        pipeline.annotate(annotation);
        return annotation;
    }

    private static void checkNerTags(List<CoreLabel> tokens, String ... tags) {
        Assert.assertEquals((long)tags.length, (long)tokens.size());
        for (int i = 0; i < tags.length; ++i) {
            Assert.assertEquals((String)("Mismatch for token tag NER " + i + ' ' + tokens.get(i)), (Object)tags[i], tokens.get(i).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        }
    }

    private static void checkTags(List<CoreLabel> tokens, Class key, String ... tags) {
        Assert.assertEquals((long)tags.length, (long)tokens.size());
        for (int i = 0; i < tags.length; ++i) {
            Assert.assertEquals((String)("Mismatch for token tag " + key + ' ' + i + ' ' + tokens.get(i)), (Object)tags[i], tokens.get(i).get(key));
        }
    }

    private static void reannotate(List<CoreLabel> tokens, Class key, String ... tags) {
        Assert.assertEquals((long)tags.length, (long)tokens.size());
        for (int i = 0; i < tags.length; ++i) {
            tokens.get(i).set(key, tags[i]);
        }
    }

    @Test
    public void testTokensRegexSyntax() throws Exception {
        String[][] regexes = new String[][]{{"( /University/ /of/ [ {ner:LOCATION} ] )", "SCHOOL"}};
        TokensRegexNERAnnotator annotatorCased = TokensRegexNERAnnotatorITest.getTokensRegexNerAnnotator(regexes, false);
        String str = "University of Alaska is located in Alaska.";
        Annotation document = TokensRegexNERAnnotatorITest.createDocument(str);
        annotatorCased.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "ORGANIZATION", "ORGANIZATION", "ORGANIZATION", "O", "O", "O", "LOCATION", "O");
        TokensRegexNERAnnotatorITest.reannotate(tokens, CoreAnnotations.NamedEntityTagAnnotation.class, "O", "O", "LOCATION", "O", "O", "O", "LOCATION", "O");
        annotatorCased.annotate(document);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "SCHOOL", "SCHOOL", "SCHOOL", "O", "O", "O", "LOCATION", "O");
        TokensRegexNERAnnotator annotatorCaseless = TokensRegexNERAnnotatorITest.getTokensRegexNerAnnotator(regexes, true);
        str = "university of alaska is located in alaska.";
        document = TokensRegexNERAnnotatorITest.createDocument(str);
        tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "O", "O", "LOCATION", "O", "O", "O", "LOCATION", "O");
        annotatorCased.annotate(document);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "O", "O", "LOCATION", "O", "O", "O", "LOCATION", "O");
        annotatorCaseless.annotate(document);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "SCHOOL", "SCHOOL", "SCHOOL", "O", "O", "O", "LOCATION", "O");
    }

    @Test
    public void testTokensRegexMatchGroup() throws Exception {
        String[][] regexes = new String[][]{{"( /the/? /movie/ (/[A-Z].*/+) )", "MOVIE", "", "0", "1"}};
        TokensRegexNERAnnotator annotatorCased = TokensRegexNERAnnotatorITest.getTokensRegexNerAnnotator(regexes, false);
        String str = "the movie Mud was very muddy";
        Annotation document = TokensRegexNERAnnotatorITest.createDocument(str);
        annotatorCased.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "O", "O", "MOVIE", "O", "O", "O");
    }

    @Test
    public void testTokensRegexNormalizedAnnotate() throws Exception {
        Properties props = new Properties();
        props.setProperty("tokensregexner.mapping.header", "pattern,ner,normalized,overwrite,priority,group");
        String[][] regexes = new String[][]{{"blue", "COLOR", "B", "", "0"}, {"red", "COLOR", "R", "", "0"}, {"green", "COLOR", "G", "", "0"}};
        TokensRegexNERAnnotator annotatorCased = TokensRegexNERAnnotatorITest.getTokensRegexNerAnnotator(props, regexes, false);
        String str = "These are all colors: blue, red, and green.";
        Annotation document = TokensRegexNERAnnotatorITest.createDocument(str);
        annotatorCased.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkTags(tokens, CoreAnnotations.TextAnnotation.class, "These", "are", "all", "colors", ":", "blue", ",", "red", ",", "and", "green", ".");
        TokensRegexNERAnnotatorITest.checkTags(tokens, CoreAnnotations.NamedEntityTagAnnotation.class, "O", "O", "O", "O", "O", "COLOR", "O", "COLOR", "O", "O", "COLOR", "O");
        TokensRegexNERAnnotatorITest.checkTags(tokens, CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, null, null, null, null, null, "B", null, "R", null, null, "G", null);
    }

    @Test
    public void testTokensRegexCustomAnnotate() throws Exception {
        Properties props = new Properties();
        props.setProperty("tokensregexner.mapping.header", "pattern,test,overwrite,priority,group");
        props.setProperty("tokensregexner.mapping.field.test", "edu.stanford.nlp.pipeline.TokensRegexNERAnnotatorITest$TestAnnotation");
        String[][] regexes = new String[][]{{"test", "TEST", "", "0"}};
        TokensRegexNERAnnotator annotatorCased = TokensRegexNERAnnotatorITest.getTokensRegexNerAnnotator(props, regexes, true);
        String str = "Marking all test as test";
        Annotation document = TokensRegexNERAnnotatorITest.createDocument(str);
        annotatorCased.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkTags(tokens, CoreAnnotations.TextAnnotation.class, "Marking", "all", "test", "as", "test");
        TokensRegexNERAnnotatorITest.checkTags(tokens, TestAnnotation.class, null, null, "TEST", null, "TEST");
    }

    @Test
    public void testBasicMatching() {
        String str = "President Barack Obama lives in Chicago , Illinois , and is a practicing Christian .";
        Annotation document = TokensRegexNERAnnotatorITest.createDocument(str);
        annotator.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "TITLE", "PERSON", "PERSON", "O", "O", "LOCATION", "O", "STATE_OR_PROVINCE", "O", "O", "O", "O", "O", "IDEOLOGY", "O");
    }

    @Test
    public void testOverwrite() {
        String str = "I like Ontario Bank and Ontario Lake , and I like the Native American Church , too .";
        Annotation document = TokensRegexNERAnnotatorITest.createDocument(str);
        annotator.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "O", "O", "ORGANIZATION", "ORGANIZATION", "O", "STATE_OR_PROVINCE", "LOCATION", "O", "O", "O", "O", "O", "RELIGION", "RELIGION", "RELIGION", "O", "O", "O");
    }

    @Test
    public void testPriority() {
        String str = "Christianity is of higher regex priority than Early Christianity . ";
        Annotation document = TokensRegexNERAnnotatorITest.createDocument(str);
        annotator.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        TokensRegexNERAnnotatorITest.checkNerTags(tokens, "RELIGION", "O", "O", "O", "O", "O", "O", "O", "RELIGION", "O");
    }

    @Test
    public void testEmptyAnnotation() {
        try {
            annotator.annotate(new Annotation(""));
        }
        catch (RuntimeException e) {
            return;
        }
        Assert.fail((String)"Never expected to get this far... the annotator should have thrown an exception by now");
    }

    public static class TestAnnotation
    implements CoreAnnotation<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }
    }
}

