/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.StreamGobbler;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public abstract class WebServiceAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(WebServiceAnnotator.class);
    private static long CONNECT_TIMEOUT = Duration.ofMinutes(15L).toMillis();
    protected boolean everLive = false;
    protected boolean serverWasActive = false;
    private Optional<RunningProcess> server = Optional.empty();

    protected abstract Optional<String[]> startCommand();

    protected abstract Optional<String[]> stopCommand();

    protected abstract boolean ready(boolean var1);

    protected abstract void annotateImpl(Annotation var1) throws ShouldRetryException, PermanentlyFailedException;

    protected boolean live() {
        return true;
    }

    protected boolean ping(String uri) {
        try {
            URL url = new URL(uri);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestMethod("GET");
            connection.connect();
            int code = connection.getResponseCode();
            return code < 500 || code >= 600;
        }
        catch (MalformedURLException e) {
            log.warn("Could not parse URL: " + uri);
            return false;
        }
        catch (ClassCastException e) {
            log.warn("Not an HTTP URI");
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startServer(String[] command) {
        ProcessBuilder proc = new ProcessBuilder(command);
        try {
            WebServiceAnnotator webServiceAnnotator = this;
            synchronized (webServiceAnnotator) {
                this.server = Optional.of(new RunningProcess(proc.start()));
            }
            log.info("Started server " + StringUtils.join(command));
            return true;
        }
        catch (IOException e) {
            log.error("Could not start process: " + StringUtils.join(command));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureServer() throws TimeoutException, IOException {
        long startTime = System.currentTimeMillis();
        if (this.serverWasActive && this.ready(false)) {
            return;
        }
        boolean serverStarted = this.startCommand().map(this::startServer).orElse(true);
        if (!serverStarted) {
            throw new IOException("Could not start a local server!");
        }
        while (!this.everLive) {
            if (System.currentTimeMillis() > startTime + CONNECT_TIMEOUT) {
                throw new TimeoutException("Could not connect to annotator: " + this);
            }
            if (!this.live()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.everLive = true;
        }
        log.info("Got liveness from server for " + this);
        WebServiceAnnotator webServiceAnnotator = this;
        synchronized (webServiceAnnotator) {
            if (this.server.isPresent()) {
                while (!this.server.get().ready) {
                    if (System.currentTimeMillis() > startTime + CONNECT_TIMEOUT) {
                        throw new TimeoutException("Never got readiness from annotator: " + this);
                    }
                    if (!this.ready(true)) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.server.get().ready = true;
                }
            } else if (!this.ready(false)) {
                throw new IOException("Server is not ready and can not start it!");
            }
        }
        log.info("Got readiness from server for " + this);
        this.serverWasActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmount() {
        log.info("Unmounting server: " + this);
        WebServiceAnnotator webServiceAnnotator = this;
        synchronized (webServiceAnnotator) {
            if (this.server.isPresent()) {
                this.server.get().kill();
                this.server = Optional.empty();
            }
            try {
                if (this.stopCommand().isPresent()) {
                    ProcessBuilder proc = new ProcessBuilder(this.stopCommand().get());
                    proc.start();
                }
            }
            catch (Exception e) {
                log.error("Error: problem with running stop command for WebServiceAnnotator");
            }
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        this.annotate(annotation, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate(Annotation annotation, int tries) {
        block19: {
            try {
                WebServiceAnnotator webServiceAnnotator = this;
                synchronized (webServiceAnnotator) {
                    this.ensureServer();
                }
                try {
                    this.annotateImpl(annotation);
                }
                catch (PermanentlyFailedException e) {
                    WebServiceAnnotator webServiceAnnotator2 = this;
                    synchronized (webServiceAnnotator2) {
                        if (this.server.isPresent()) {
                            this.server.get().kill();
                            this.server = Optional.empty();
                        }
                    }
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause != null) {
                        throw new RuntimeException(cause);
                    }
                    throw new RuntimeException(e);
                }
                catch (ShouldRetryException e) {
                    WebServiceAnnotator webServiceAnnotator3 = this;
                    synchronized (webServiceAnnotator3) {
                        if (tries >= 2 && this.server.isPresent()) {
                            this.server.get().kill();
                            this.server = Optional.empty();
                        }
                    }
                    if (tries < 3) {
                        this.annotate(annotation, tries + 1);
                        break block19;
                    }
                    throw new RuntimeException("Could not annotate document after 3 tries:", e);
                }
            }
            catch (IOException | TimeoutException e) {
                throw new RuntimeException("Could not ensure a server:", e);
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        WebServiceAnnotator annotator = new WebServiceAnnotator(){

            @Override
            public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
                return Collections.emptySet();
            }

            @Override
            public Set<Class<? extends CoreAnnotation>> requires() {
                return Collections.emptySet();
            }

            @Override
            protected Optional<String[]> startCommand() {
                return Optional.of(new String[]{"bash", "script.sh"});
            }

            @Override
            protected Optional<String[]> stopCommand() {
                return Optional.empty();
            }

            @Override
            protected boolean ready(boolean initialTest) {
                return this.ping("http://localhost:8000");
            }

            @Override
            protected void annotateImpl(Annotation ann) throws ShouldRetryException, PermanentlyFailedException {
                log.info("Fake annotated! ping=" + this.ping("http://localhost:8000"));
            }

            public String toString() {
                return "<test WebServiceAnnotator>";
            }
        };
        Annotation ann = new Annotation("");
        annotator.annotate(ann);
    }

    private class RunningProcess {
        public final Process process;
        public final StreamGobbler stdout;
        public final StreamGobbler stderr;
        public boolean ready = false;
        private final Thread shutdownHoook;

        private RunningProcess(Process process) {
            this.process = process;
            BufferedWriter errWriter = new BufferedWriter(new OutputStreamWriter(System.err));
            this.stderr = new StreamGobbler(process.getErrorStream(), errWriter);
            this.stderr.start();
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            this.stdout = new StreamGobbler(process.getErrorStream(), outWriter);
            this.stdout.start();
            this.shutdownHoook = new Thread(() -> {
                log.info("Killing process " + WebServiceAnnotator.this);
                this.stdout.kill();
                this.stderr.kill();
                if (this.process.isAlive()) {
                    this.process.destroy();
                }
                this.ready = false;
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHoook);
        }

        public void kill() {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHoook);
            this.shutdownHoook.run();
        }

        protected void finalize() throws Throwable {
            try {
                super.finalize();
            }
            finally {
                this.kill();
            }
        }
    }

    public static class PermanentlyFailedException
    extends Exception {
        private static final long serialVersionUID = 6812811056236924923L;

        public PermanentlyFailedException() {
        }

        public PermanentlyFailedException(Throwable t) {
            super(t);
        }
    }

    public static class ShouldRetryException
    extends Exception {
        private static final long serialVersionUID = -4292922700733296864L;
    }
}

