/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.sequences.BeamBestSequenceFinder;
import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.sequences.SequenceSampler;
import java.util.Arrays;
import junit.framework.TestCase;

public class BestSequenceFinderTest
extends TestCase {
    private static final boolean DEBUG = false;

    public static void runSequenceFinder(TestSequenceModel tsm, BestSequenceFinder sf) {
        int[] bestLabels = sf.bestSequence(tsm);
        BestSequenceFinderTest.assertTrue((String)("Best sequence is wrong. Correct: " + Arrays.toString(tsm.correctAnswers()) + ", found: " + Arrays.toString(bestLabels)), (boolean)Arrays.equals(tsm.correctAnswers(), bestLabels));
        BestSequenceFinderTest.assertEquals((String)"Best sequence score is wrong.", (Object)tsm.bestSequenceScore(), (Object)tsm.scoreOf(bestLabels));
    }

    public static void runPossibleValuesChecker(TestSequenceModel tsm, BestSequenceFinder sf) {
        int[] bestLabels = sf.bestSequence(tsm);
        for (int i = 0; i < bestLabels.length; ++i) {
            int[] possibleValues = tsm.getPossibleValues(i);
            boolean found = false;
            for (int possible : possibleValues) {
                if (bestLabels[i] != possible) continue;
                found = true;
            }
            if (found) continue;
            BestSequenceFinderTest.fail((String)("Returned impossible label " + bestLabels[i] + " for position " + i));
        }
    }

    public void testExactBestSequenceFinder() {
        ExactBestSequenceFinder bsf = new ExactBestSequenceFinder();
        TestSequenceModel1 tsm = new TestSequenceModel1();
        BestSequenceFinderTest.runSequenceFinder(tsm, bsf);
        BestSequenceFinderTest.runPossibleValuesChecker(tsm, bsf);
        TestSequenceModel2 tsm2 = new TestSequenceModel2();
        BestSequenceFinderTest.runSequenceFinder(tsm2, bsf);
        BestSequenceFinderTest.runPossibleValuesChecker(tsm2, bsf);
        TestSequenceModel2nr tsm2nr = new TestSequenceModel2nr();
        BestSequenceFinderTest.runSequenceFinder(tsm2nr, bsf);
        BestSequenceFinderTest.runPossibleValuesChecker(tsm2nr, bsf);
        TestSequenceModel3 tsm3 = new TestSequenceModel3();
        BestSequenceFinderTest.runSequenceFinder(tsm3, bsf);
        BestSequenceFinderTest.runPossibleValuesChecker(tsm3, bsf);
    }

    public void testBeamBestSequenceFinder() {
        BeamBestSequenceFinder bsf = new BeamBestSequenceFinder(5, true);
        TestSequenceModel1 tsm = new TestSequenceModel1();
        BestSequenceFinderTest.runSequenceFinder(tsm, bsf);
        BestSequenceFinderTest.runPossibleValuesChecker(tsm, bsf);
    }

    public void testSequenceSampler() {
        SequenceSampler bsf = new SequenceSampler();
        TestSequenceModel1 tsm = new TestSequenceModel1();
        BestSequenceFinderTest.runPossibleValuesChecker(tsm, bsf);
        TestSequenceModel2 tsm2 = new TestSequenceModel2();
        BestSequenceFinderTest.runPossibleValuesChecker(tsm2, bsf);
        TestSequenceModel3 tsm3 = new TestSequenceModel3();
        BestSequenceFinderTest.runPossibleValuesChecker(tsm3, bsf);
    }

    public static class TestSequenceModel3
    implements TestSequenceModel {
        private final int[] correctTags = new int[]{0, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 0};
        private final int[] data = new int[]{0, 5, 3, 7, 9, 4, 7, 8, 3, 7, 8, 3, 7, 3, 0};
        private final int[] allTags = new int[]{0, 1, 2};
        private final int[] nullTags = new int[]{0};

        @Override
        public int length() {
            return this.correctTags.length - this.leftWindow() - this.rightWindow();
        }

        @Override
        public int leftWindow() {
            return 1;
        }

        @Override
        public int rightWindow() {
            return 1;
        }

        @Override
        public int[] getPossibleValues(int pos) {
            if (pos < this.leftWindow() || pos >= this.leftWindow() + this.length()) {
                return this.nullTags;
            }
            return this.allTags;
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            double score = this.data[pos] == 7 && tags[pos] == 2 && tags[pos + 1] == 2 ? 1.0 : (this.data[pos] == 8 && tags[pos] == 2 ? 0.5 : (tags[pos] == 1 ? 0.1 : (tags[pos] == 2 ? -5.0 : 0.0)));
            return score;
        }

        @Override
        public double scoreOf(int[] sequence) {
            double score = 0.0;
            for (int i = this.leftWindow(); i < this.leftWindow() + this.length(); ++i) {
                score += this.scoreOf(sequence, i);
            }
            return score;
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            int[] tagsAtPos = this.getPossibleValues(pos);
            double[] scores = new double[tagsAtPos.length];
            for (int t = 0; t < tagsAtPos.length; ++t) {
                tags[pos] = tagsAtPos[t];
                scores[t] = this.scoreOf(tags, pos);
            }
            return scores;
        }

        @Override
        public int[] correctAnswers() {
            return this.correctTags;
        }

        @Override
        public double bestSequenceScore() {
            return this.scoreOf(this.correctTags);
        }
    }

    public static class TestSequenceModel2nr
    implements TestSequenceModel {
        private final int[] correctTags = new int[]{0, 0, 7, 8, 9};
        private final int[] allTags = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        private final int[] midTags = new int[]{0, 1, 2, 3, 4, 5};
        private final int[] nullTags = new int[]{0};

        @Override
        public int length() {
            return this.correctTags.length - this.leftWindow() - this.rightWindow();
        }

        @Override
        public int leftWindow() {
            return 2;
        }

        @Override
        public int rightWindow() {
            return 0;
        }

        @Override
        public int[] getPossibleValues(int pos) {
            if (pos < this.leftWindow() || pos >= this.leftWindow() + this.length()) {
                return this.nullTags;
            }
            if (pos < 5) {
                return this.allTags;
            }
            return this.midTags;
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            double score = tags[pos] > tags[pos - 1] && tags[pos] <= tags[pos - 1] + 1 ? (double)tags[pos] : (tags[pos] == 0 ? 0.0 : 1.0 / (double)tags[pos]);
            return score;
        }

        @Override
        public double scoreOf(int[] sequence) {
            double score = 0.0;
            for (int i = this.leftWindow(); i < this.leftWindow() + this.length(); ++i) {
                score += this.scoreOf(sequence, i);
            }
            return score;
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            int[] tagsAtPos = this.getPossibleValues(pos);
            double[] scores = new double[tagsAtPos.length];
            for (int t = 0; t < tagsAtPos.length; ++t) {
                tags[pos] = tagsAtPos[t];
                scores[t] = this.scoreOf(tags, pos);
            }
            return scores;
        }

        @Override
        public int[] correctAnswers() {
            return this.correctTags;
        }

        @Override
        public double bestSequenceScore() {
            return this.scoreOf(this.correctTags);
        }
    }

    public static class TestSequenceModel2
    implements TestSequenceModel {
        private final int[] correctTags = new int[]{0, 0, 7, 8, 9, 0, 0};
        private final int[] allTags = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        private final int[] midTags = new int[]{0, 1, 2, 3, 4, 5};
        private final int[] nullTags = new int[]{0};

        @Override
        public int length() {
            return this.correctTags.length - this.leftWindow() - this.rightWindow();
        }

        @Override
        public int leftWindow() {
            return 2;
        }

        @Override
        public int rightWindow() {
            return 2;
        }

        @Override
        public int[] getPossibleValues(int pos) {
            if (pos < this.leftWindow() || pos >= this.leftWindow() + this.length()) {
                return this.nullTags;
            }
            if (pos < 5) {
                return this.allTags;
            }
            return this.midTags;
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            double score = tags[pos] > tags[pos - 1] && tags[pos] <= tags[pos - 1] + 1 ? (double)tags[pos] : (tags[pos] == 0 ? 0.0 : 1.0 / (double)tags[pos]);
            return score;
        }

        @Override
        public double scoreOf(int[] sequence) {
            double score = 0.0;
            for (int i = this.leftWindow(); i < this.leftWindow() + this.length(); ++i) {
                score += this.scoreOf(sequence, i);
            }
            return score;
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            int[] tagsAtPos = this.getPossibleValues(pos);
            double[] scores = new double[tagsAtPos.length];
            for (int t = 0; t < tagsAtPos.length; ++t) {
                tags[pos] = tagsAtPos[t];
                scores[t] = this.scoreOf(tags, pos);
            }
            return scores;
        }

        @Override
        public int[] correctAnswers() {
            return this.correctTags;
        }

        @Override
        public double bestSequenceScore() {
            return this.scoreOf(this.correctTags);
        }
    }

    public static class TestSequenceModel1
    implements TestSequenceModel {
        private final int[] correctTags = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 6, 5, 4, 3, 2, 1, 0, 0};
        private final int[] allTags = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        private final int[] midTags = new int[]{0, 1, 2, 3};
        private final int[] nullTags = new int[]{0};

        @Override
        public int length() {
            return this.correctTags.length - this.leftWindow() - this.rightWindow();
        }

        @Override
        public int leftWindow() {
            return 2;
        }

        @Override
        public int rightWindow() {
            return 2;
        }

        @Override
        public int[] getPossibleValues(int pos) {
            if (pos < this.leftWindow() || pos >= this.leftWindow() + this.length()) {
                return this.nullTags;
            }
            if (this.correctTags[pos] < 4) {
                return this.midTags;
            }
            return this.allTags;
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            boolean match = true;
            for (int loc = pos - this.leftWindow(); loc <= pos + this.rightWindow(); ++loc) {
                if (tags[loc] == this.correctTags[loc]) continue;
                match = false;
            }
            if (match) {
                return pos;
            }
            return 0.0;
        }

        @Override
        public double scoreOf(int[] sequence) {
            double score = 0.0;
            for (int i = this.leftWindow(); i < this.leftWindow() + this.length(); ++i) {
                score += this.scoreOf(sequence, i);
            }
            return score;
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            int[] tagsAtPos = this.getPossibleValues(pos);
            double[] scores = new double[tagsAtPos.length];
            for (int t = 0; t < tagsAtPos.length; ++t) {
                tags[pos] = tagsAtPos[t];
                scores[t] = this.scoreOf(tags, pos);
            }
            return scores;
        }

        @Override
        public int[] correctAnswers() {
            return this.correctTags;
        }

        @Override
        public double bestSequenceScore() {
            return this.scoreOf(this.correctTags);
        }
    }

    public static interface TestSequenceModel
    extends SequenceModel {
        public int[] correctAnswers();

        public double bestSequenceScore();
    }
}

