/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.FileBackedCache;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileBackedCacheTest {
    private FileBackedCache<String, String> cache;
    private FileBackedCache<Integer, Map<String, ArrayList<String>>> mapCache;

    @Before
    public void setUp() {
        try {
            File cacheDir = File.createTempFile("cache", ".dir");
            cacheDir.delete();
            this.cache = new FileBackedCache(cacheDir);
            Assert.assertEquals((long)0L, (long)cacheDir.listFiles().length);
            File mapCacheDir = File.createTempFile("cache", ".dir");
            mapCacheDir.delete();
            this.mapCache = new FileBackedCache(mapCacheDir);
            Assert.assertEquals((long)0L, (long)mapCacheDir.listFiles().length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void tearDown() {
        if (this.cache.cacheDir.listFiles() != null) {
            for (File c : this.cache.cacheDir.listFiles()) {
                Assert.assertTrue((boolean)c.delete());
            }
            Assert.assertTrue((boolean)this.cache.cacheDir.delete());
        }
        if (this.mapCache.cacheDir.listFiles() != null) {
            for (File c : this.mapCache.cacheDir.listFiles()) {
                Assert.assertTrue((boolean)c.delete());
            }
            Assert.assertTrue((boolean)this.mapCache.cacheDir.delete());
        }
    }

    @Test
    public void testContainsLocal() {
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        Assert.assertTrue((boolean)this.cache.containsKey("key"));
        Assert.assertTrue((boolean)this.cache.containsKey("key2"));
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testGetLocal() {
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        Assert.assertEquals((Object)"value", (Object)this.cache.get("key"));
        Assert.assertEquals((Object)"value2", (Object)this.cache.get("key2"));
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testPutLocal() {
        Assert.assertEquals(null, (Object)this.cache.put("key", "value"));
        Assert.assertEquals(null, (Object)this.cache.put("key2", "value2"));
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testCacheWritingToDisk() {
        Assert.assertEquals((long)0L, (long)this.cache.cacheDir.listFiles().length);
        this.cache.put("key", "value");
        Assert.assertEquals((long)1L, (long)this.cache.cacheDir.listFiles().length);
        this.cache.put("key2", "value2");
        Assert.assertEquals((long)2L, (long)this.cache.cacheDir.listFiles().length);
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.cache.sizeInMemory());
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        Assert.assertEquals((long)2L, (long)this.cache.sizeInMemory());
        Assert.assertEquals((long)2L, (long)this.cache.size());
        this.cache.clear();
        Assert.assertEquals((long)0L, (long)this.cache.sizeInMemory());
        Assert.assertEquals((long)2L, (long)this.cache.cacheDir.listFiles().length);
        Assert.assertEquals((long)2L, (long)this.cache.size());
        Assert.assertEquals((long)2L, (long)this.cache.sizeInMemory());
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testContainsFile() {
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        this.cache.clear();
        Assert.assertTrue((boolean)this.cache.containsKey("key"));
        Assert.assertTrue((boolean)this.cache.containsKey("key2"));
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testContainsRemoveFromMemory() {
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        this.cache.removeFromMemory("key");
        Assert.assertEquals((long)1L, (long)this.cache.sizeInMemory());
        Assert.assertTrue((boolean)this.cache.containsKey("key"));
        Assert.assertTrue((boolean)this.cache.containsKey("key2"));
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testPutFile() {
        this.cache.put("key", "value");
        Assert.assertEquals((Object)"value", (Object)this.cache.put("key", "valueReplaced"));
        Assert.assertEquals((Object)"valueReplaced", (Object)this.cache.get("key"));
        this.cache.put("key", "value");
        this.cache.clear();
        Assert.assertEquals((Object)"value", (Object)this.cache.put("key", "valueReplaced"));
        this.cache.clear();
        Assert.assertEquals((Object)"valueReplaced", (Object)this.cache.get("key"));
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testGetFile() {
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        this.cache.clear();
        Assert.assertEquals((Object)"value", (Object)this.cache.get("key"));
        Assert.assertEquals((Object)"value2", (Object)this.cache.get("key2"));
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testIterator() {
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        int count = 0;
        for (Map.Entry<String, String> entry : this.cache) {
            if (entry.getKey() == "key") {
                Assert.assertEquals((Object)"value", (Object)entry.getValue());
            }
            if (entry.getKey() == "key2") {
                Assert.assertEquals((Object)"value2", (Object)entry.getValue());
            }
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testComprehension() {
        this.cache.put("key", "value");
        this.cache.put("key2", "value2");
        int count = 0;
        for (Map.Entry<String, String> entry : this.cache) {
            if (entry.getKey() == "key") {
                Assert.assertEquals((Object)"value", (Object)entry.getValue());
            }
            if (entry.getKey() == "key2") {
                Assert.assertEquals((Object)"value2", (Object)entry.getValue());
            }
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testCollision() throws IOException {
        File cacheDir = File.createTempFile("cache", ".dir");
        cacheDir.delete();
        FileBackedCache<CustomHash, String> myCache = new FileBackedCache<CustomHash, String>(cacheDir);
        Assert.assertEquals((long)0L, (long)cacheDir.listFiles().length);
        myCache.put(new CustomHash(0, 0), "zero");
        myCache.put(new CustomHash(1, 0), "one");
        myCache.put(new CustomHash(1, 1), "one'");
        Assert.assertEquals((Object)"zero", myCache.get(new CustomHash(0, 0)));
        Assert.assertEquals((Object)"one", myCache.get(new CustomHash(1, 0)));
        Assert.assertEquals((Object)"one'", myCache.get(new CustomHash(1, 1)));
        myCache.clear();
        Assert.assertEquals((long)0L, (long)myCache.sizeInMemory());
        Assert.assertEquals((Object)"zero", myCache.get(new CustomHash(0, 0)));
        Assert.assertEquals((Object)"one", myCache.get(new CustomHash(1, 0)));
        Assert.assertEquals((Object)"one'", myCache.get(new CustomHash(1, 1)));
        FileBackedCache<CustomHash, String> reload = new FileBackedCache<CustomHash, String>(cacheDir);
        Assert.assertEquals((Object)"zero", reload.get(new CustomHash(0, 0)));
        Assert.assertEquals((Object)"one", reload.get(new CustomHash(1, 0)));
        Assert.assertEquals((Object)"one'", reload.get(new CustomHash(1, 1)));
        reload.put(new CustomHash(2, 0), "two");
        Assert.assertEquals((Object)"two", reload.get(new CustomHash(2, 0)));
        for (File c : this.cache.cacheDir.listFiles()) {
            Assert.assertTrue((boolean)c.delete());
        }
        Assert.assertTrue((boolean)this.cache.cacheDir.delete());
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testMerge() throws IOException {
        this.cache.put("key", "value");
        File constituent1File = File.createTempFile("cache", ".dir");
        Assert.assertTrue((boolean)constituent1File.delete());
        FileBackedCache<String, String> constituent1 = new FileBackedCache<String, String>(constituent1File);
        File constituent2File = File.createTempFile("cache", ".dir");
        Assert.assertTrue((boolean)constituent2File.delete());
        FileBackedCache<String, String> constituent2 = new FileBackedCache<String, String>(constituent2File);
        constituent1.put("c1Key1", "constituent1a");
        constituent1.put("c1Key2", "constituent1b");
        constituent1.put("c1Key3", "overlap");
        constituent2.put("c2Key1", "constituent2a");
        constituent2.put("c2Key2", "constituent2b");
        constituent2.put("c1Key3", "overlapReplaced");
        constituent1.clear();
        constituent2.clear();
        FileBackedCache.merge(this.cache, new FileBackedCache[]{constituent1, constituent2});
        Assert.assertEquals((Object)"value", (Object)this.cache.get("key"));
        this.cache.clear();
        Assert.assertEquals((Object)"constituent1a", (Object)this.cache.get("c1Key1"));
        Assert.assertEquals((Object)"constituent1b", (Object)this.cache.get("c1Key2"));
        Assert.assertEquals((Object)"constituent2a", (Object)this.cache.get("c2Key1"));
        Assert.assertEquals((Object)"constituent2b", (Object)this.cache.get("c2Key2"));
        Assert.assertEquals((Object)"overlapReplaced", (Object)this.cache.get("c1Key3"));
        if (constituent1File.listFiles() != null) {
            for (File c : constituent1File.listFiles()) {
                Assert.assertTrue((boolean)c.delete());
            }
            Assert.assertTrue((boolean)constituent1File.delete());
        }
        if (constituent2File.listFiles() != null) {
            for (File c : constituent2File.listFiles()) {
                Assert.assertTrue((boolean)c.delete());
            }
            Assert.assertTrue((boolean)constituent2File.delete());
        }
        Assert.assertTrue((boolean)FileBackedCache.locksHeld().isEmpty());
    }

    @Test
    public void testMapValueGoodPattern() throws IOException {
        HashMap map = new HashMap();
        map.put("foo", new ArrayList());
        this.mapCache.put(42, map);
        Assert.assertEquals((long)1L, (long)this.mapCache.get(42).size());
        this.mapCache.clear();
        Assert.assertEquals((long)1L, (long)this.mapCache.get(42).size());
    }

    private static class CustomHash
    implements Serializable {
        private int unique;
        private int hash;

        private CustomHash(int unique, int hash) {
            this.unique = unique;
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            return o instanceof CustomHash && ((CustomHash)o).unique == this.unique;
        }

        public String toString() {
            return "CustomHash(id=" + this.unique + ", hash=" + this.hash + ")";
        }
    }
}

