/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Sets;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class SetsTest
extends TestCase {
    private Set<String> s1;
    private Set<String> s2;

    public void setUp() {
        this.s1 = new HashSet<String>();
        this.s1.add("apple");
        this.s1.add("banana");
        this.s1.add("cherry");
        this.s1.add("dingleberry");
        this.s2 = new HashSet<String>();
        this.s2.add("apple");
        this.s2.add("banana");
        this.s2.add("cranberry");
    }

    public void testCross() {
        Set<Pair<String, String>> cross = Sets.cross(this.s1, this.s2);
        SetsTest.assertEquals((int)cross.size(), (int)12);
        Pair<String, String> p = new Pair<String, String>("dingleberry", "cranberry");
        SetsTest.assertTrue((boolean)cross.contains(p));
    }

    public void testDiff() {
        Set<String> diff = Sets.diff(this.s1, this.s2);
        SetsTest.assertEquals((int)diff.size(), (int)2);
        SetsTest.assertTrue((boolean)diff.contains("cherry"));
        SetsTest.assertFalse((boolean)diff.contains("apple"));
    }

    public void testUnion() {
        Set<String> union = Sets.union(this.s1, this.s2);
        SetsTest.assertEquals((int)union.size(), (int)5);
        SetsTest.assertTrue((boolean)union.contains("cherry"));
        SetsTest.assertFalse((boolean)union.contains("fungus"));
    }

    public void testIntersection() {
        Set<String> intersection = Sets.intersection(this.s1, this.s2);
        SetsTest.assertEquals((int)intersection.size(), (int)2);
        SetsTest.assertTrue((boolean)intersection.contains("apple"));
        SetsTest.assertFalse((boolean)intersection.contains("cherry"));
    }

    public void testPowerset() {
        Set<Set<String>> pow = Sets.powerSet(this.s1);
        SetsTest.assertEquals((int)pow.size(), (int)16);
    }
}

