/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.TwoDimensionalCollectionValuedMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ThreeDimensionalCollectionValuedMap<K1, K2, K3, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K1, TwoDimensionalCollectionValuedMap<K2, K3, V>> map = Generics.newHashMap();

    public String toString() {
        return this.map.toString();
    }

    public TwoDimensionalCollectionValuedMap<K2, K3, V> getTwoDimensionalCollectionValuedMap(K1 key1) {
        TwoDimensionalCollectionValuedMap<Object, Object, V> cvm = this.map.get(key1);
        if (cvm == null) {
            cvm = new TwoDimensionalCollectionValuedMap();
            this.map.put(key1, cvm);
        }
        return cvm;
    }

    public Collection<V> get(K1 key1, K2 key2, K3 key3) {
        return this.getTwoDimensionalCollectionValuedMap(key1).getCollectionValuedMap(key2).get(key3);
    }

    public void add(K1 key1, K2 key2, K3 key3, V value) {
        TwoDimensionalCollectionValuedMap<K3, K3, V> cvm = this.getTwoDimensionalCollectionValuedMap(key1);
        cvm.add(key2, key3, value);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K1> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(K1 key) {
        return this.map.containsKey(key);
    }
}

