/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.alg.dense.misc.UnrolledDeterminantFromMinor;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;

public class DeterminantFromMinor {
    private int width;
    private int minWidth;
    private int[] levelIndexes;
    private double[] levelResults;
    private int[] levelRemoved;
    private int[] open;
    private int numOpen;
    private DenseMatrix64F tempMat;
    private boolean dirty = false;

    public DeterminantFromMinor(int n) {
        this(n, 5);
    }

    public DeterminantFromMinor(int n, int n2) {
        if (n2 > 5 || n2 < 2) {
            throw new IllegalArgumentException("No direct function for that width");
        }
        if (n < n2) {
            n2 = n;
        }
        this.minWidth = n2;
        this.width = n;
        int n3 = n - (n2 - 2);
        this.levelResults = new double[n3];
        this.levelRemoved = new int[n3];
        this.levelIndexes = new int[n3];
        this.open = new int[n];
        this.tempMat = new DenseMatrix64F(n2 - 1, n2 - 1);
    }

    public double compute(RowD1Matrix64F rowD1Matrix64F) {
        if (this.width != rowD1Matrix64F.numCols || this.width != rowD1Matrix64F.numRows) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        this.initStructures();
        int n = 0;
        while (true) {
            int n2;
            double d;
            int n3;
            int n4;
            if ((n4 = this.levelIndexes[n]) == (n3 = this.width - n)) {
                if (n == 0) {
                    return this.levelResults[0];
                }
                int n5 = n - 1;
                this.levelIndexes[n5] = this.levelIndexes[n5] + 1;
                d = rowD1Matrix64F.get((n - 1) * this.width + this.levelRemoved[n - 1]);
                if (n2 % 2 == 0) {
                    int n6 = n - 1;
                    this.levelResults[n6] = this.levelResults[n6] + d * this.levelResults[n];
                } else {
                    int n7 = n - 1;
                    this.levelResults[n7] = this.levelResults[n7] - d * this.levelResults[n];
                }
                this.putIntoOpen(n - 1);
                this.levelResults[n] = 0.0;
                this.levelIndexes[n] = 0;
                --n;
                continue;
            }
            this.levelRemoved[n] = n2 = this.openRemove(n4);
            if (n3 == this.minWidth) {
                this.createMinor(rowD1Matrix64F);
                d = rowD1Matrix64F.get(n * this.width + this.levelRemoved[n]);
                d *= UnrolledDeterminantFromMinor.det(this.tempMat);
                if (n4 % 2 == 0) {
                    int n8 = n;
                    this.levelResults[n8] = this.levelResults[n8] + d;
                } else {
                    int n9 = n;
                    this.levelResults[n9] = this.levelResults[n9] - d;
                }
                this.putIntoOpen(n);
                int n10 = n;
                this.levelIndexes[n10] = this.levelIndexes[n10] + 1;
                continue;
            }
            ++n;
        }
    }

    private void initStructures() {
        int n;
        for (n = 0; n < this.width; ++n) {
            this.open[n] = n;
        }
        this.numOpen = this.width;
        if (this.dirty) {
            for (n = 0; n < this.levelIndexes.length; ++n) {
                this.levelIndexes[n] = 0;
                this.levelResults[n] = 0.0;
                this.levelRemoved[n] = 0;
            }
        }
        this.dirty = true;
    }

    private int openRemove(int n) {
        int n2 = this.open[n];
        System.arraycopy(this.open, n + 1, this.open, n, this.numOpen - n - 1);
        --this.numOpen;
        return n2;
    }

    private void openAdd(int n, int n2) {
        for (int i = this.numOpen; i > n; --i) {
            this.open[i] = this.open[i - 1];
        }
        ++this.numOpen;
        this.open[n] = n2;
    }

    private void openAdd(int n) {
        this.open[this.numOpen++] = n;
    }

    private void putIntoOpen(int n) {
        boolean bl = false;
        for (int i = 0; i < this.numOpen; ++i) {
            if (this.open[i] <= this.levelRemoved[n]) continue;
            bl = true;
            this.openAdd(i, this.levelRemoved[n]);
            break;
        }
        if (!bl) {
            this.openAdd(this.levelRemoved[n]);
        }
    }

    private void createMinor(RowD1Matrix64F rowD1Matrix64F) {
        int n = this.minWidth - 1;
        int n2 = (this.width - n) * this.width;
        for (int i = 0; i < this.numOpen; ++i) {
            int n3 = this.open[i];
            int n4 = n2 + n3;
            int n5 = i;
            for (int j = 0; j < n; ++j) {
                this.tempMat.set(n5, rowD1Matrix64F.get(n4));
                n5 += n;
                n4 += this.width;
            }
        }
    }
}

