/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import edu.stanford.nlp.loglinear.model.ConcatVector;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConcatVectorNamespace {
    final Map<String, Integer> featureToIndex = new HashMap<String, Integer>();
    final Map<String, Map<String, Integer>> sparseFeatureIndex = new HashMap<String, Map<String, Integer>>();
    final Map<String, Map<Integer, String>> reverseSparseFeatureIndex = new HashMap<String, Map<Integer, String>>();

    public ConcatVector newVector() {
        return new ConcatVector(this.featureToIndex.size());
    }

    public ConcatVector newWeightsVector() {
        ConcatVector vector = new ConcatVector(this.featureToIndex.size());
        for (String s : this.sparseFeatureIndex.keySet()) {
            int size = this.sparseFeatureIndex.get(s).size();
            vector.setDenseComponent(this.ensureFeature(s), new double[size]);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ensureFeature(String featureName) {
        Map<String, Integer> map = this.featureToIndex;
        synchronized (map) {
            if (!this.featureToIndex.containsKey(featureName)) {
                this.featureToIndex.put(featureName, this.featureToIndex.size());
            }
            return this.featureToIndex.get(featureName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ensureSparseFeature(String featureName, String index) {
        this.ensureFeature(featureName);
        Map<String, Map<String, Integer>> map = this.sparseFeatureIndex;
        synchronized (map) {
            if (!this.sparseFeatureIndex.containsKey(featureName)) {
                this.sparseFeatureIndex.put(featureName, new HashMap());
                this.reverseSparseFeatureIndex.put(featureName, new HashMap());
            }
        }
        Map<String, Integer> sparseIndex = this.sparseFeatureIndex.get(featureName);
        Map<Integer, String> reverseSparseIndex = this.reverseSparseFeatureIndex.get(featureName);
        Map<String, Integer> map2 = sparseIndex;
        synchronized (map2) {
            if (!sparseIndex.containsKey(index)) {
                reverseSparseIndex.put(sparseIndex.size(), index);
                sparseIndex.put(index, sparseIndex.size());
            }
            return sparseIndex.get(index);
        }
    }

    public void setDenseFeature(ConcatVector vector, String featureName, double[] value) {
        vector.setDenseComponent(this.ensureFeature(featureName), value);
    }

    public void setSparseFeature(ConcatVector vector, String featureName, String index, double value) {
        vector.setSparseComponent(this.ensureFeature(featureName), this.ensureSparseFeature(featureName, index), value);
    }

    public void debugVector(ConcatVector vector, BufferedWriter bw) throws IOException {
        for (String key : this.featureToIndex.keySet()) {
            bw.write(key);
            bw.write(":\n");
            int i = this.featureToIndex.get(key);
            if (vector.isComponentSparse(i)) {
                this.debugFeatureValue(key, vector.getSparseIndex(i), vector, bw);
                continue;
            }
            double[] arr = vector.getDenseComponent(i);
            for (int j = 0; j < arr.length; ++j) {
                this.debugFeatureValue(key, j, vector, bw);
            }
        }
    }

    private void debugFeatureValue(String feature, int index, ConcatVector vector, BufferedWriter bw) throws IOException {
        bw.write("\t");
        if (this.sparseFeatureIndex.containsKey(feature) && this.sparseFeatureIndex.get(feature).values().contains(index)) {
            bw.write(this.reverseSparseFeatureIndex.get(feature).get(index));
        } else {
            bw.write(Integer.toString(index));
        }
        bw.write(": ");
        bw.write(Double.toString(vector.getValueAt(this.featureToIndex.get(feature), index)));
        bw.write("\n");
    }
}

