/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.math;

import edu.stanford.nlp.math.ArrayMath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArrayMathTest {
    private double[] d1 = new double[3];
    private double[] d2 = new double[3];
    private double[] d3 = new double[3];
    private double[] d4 = new double[3];
    private double[] d5 = new double[4];

    @Before
    public void setUp() {
        this.d1[0] = 1.0;
        this.d1[1] = 343.33;
        this.d1[2] = -13.1;
        this.d2[0] = 1.0;
        this.d2[1] = 343.33;
        this.d2[2] = -13.1;
        this.d3[0] = Double.NaN;
        this.d3[1] = Double.POSITIVE_INFINITY;
        this.d3[2] = 2.0;
        this.d4[0] = 0.1;
        this.d4[1] = 0.2;
        this.d4[2] = 0.3;
        this.d5[0] = 0.1;
        this.d5[1] = 0.2;
        this.d5[2] = 0.3;
        this.d5[3] = 0.8;
    }

    @Test
    public void testInnerProduct() {
        double inner = ArrayMath.innerProduct(this.d4, this.d4);
        Assert.assertEquals((String)"Wrong inner product", (double)0.14, (double)inner, (double)1.0E-6);
        inner = ArrayMath.innerProduct(this.d5, this.d5);
        Assert.assertEquals((String)"Wrong inner product", (double)0.78, (double)inner, (double)1.0E-6);
    }

    @Test
    public void testNumRows() {
        int nRows = ArrayMath.numRows(this.d1);
        Assert.assertEquals((long)nRows, (long)3L);
    }

    @Test
    public void testExpLog() {
        double[] d1prime = ArrayMath.log(ArrayMath.exp(this.d1));
        double[] diff = ArrayMath.pairwiseSubtract(this.d1, d1prime);
        double norm2 = ArrayMath.norm(diff);
        Assert.assertEquals((double)0.0, (double)norm2, (double)1.0E-5);
    }

    @Test
    public void testExpLogInplace() {
        ArrayMath.expInPlace(this.d1);
        ArrayMath.logInPlace(this.d1);
        ArrayMath.pairwiseSubtractInPlace(this.d1, this.d2);
        double norm2 = ArrayMath.norm(this.d1);
        Assert.assertEquals((double)0.0, (double)norm2, (double)1.0E-5);
    }

    @Test
    public void testAddInPlace() {
        ArrayMath.addInPlace(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            Assert.assertEquals((double)this.d1[i], (double)(this.d2[i] + 3.0), (double)1.0E-5);
        }
    }

    @Test
    public void testMultiplyInPlace() {
        ArrayMath.multiplyInPlace(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            Assert.assertEquals((double)this.d1[i], (double)(this.d2[i] * 3.0), (double)1.0E-5);
        }
    }

    @Test
    public void testPowInPlace() {
        ArrayMath.powInPlace(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            Assert.assertEquals((double)this.d1[i], (double)Math.pow(this.d2[i], 3.0), (double)1.0E-5);
        }
    }

    @Test
    public void testAdd() {
        double[] d1prime = ArrayMath.add(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(d1prime); ++i) {
            Assert.assertEquals((double)d1prime[i], (double)(this.d1[i] + 3.0), (double)1.0E-5);
        }
    }

    @Test
    public void testMultiply() {
        double[] d1prime = ArrayMath.multiply(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(d1prime); ++i) {
            Assert.assertEquals((double)d1prime[i], (double)(this.d1[i] * 3.0), (double)1.0E-5);
        }
    }

    @Test
    public void testPow() {
        double[] d1prime = ArrayMath.pow(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(d1prime); ++i) {
            Assert.assertEquals((double)d1prime[i], (double)Math.pow(this.d1[i], 3.0), (double)1.0E-5);
        }
    }

    @Test
    public void testPairwiseAdd() {
        double[] sum = ArrayMath.pairwiseAdd(this.d1, this.d2);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            Assert.assertEquals((double)sum[i], (double)(this.d1[i] + this.d2[i]), (double)1.0E-5);
        }
    }

    @Test
    public void testPairwiseSubtract() {
        double[] diff = ArrayMath.pairwiseSubtract(this.d1, this.d2);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            Assert.assertEquals((double)diff[i], (double)(this.d1[i] - this.d2[i]), (double)1.0E-5);
        }
    }

    @Test
    public void testPairwiseMultiply() {
        double[] product = ArrayMath.pairwiseMultiply(this.d1, this.d2);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            Assert.assertEquals((double)product[i], (double)(this.d1[i] * this.d2[i]), (double)1.0E-5);
        }
    }

    @Test
    public void testHasNaN() {
        Assert.assertFalse((boolean)ArrayMath.hasNaN(this.d1));
        Assert.assertFalse((boolean)ArrayMath.hasNaN(this.d2));
        Assert.assertTrue((boolean)ArrayMath.hasNaN(this.d3));
    }

    @Test
    public void testHasInfinite() {
        Assert.assertFalse((boolean)ArrayMath.hasInfinite(this.d1));
        Assert.assertFalse((boolean)ArrayMath.hasInfinite(this.d2));
        Assert.assertTrue((boolean)ArrayMath.hasInfinite(this.d3));
    }

    @Test
    public void testCountNaN() {
        Assert.assertEquals((long)ArrayMath.countNaN(this.d1), (long)0L);
        Assert.assertEquals((long)ArrayMath.countNaN(this.d2), (long)0L);
        Assert.assertEquals((long)ArrayMath.countNaN(this.d3), (long)1L);
    }

    @Test
    public void testFliterNaN() {
        double[] f_d3 = ArrayMath.filterNaN(this.d3);
        Assert.assertEquals((long)ArrayMath.numRows(f_d3), (long)2L);
        Assert.assertEquals((long)ArrayMath.countNaN(f_d3), (long)0L);
    }

    @Test
    public void testCountInfinite() {
        Assert.assertEquals((long)ArrayMath.countInfinite(this.d1), (long)0L);
        Assert.assertEquals((long)ArrayMath.countInfinite(this.d2), (long)0L);
        Assert.assertEquals((long)ArrayMath.countInfinite(this.d3), (long)1L);
    }

    @Test
    public void testFliterInfinite() {
        double[] f_d3 = ArrayMath.filterInfinite(this.d3);
        Assert.assertEquals((long)ArrayMath.numRows(f_d3), (long)2L);
        Assert.assertEquals((long)ArrayMath.countInfinite(f_d3), (long)0L);
    }

    @Test
    public void testFliterNaNAndInfinite() {
        double[] f_d3 = ArrayMath.filterNaNAndInfinite(this.d3);
        Assert.assertEquals((long)ArrayMath.numRows(f_d3), (long)1L);
        Assert.assertEquals((long)ArrayMath.countInfinite(f_d3), (long)0L);
        Assert.assertEquals((long)ArrayMath.countNaN(f_d3), (long)0L);
    }

    @Test
    public void testSum() {
        double sum = ArrayMath.sum(this.d1);
        double mySum = 0.0;
        for (double d : this.d1) {
            mySum += d;
        }
        Assert.assertEquals((double)sum, (double)mySum, (double)1.0E-6);
    }

    @Test
    public void testNorm_inf() {
        double ninf = ArrayMath.norm_inf(this.d1);
        double max = ArrayMath.max(this.d1);
        Assert.assertEquals((double)ninf, (double)max, (double)1.0E-6);
        ninf = ArrayMath.norm_inf(this.d2);
        max = ArrayMath.max(this.d2);
        Assert.assertEquals((double)ninf, (double)max, (double)1.0E-6);
        ninf = ArrayMath.norm_inf(this.d3);
        max = ArrayMath.max(this.d3);
        Assert.assertEquals((double)ninf, (double)max, (double)1.0E-6);
    }

    @Test
    public void testArgmax() {
        Assert.assertEquals((double)ArrayMath.max(this.d1), (double)this.d1[ArrayMath.argmax(this.d1)], (double)1.0E-5);
        Assert.assertEquals((double)ArrayMath.max(this.d2), (double)this.d2[ArrayMath.argmax(this.d2)], (double)1.0E-5);
        Assert.assertEquals((double)ArrayMath.max(this.d3), (double)this.d3[ArrayMath.argmax(this.d3)], (double)1.0E-5);
    }

    @Test
    public void testArgmin() {
        Assert.assertEquals((double)ArrayMath.min(this.d1), (double)this.d1[ArrayMath.argmin(this.d1)], (double)1.0E-5);
        Assert.assertEquals((double)ArrayMath.min(this.d2), (double)this.d2[ArrayMath.argmin(this.d2)], (double)1.0E-5);
        Assert.assertEquals((double)ArrayMath.min(this.d3), (double)this.d3[ArrayMath.argmin(this.d3)], (double)1.0E-5);
    }

    @Test
    public void testLogSum() {
        double lsum = ArrayMath.logSum(this.d4);
        double myLsum = 0.0;
        for (double d : this.d4) {
            myLsum += Math.exp(d);
        }
        myLsum = Math.log(myLsum);
        Assert.assertEquals((double)myLsum, (double)lsum, (double)1.0E-5);
    }

    @Test
    public void testNormalize() {
        double tol = 1.0E-5;
        ArrayMath.normalize(this.d1);
        ArrayMath.normalize(this.d2);
        ArrayMath.normalize(this.d4);
        Assert.assertEquals((double)1.0, (double)ArrayMath.sum(this.d1), (double)tol);
        Assert.assertEquals((double)1.0, (double)ArrayMath.sum(this.d2), (double)tol);
        Assert.assertEquals((double)1.0, (double)ArrayMath.sum(this.d4), (double)tol);
    }

    @Test
    public void testKLDivergence() {
        double kld = ArrayMath.klDivergence(this.d1, this.d2);
        Assert.assertEquals((double)0.0, (double)kld, (double)1.0E-5);
    }

    @Test
    public void testSumAndMean() {
        Assert.assertEquals((double)ArrayMath.sum(this.d1), (double)(ArrayMath.mean(this.d1) * (double)this.d1.length), (double)1.0E-5);
        Assert.assertEquals((double)ArrayMath.sum(this.d2), (double)(ArrayMath.mean(this.d2) * (double)this.d2.length), (double)1.0E-5);
        Assert.assertEquals((double)ArrayMath.sum(this.d3), (double)(ArrayMath.mean(this.d3) * (double)this.d3.length), (double)1.0E-5);
        Assert.assertEquals((double)ArrayMath.sum(this.d4), (double)(ArrayMath.mean(this.d4) * (double)this.d4.length), (double)1.0E-5);
    }

    private static void helpTestSafeSumAndMean(double[] d) {
        double[] dprime = ArrayMath.filterNaNAndInfinite(d);
        Assert.assertEquals((double)(ArrayMath.safeMean(d) * (double)ArrayMath.numRows(dprime)), (double)ArrayMath.sum(dprime), (double)1.0E-5);
    }

    @Test
    public void testSafeSumAndMean() {
        ArrayMathTest.helpTestSafeSumAndMean(this.d1);
        ArrayMathTest.helpTestSafeSumAndMean(this.d2);
        ArrayMathTest.helpTestSafeSumAndMean(this.d3);
        ArrayMathTest.helpTestSafeSumAndMean(this.d4);
    }

    @Test
    public void testJensenShannon() {
        double[] a = new double[]{0.1, 0.1, 0.7, 0.1, 0.0, 0.0};
        double[] b = new double[]{0.0, 0.1, 0.1, 0.7, 0.1, 0.0};
        Assert.assertEquals((double)0.46514844544032313, (double)ArrayMath.jensenShannonDivergence(a, b), (double)1.0E-5);
        double[] c = new double[]{1.0, 0.0, 0.0};
        double[] d = new double[]{0.0, 0.5, 0.5};
        Assert.assertEquals((double)1.0, (double)ArrayMath.jensenShannonDivergence(c, d), (double)1.0E-5);
    }

    @Test
    public void test2dAdd() {
        double[][] d6 = new double[][]{{0.26, 0.87, -1.26}, {0.17, 3.21, -1.8}};
        double[][] d7 = new double[][]{{0.26, 0.07, -1.26}, {0.17, -3.21, -1.8}};
        double[][] d8 = new double[][]{{0.52, 0.94, -2.52}, {0.34, 0.0, -3.6}};
        ArrayMath.addInPlace(d6, d7);
        for (int i = 0; i < d8.length; ++i) {
            for (int j = 0; j < d8[i].length; ++j) {
                Assert.assertEquals((double)d6[i][j], (double)d8[i][j], (double)1.0E-5);
            }
        }
    }
}

