/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.math;

import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.util.Triple;
import junit.framework.TestCase;

public class SloppyMathTest
extends TestCase {
    public void setUp() {
    }

    public void testRound1() {
        SloppyMathTest.assertEquals((Object)0.0, (Object)SloppyMath.round(0.499));
        SloppyMathTest.assertEquals((Object)0.0, (Object)SloppyMath.round(-0.5));
        SloppyMathTest.assertEquals((Object)10.0, (Object)SloppyMath.round(10.0));
        SloppyMathTest.assertEquals((Object)10.0, (Object)SloppyMath.round(10.32));
    }

    public void testRound2() {
        SloppyMathTest.assertEquals((Object)3.14, (Object)SloppyMath.round(Math.PI, 2));
        SloppyMathTest.assertEquals((Object)400.0, (Object)SloppyMath.round(431.5, -2));
        SloppyMathTest.assertEquals((Object)432.0, (Object)SloppyMath.round(431.5, 0));
        SloppyMathTest.assertEquals((Object)0.0, (Object)SloppyMath.round(-0.05, 1));
        SloppyMathTest.assertEquals((Object)-0.05, (Object)SloppyMath.round(-0.05, 2));
    }

    public void testMax() {
        SloppyMathTest.assertEquals((int)3, (int)SloppyMath.max(1, 2, 3));
    }

    public void testMin() {
        SloppyMathTest.assertEquals((int)1, (int)SloppyMath.min(1, 2, 3));
    }

    public void testIsDangerous() {
        SloppyMathTest.assertTrue((SloppyMath.isDangerous(Double.POSITIVE_INFINITY) && SloppyMath.isDangerous(Double.NaN) && SloppyMath.isDangerous(0.0) ? 1 : 0) != 0);
    }

    public void testIsVeryDangerous() {
        SloppyMathTest.assertTrue((SloppyMath.isDangerous(Double.POSITIVE_INFINITY) && SloppyMath.isDangerous(Double.NaN) ? 1 : 0) != 0);
    }

    public void testLogAdd() {
        double d1 = 0.1;
        double d2 = 0.2;
        double lsum = SloppyMath.logAdd(d1, d2);
        double myLsum = 0.0;
        myLsum += Math.exp(d1);
        myLsum += Math.exp(d2);
        SloppyMathTest.assertTrue(((myLsum = Math.log(myLsum)) == lsum ? 1 : 0) != 0);
    }

    public void testIntPow() {
        SloppyMathTest.assertTrue(((double)SloppyMath.intPow(3, 5) == Math.pow(3.0, 5.0) ? 1 : 0) != 0);
        SloppyMathTest.assertTrue((SloppyMath.intPow(3.3, 5) - Math.pow(3.3, 5.0) < 1.0E-4 ? 1 : 0) != 0);
        SloppyMathTest.assertEquals((int)1, (int)SloppyMath.intPow(5, 0));
        SloppyMathTest.assertEquals((int)3125, (int)SloppyMath.intPow(5, 5));
        SloppyMathTest.assertEquals((int)32, (int)SloppyMath.intPow(2, 5));
        SloppyMathTest.assertEquals((int)3, (int)SloppyMath.intPow(3, 1));
        SloppyMathTest.assertEquals((double)1158.56201, (double)SloppyMath.intPow(4.1, 5), (double)1.0E-4);
        SloppyMathTest.assertEquals((double)1158.56201171875, (double)SloppyMath.intPow(4.1f, 5), (double)0.01);
    }

    public void testArccos() {
        SloppyMathTest.assertEquals((double)Math.PI, (double)SloppyMath.acos(-1.0), (double)0.001);
        SloppyMathTest.assertEquals((double)0.0, (double)SloppyMath.acos(1.0), (double)0.001);
        SloppyMathTest.assertEquals((double)1.5707963267948966, (double)SloppyMath.acos(0.0), (double)0.001);
        for (double x = -1.0; x < 1.0; x += 0.001) {
            SloppyMathTest.assertEquals((double)Math.acos(x), (double)SloppyMath.acos(x), (double)0.001);
        }
        try {
            SloppyMath.acos(-1.0000001);
            SloppyMathTest.assertFalse((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            SloppyMath.acos(1.0000001);
            SloppyMathTest.assertFalse((boolean)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPythonMod() {
        SloppyMathTest.assertEquals((int)0, (int)SloppyMath.pythonMod(9, 3));
        SloppyMathTest.assertEquals((int)0, (int)SloppyMath.pythonMod(-9, 3));
        SloppyMathTest.assertEquals((int)0, (int)SloppyMath.pythonMod(9, -3));
        SloppyMathTest.assertEquals((int)0, (int)SloppyMath.pythonMod(-9, -3));
        SloppyMathTest.assertEquals((int)2, (int)SloppyMath.pythonMod(8, 3));
        SloppyMathTest.assertEquals((int)1, (int)SloppyMath.pythonMod(-8, 3));
        SloppyMathTest.assertEquals((int)-1, (int)SloppyMath.pythonMod(8, -3));
        SloppyMathTest.assertEquals((int)-2, (int)SloppyMath.pythonMod(-8, -3));
    }

    public void testParseDouble() {
        for (int base = -10; base < 10; ++base) {
            if (base == 0) continue;
            for (int exponent = -100; exponent < 100; ++exponent) {
                double number = Math.pow(Math.PI * (double)base, exponent);
                Triple<Boolean, Long, Integer> parts = SloppyMath.segmentDouble(number);
                double parsed = SloppyMath.parseDouble((Boolean)parts.first, (Long)parts.second, (Integer)parts.third);
                SloppyMathTest.assertEquals((double)number, (double)parsed, (double)(Math.abs(parsed) / 100000.0));
            }
        }
    }

    public void testParseInt() {
        SloppyMathTest.assertEquals((long)42L, (long)SloppyMath.parseInt("42"));
        SloppyMathTest.assertEquals((long)-42L, (long)SloppyMath.parseInt("-42"));
        SloppyMathTest.assertEquals((long)42000000000000L, (long)SloppyMath.parseInt("42000000000000"));
    }
}

