/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SentenceFragment {
    public final List<CoreLabel> words = new ArrayList<CoreLabel>();
    public final SemanticGraph parseTree;
    public final boolean assumedTruth;
    public double score = 1.0;

    public SentenceFragment(SemanticGraph tree, boolean assumedTruth, boolean copy) {
        this.parseTree = copy ? new SemanticGraph(tree) : tree;
        this.assumedTruth = assumedTruth;
        this.words.addAll(this.parseTree.vertexListSorted().stream().map(IndexedWord::backingLabel).collect(Collectors.toList()));
    }

    public int length() {
        return this.words.size();
    }

    public SentenceFragment changeScore(double score) {
        this.score = score;
        return this;
    }

    public List<CoreLabel> paddedWords() {
        int maxIndex = -1;
        for (IndexedWord vertex : this.parseTree.vertexSet()) {
            maxIndex = Math.max(maxIndex, vertex.index());
        }
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(maxIndex);
        for (int i = 0; i < maxIndex; ++i) {
            tokens.add(null);
        }
        for (CoreLabel token : this.words) {
            tokens.set(token.index() - 1, token);
        }
        return tokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SentenceFragment)) {
            return false;
        }
        SentenceFragment that = (SentenceFragment)o;
        return this.parseTree.vertexSet().equals(that.parseTree.vertexSet());
    }

    public int hashCode() {
        return this.parseTree.vertexSet().hashCode();
    }

    public String toString() {
        ArrayList<Pair<String, Integer>> glosses = new ArrayList<Pair<String, Integer>>();
        for (CoreLabel word : this.words) {
            glosses.add(Pair.makePair(word.word(), word.index() - 1));
            String addedConnective = null;
            for (SemanticGraphEdge edge : this.parseTree.incomingEdgeIterable(new IndexedWord(word))) {
                String rel = edge.getRelation().toString();
                if (!rel.contains("_")) continue;
                addedConnective = rel.substring(rel.indexOf(95) + 1);
            }
            if (addedConnective == null) continue;
            Pair<Integer, Integer> yield = this.parseTree.yieldSpan(new IndexedWord(word));
            glosses.add(Pair.makePair(addedConnective.replaceAll("_", " "), (Integer)yield.first - 1));
        }
        Collections.sort(glosses, (a, b) -> (Integer)a.second - (Integer)b.second);
        return StringUtils.join(glosses.stream().map(Pair::first), " ");
    }
}

