/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EvalbFormatWriter {
    private static Redwood.RedwoodChannels log = Redwood.channels(EvalbFormatWriter.class);
    public static final String DEFAULT_GOLD_FILENAME = "parses.gld";
    public static final String DEFAULT_TEST_FILENAME = "parses.tst";
    private PrintWriter goldWriter;
    private PrintWriter testWriter;
    private int count = 0;
    private static final EvalbFormatWriter DEFAULT_WRITER = new EvalbFormatWriter();

    public void initFiles(TreebankLangParserParams tlpParams, String goldFilename, String testFilename) {
        try {
            this.goldWriter = tlpParams.pw(new FileOutputStream(goldFilename));
            this.testWriter = tlpParams.pw(new FileOutputStream(testFilename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.count = 0;
    }

    public void initFiles(TreebankLangParserParams tlpParams, String testFilename) {
        try {
            this.goldWriter = null;
            this.testWriter = tlpParams.pw(new FileOutputStream(testFilename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.count = 0;
    }

    public void writeTree(Tree test) {
        this.testWriter.println(test == null ? "(())" : test.toString());
        ++this.count;
    }

    public void writeTrees(Tree gold, Tree test) {
        this.goldWriter.println(gold == null ? "(())" : gold.toString());
        this.testWriter.println(test == null ? "(())" : test.toString());
        ++this.count;
    }

    public void closeFiles() {
        if (this.goldWriter != null) {
            this.goldWriter.close();
        }
        if (this.testWriter != null) {
            this.testWriter.close();
        }
        log.info("Wrote " + this.count + " EVALB lines.");
    }

    public static void initEVALBfiles(TreebankLangParserParams tlpParams) {
        DEFAULT_WRITER.initFiles(tlpParams, DEFAULT_GOLD_FILENAME, DEFAULT_TEST_FILENAME);
    }

    public static void closeEVALBfiles() {
        DEFAULT_WRITER.closeFiles();
    }

    public static void writeEVALBline(Tree gold, Tree test) {
        DEFAULT_WRITER.writeTrees(gold, test);
    }
}

