/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.tools;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.common.ParserGrammar;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParseAndSetLabels {
    private static final Redwood.RedwoodChannels logger = Redwood.channels(ParseAndSetLabels.class);

    private ParseAndSetLabels() {
    }

    public static void setLabels(Tree tree, Map<String, String> labelMap, MissingLabels missing, String defaultLabel, Set<String> unknowns) {
        if (tree.isLeaf()) {
            return;
        }
        String text = SentenceUtils.listToString(tree.yield());
        String label = labelMap.get(text);
        if (label != null) {
            tree.label().setValue(label);
        } else {
            switch (missing) {
                case FAIL: {
                    throw new RuntimeException("No label for '" + text + "'");
                }
                case DEFAULT: {
                    tree.label().setValue(defaultLabel);
                    unknowns.add(text);
                    break;
                }
                case KEEP_ORIGINAL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown MissingLabels mode " + (Object)((Object)missing));
                }
            }
        }
        for (Tree child : tree.children()) {
            ParseAndSetLabels.setLabels(child, labelMap, missing, defaultLabel, unknowns);
        }
    }

    public static Set<String> setLabels(List<Tree> trees, Map<String, String> labelMap, MissingLabels missing, String defaultLabel) {
        logger.info("Setting labels");
        HashSet<String> unknowns = new HashSet<String>();
        for (Tree tree : trees) {
            ParseAndSetLabels.setLabels(tree, labelMap, missing, defaultLabel, unknowns);
        }
        return unknowns;
    }

    public static void writeTrees(List<Tree> trees, String outputFile) {
        logger.info("Writing new trees to " + outputFile);
        try {
            BufferedWriter out2 = new BufferedWriter(new FileWriter(outputFile));
            for (Tree tree : trees) {
                out2.write(tree.toString());
                out2.write("\n");
            }
            out2.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static Map<String, String> readLabelMap(String labelsFile, String separator, String remapLabels) {
        logger.info("Reading labels from " + labelsFile);
        Map<Object, Object> remap = Collections.emptyMap();
        if (remapLabels != null) {
            remap = StringUtils.mapStringToMap(remapLabels);
            logger.info("Remapping labels using " + remap);
        }
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (String phrase : IOUtils.readLines(labelsFile)) {
            String[] pieces = phrase.split(separator);
            String label = pieces[pieces.length - 1];
            if (remap.containsKey(label)) {
                label = (String)remap.get(label);
            }
            labelMap.put(pieces[0], label);
        }
        return labelMap;
    }

    public static List<String> readSentences(String sentencesFile) {
        logger.info("Reading sentences from " + sentencesFile);
        ArrayList<String> sentences = new ArrayList<String>();
        for (String sentence : IOUtils.readLines(sentencesFile)) {
            sentences.add(sentence);
        }
        return sentences;
    }

    public static ParserGrammar loadParser(String parserFile, String taggerFile) {
        if (taggerFile != null) {
            return ParserGrammar.loadModel(parserFile, "-preTag", "-taggerSerializedFile", taggerFile);
        }
        return ParserGrammar.loadModel(parserFile, new String[0]);
    }

    public static List<Tree> parseSentences(List<String> sentences, ParserGrammar parser, TreeBinarizer binarizer) {
        logger.info("Parsing sentences");
        ArrayList<Tree> trees = new ArrayList<Tree>();
        for (String sentence : sentences) {
            Tree tree = parser.parse(sentence);
            if (binarizer != null) {
                tree = binarizer.transformTree(tree);
            }
            trees.add(tree);
            if (trees.size() % 1000 != 0) continue;
            logger.info("  Parsed " + trees.size() + " trees");
        }
        return trees;
    }

    public static void main(String[] args) {
        String outputFile = null;
        String sentencesFile = null;
        String labelsFile = null;
        String parserFile = LexicalizedParser.DEFAULT_PARSER_LOC;
        String taggerFile = null;
        MissingLabels missing = MissingLabels.DEFAULT;
        String defaultLabel = "-1";
        String separator = "\\t+";
        String saveUnknownsFile = null;
        String remapLabels = null;
        int argIndex = 0;
        boolean binarize = true;
        boolean useLabelKeys = false;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-output")) {
                outputFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-sentences")) {
                sentencesFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-labels")) {
                labelsFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parser")) {
                parserFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tagger")) {
                taggerFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-missing")) {
                missing = MissingLabels.valueOf(args[argIndex + 1]);
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-separator")) {
                separator = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-default")) {
                defaultLabel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-saveUnknowns")) {
                saveUnknownsFile = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-remapLabels")) {
                remapLabels = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-binarize")) {
                binarize = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-nobinarize")) {
                binarize = false;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-useLabelKeys")) {
                useLabelKeys = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-nouseLabelKeys")) {
                useLabelKeys = false;
                ++argIndex;
                continue;
            }
            throw new IllegalArgumentException("Unknown argument " + args[argIndex]);
        }
        if (outputFile == null) {
            throw new IllegalArgumentException("-output is required");
        }
        if (sentencesFile == null && !useLabelKeys) {
            throw new IllegalArgumentException("-sentences or -useLabelKeys is required");
        }
        if (sentencesFile != null && useLabelKeys) {
            throw new IllegalArgumentException("Use only one of -sentences or -useLabelKeys");
        }
        if (labelsFile == null) {
            throw new IllegalArgumentException("-labels is required");
        }
        ParserGrammar parser = ParseAndSetLabels.loadParser(parserFile, taggerFile);
        TreeBinarizer binarizer = null;
        if (binarize) {
            binarizer = TreeBinarizer.simpleTreeBinarizer(parser.getTLPParams().headFinder(), parser.treebankLanguagePack());
        }
        Map<String, String> labelMap = ParseAndSetLabels.readLabelMap(labelsFile, separator, remapLabels);
        List<String> sentences = sentencesFile != null ? ParseAndSetLabels.readSentences(sentencesFile) : new ArrayList<String>(labelMap.keySet());
        List<Tree> trees = ParseAndSetLabels.parseSentences(sentences, parser, binarizer);
        Set<String> unknowns = ParseAndSetLabels.setLabels(trees, labelMap, missing, defaultLabel);
        ParseAndSetLabels.writeTrees(trees, outputFile);
    }

    public static enum MissingLabels {
        FAIL,
        DEFAULT,
        KEEP_ORIGINAL;

    }
}

