/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.QuoteAttributionUtils;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyParseSieve
extends QMSieve {
    public DependencyParseSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "Deterministic depparse");
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        this.dependencyParses(doc);
        this.oneSpeakerSentence(doc);
    }

    private boolean inRange(Pair<Integer, Integer> range, int val) {
        return (Integer)range.first <= val && val <= (Integer)range.second;
    }

    public void dependencyParses(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        List tokens = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        block0: for (CoreMap quote : quotes) {
            Pair<Integer, Integer> range;
            if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null || (range = QuoteAttributionUtils.getRemainderInSentence(doc, quote)) == null) continue;
            Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> namesAndNameIndices = this.scanForNames(range);
            ArrayList names = (ArrayList)namesAndNameIndices.first;
            ArrayList nameIndices = (ArrayList)namesAndNameIndices.second;
            SemanticGraph graph = (SemanticGraph)quote.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class);
            SemgrexMatcher matcher = subjVerbPattern.matcher(graph);
            ArrayList<Pair<IndexedWord, IndexedWord>> subjVerbPairs = new ArrayList<Pair<IndexedWord, IndexedWord>>();
            while (matcher.find()) {
                IndexedWord subj = matcher.getNode("SUBJ");
                IndexedWord verb = matcher.getNode("VERB");
                subjVerbPairs.add(new Pair<IndexedWord, IndexedWord>(subj, verb));
            }
            List<IndexedWord> vbs = graph.getAllNodesByPartOfSpeechPattern("VB.*");
            for (IndexedWord indexedWord : vbs) {
                Set<IndexedWord> children = graph.getChildren(indexedWord);
                ArrayList<IndexedWord> deps = Generics.newArrayList();
                IndexedWord nsubj = null;
                for (IndexedWord child : children) {
                    SemanticGraphEdge sge = graph.getEdge(indexedWord, child);
                    if (sge.getRelation().getShortName().equals("dep") && child.tag().startsWith("VB")) {
                        deps.add(child);
                        continue;
                    }
                    if (!sge.getRelation().getShortName().equals("nsubj")) continue;
                    nsubj = child;
                }
                if (nsubj == null) continue;
                for (IndexedWord dep : deps) {
                    subjVerbPairs.add(new Pair<Object, IndexedWord>(nsubj, dep));
                }
            }
            block5: for (Pair pair : subjVerbPairs) {
                IndexedWord verb = (IndexedWord)pair.second;
                IndexedWord subj = (IndexedWord)pair.first;
                int verbTokPos = this.tokenToLocation(verb.backingLabel());
                int subjTokPos = this.tokenToLocation(verb.backingLabel());
                if (!this.inRange(range, verbTokPos) || !this.inRange(range, subjTokPos) || !commonSpeechWords.contains(verb.lemma())) continue;
                if (subj.tag().equals("NNP")) {
                    int startChar = subj.beginPosition();
                    for (int i = 0; i < names.size(); ++i) {
                        Pair nameIndex = (Pair)nameIndices.get(i);
                        if (!this.rangeContainsCharIndex(nameIndex, startChar)) continue;
                        DependencyParseSieve.fillInMention(quote, this.tokenRangeToString(nameIndex), (Integer)nameIndex.first, (Integer)nameIndex.second, this.sieveName, "name");
                        continue block5;
                    }
                    continue;
                }
                if (subj.tag().equals("PRP")) {
                    int loc = this.tokenToLocation(subj.backingLabel());
                    DependencyParseSieve.fillInMention(quote, subj.word(), loc, loc, this.sieveName, "pronoun");
                    continue block0;
                }
                if (!subj.tag().equals("NN") || !this.animacySet.contains(subj.word())) continue;
                int loc = this.tokenToLocation(subj.backingLabel());
                DependencyParseSieve.fillInMention(quote, subj.word(), loc, loc, this.sieveName, "animate noun");
                continue block0;
            }
        }
    }
}

