/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;

public class SplitTrainingSet {
    private static Redwood.RedwoodChannels logger = Redwood.channels(SplitTrainingSet.class);
    @ArgumentParser.Option(name="input", gloss="The file to use as input.", required=true)
    private static String INPUT = null;
    @ArgumentParser.Option(name="output", gloss="Where to send the splits.", required=true)
    private static String OUTPUT = null;
    @ArgumentParser.Option(name="split_names", gloss="Divisions to use for the output")
    private static String[] SPLIT_NAMES = new String[]{"train", "dev", "test"};
    @ArgumentParser.Option(name="split_weights", gloss="Portions to use for the divisions")
    private static Double[] SPLIT_WEIGHTS = new Double[]{0.7, 0.15, 0.15};
    @ArgumentParser.Option(name="seed", gloss="Random seed to use")
    private static long SEED = 0L;

    public static int weightedIndex(List<Double> weights, Random random) {
        double offset = random.nextDouble();
        int index = 0;
        for (Double weight : weights) {
            if ((offset -= weight.doubleValue()) < 0.0) {
                return index;
            }
            ++index;
        }
        return weights.size() - 1;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        void var8_16;
        Properties props = StringUtils.argsToProperties(args);
        ArgumentParser.fillOptions(new Class[]{ArgumentParser.class, SplitTrainingSet.class}, props);
        if (SPLIT_NAMES.length != SPLIT_WEIGHTS.length) {
            throw new IllegalArgumentException("Name and weight arrays must be of the same length");
        }
        double totalWeight = 0.0;
        for (Double weight : SPLIT_WEIGHTS) {
            totalWeight += weight.doubleValue();
            if (!(weight < 0.0)) continue;
            throw new IllegalArgumentException("Split weights cannot be negative");
        }
        if (totalWeight <= 0.0) {
            throw new IllegalArgumentException("Split weights must total to a positive weight");
        }
        ArrayList<Double> splitWeights = new ArrayList<Double>();
        for (Double d : SPLIT_WEIGHTS) {
            splitWeights.add(d / totalWeight);
        }
        logger.info("Splitting into " + splitWeights.size() + " lists with weights " + splitWeights);
        if (SEED == 0L) {
            SEED = System.nanoTime();
            logger.info("Random seed not set by options, using " + SEED);
        }
        Random random = new Random(SEED);
        ArrayList splits = new ArrayList();
        for (Double d : splitWeights) {
            splits.add(new ArrayList());
        }
        MemoryTreebank treebank = new MemoryTreebank(in -> new PennTreeReader(in));
        treebank.loadPath(INPUT);
        logger.info("Splitting " + ((Treebank)treebank).size() + " trees");
        for (Tree tree : treebank) {
            int index = SplitTrainingSet.weightedIndex(splitWeights, random);
            ((List)splits.get(index)).add(tree);
        }
        boolean bl = false;
        while (var8_16 < splits.size()) {
            String filename = OUTPUT + "." + SPLIT_NAMES[var8_16];
            List split = (List)splits.get((int)var8_16);
            logger.info("Writing " + split.size() + " trees to " + filename);
            FileWriter fout = new FileWriter(filename);
            BufferedWriter bout = new BufferedWriter(fout);
            for (Tree tree : split) {
                bout.write(tree.toString());
                bout.newLine();
            }
            bout.close();
            fout.close();
            ++var8_16;
        }
    }
}

