/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.spanish;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.spanish.SpanishTreeNormalizer;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpanishTreeNormalizerITest {
    private TreeFactory tf;
    private SpanishTreeNormalizer tn;
    private Pair<String, String>[] multiWordTestCases = new Pair[]{new Pair<String, String>("(a (b c_d))", "(a (MW_PHRASE?_b (MW? c) (MW? d)))"), new Pair<String, String>("(grup.nom (np00000 Josep_Maria_Oll\u00e9))", "(MW_PHRASE?_np00000 (MW? Josep) (MW? Maria) (MW? Oll\u00e9))"), new Pair<String, String>("(grup.nom (grup.nom (nc0p000 productos)) (sp (prep (sp000 de)) (sn (grup.nom (np00000 American_Online)))))", "(grup.nom (grup.nom (nc0p000 productos)) (sp (prep (sp000 de)) (sn (MW_PHRASE?_np00000 (MW? American) (MW? Online)))))"), new Pair<String, String>("(a (b c_d) (b e_f))", "(a (MW_PHRASE?_b (MW? c) (MW? d)) (MW_PHRASE?_b (MW? e) (MW? f)))"), new Pair<String, String>("(a (b \"cde\"))", "(a (MW_PHRASE?_b (MW? \") (MW? cde) (MW? \")))"), new Pair<String, String>("(a (b tecno-pop))", "(a (MW_PHRASE?_b (MW? tecno) (MW? -) (MW? pop)))"), new Pair<String, String>("(a (b co-promotora))", "(a (b co-promotora))"), new Pair<String, String>("(a (b co) (b promotora))", "(a (b co) (b promotora))"), new Pair<String, String>("(a (b 8,39))", "(a (b 8,39))"), new Pair<String, String>("(a (b 28,91%))", "(a (MW_PHRASE?_b (MW? 28,91) (MW? %)))"), new Pair<String, String>("(a (b entonces,_yo))", "(a (MW_PHRASE?_b (MW? entonces) (MW? ,) (MW? yo)))")};

    @Before
    public void setUp() {
        this.tf = new LabeledScoredTreeFactory();
        this.tn = new SpanishTreeNormalizer(true, true, true);
    }

    @Test
    public void testMultiWordNormalization() {
        for (Pair<String, String> testCase : this.multiWordTestCases) {
            Tree head = this.readTree(testCase.first());
            for (Tree t : head) {
                if (!t.isPrePreTerminal()) continue;
                this.tn.normalizeForMultiWord(t, this.tf);
            }
            Assert.assertEquals((Object)testCase.second(), (Object)head.toString());
        }
    }

    private Tree readTree(String treeRep) {
        try {
            return new PennTreeReader(new StringReader(treeRep), this.tf).readTree();
        }
        catch (IOException e) {
            return null;
        }
    }
}

