/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.tregex.tsurgeon.RelabelNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class RelabelNodeTest
extends TestCase {
    public void testRegexPattern() {
        Pattern pattern = RelabelNode.regexPattern;
        String[] goodLabels = new String[]{"//", "/foo/", "/\\\\/", "/\\\\\\\\/", "/foo\\\\/", "/f\\oo\\\\/", "/f\\oo/", "/f\\o/", "/f\\/oo/"};
        String[] badLabels = new String[]{"foo", "/\\/", "/\\\\\\/", "/foo\\/", "asdf"};
        this.runPatternTest(pattern, goodLabels, badLabels, 1, -1);
    }

    public void testNodePattern() {
        Pattern pattern = Pattern.compile("(=\\{[a-zA-Z0-9_]+\\})");
        String[] goodMatches = new String[]{"={foo}", "={blah}", "={z954240_fdsfgsf}"};
        String[] badMatches = new String[]{"%{foo}", "bar", "=%{blah}", "%={blah}", "=foo", "%foo"};
        this.runPatternTest(pattern, goodMatches, badMatches, 0, 0);
    }

    public void testVariablePattern() {
        Pattern pattern = Pattern.compile("(%\\{[a-zA-Z0-9_]+\\})");
        String[] goodMatches = new String[]{"%{foo}", "%{blah}", "%{z954240_fdsfgsf}"};
        String[] badMatches = new String[]{"={foo}", "{bar}", "=%{blah}", "%={blah}", "=foo", "%foo"};
        this.runPatternTest(pattern, goodMatches, badMatches, 0, 0);
    }

    public void runPatternTest(Pattern pattern, String[] good, String[] bad, int startOffset, int endOffset) {
        Matcher m;
        for (String test : good) {
            m = pattern.matcher(test);
            RelabelNodeTest.assertTrue((String)("Should have matched on " + test), (boolean)m.matches());
            String matched = m.group(1);
            String expected = test.substring(startOffset, test.length() + endOffset);
            RelabelNodeTest.assertEquals((String)("Matched group wasn't " + test), (String)expected, (String)matched);
        }
        for (String test : bad) {
            m = pattern.matcher(test);
            RelabelNodeTest.assertFalse((String)("Shouldn't have matched on " + test), (boolean)m.matches());
        }
    }
}

