/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.logging.PrettyLoggable;
import edu.stanford.nlp.util.logging.PrettyLogger;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.List;

public class Quintuple<T1, T2, T3, T4, T5>
implements Comparable<Quintuple<T1, T2, T3, T4, T5>>,
Serializable,
PrettyLoggable {
    private static final long serialVersionUID = 6295043666955910662L;
    public T1 first;
    public T2 second;
    public T3 third;
    public T4 fourth;
    public T5 fifth;

    public Quintuple(T1 first, T2 second, T3 third, T4 fourth, T5 fifth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
        this.fifth = fifth;
    }

    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public T3 third() {
        return this.third;
    }

    public T4 fourth() {
        return this.fourth;
    }

    public T5 fifth() {
        return this.fifth;
    }

    public void setFirst(T1 o) {
        this.first = o;
    }

    public void setSecond(T2 o) {
        this.second = o;
    }

    public void setThird(T3 o) {
        this.third = o;
    }

    public void setFourth(T4 o) {
        this.fourth = o;
    }

    public void setFifth(T5 fifth) {
        this.fifth = fifth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quintuple)) {
            return false;
        }
        Quintuple quadruple = (Quintuple)ErasureUtils.uncheckedCast(o);
        if (this.first != null ? !this.first.equals(quadruple.first) : quadruple.first != null) {
            return false;
        }
        if (this.second != null ? !this.second.equals(quadruple.second) : quadruple.second != null) {
            return false;
        }
        if (this.third != null ? !this.third.equals(quadruple.third) : quadruple.third != null) {
            return false;
        }
        if (this.fourth != null ? !this.fourth.equals(quadruple.fourth) : quadruple.fourth != null) {
            return false;
        }
        return !(this.fifth != null ? !this.fifth.equals(quadruple.fifth) : quadruple.fifth != null);
    }

    public int hashCode() {
        int result = 17;
        result = this.first != null ? this.first.hashCode() : 0;
        result = 29 * result + (this.second != null ? this.second.hashCode() : 0);
        result = 29 * result + (this.third != null ? this.third.hashCode() : 0);
        result = 29 * result + (this.fourth != null ? this.fourth.hashCode() : 0);
        result = 29 * result + (this.fifth != null ? this.fifth.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + "," + this.third + "," + this.fourth + "," + this.fifth + ")";
    }

    public static <T1, T2, T3, T4, T5> Quintuple<T1, T2, T3, T4, T5> makeQuadruple(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {
        return new Quintuple<T1, T2, T3, T4, T5>(t1, t2, t3, t4, t5);
    }

    public List<Object> asList() {
        return CollectionUtils.makeList(this.first, this.second, this.third, this.fourth, this.fifth);
    }

    @Override
    public int compareTo(Quintuple<T1, T2, T3, T4, T5> another) {
        int comp = ((Comparable)this.first()).compareTo(another.first());
        if (comp != 0) {
            return comp;
        }
        comp = ((Comparable)this.second()).compareTo(another.second());
        if (comp != 0) {
            return comp;
        }
        comp = ((Comparable)this.third()).compareTo(another.third());
        if (comp != 0) {
            return comp;
        }
        comp = ((Comparable)this.fourth()).compareTo(another.fourth());
        if (comp != 0) {
            return comp;
        }
        return ((Comparable)this.fifth()).compareTo(another.fifth());
    }

    @Override
    public void prettyLog(Redwood.RedwoodChannels channels, String description) {
        PrettyLogger.log(channels, description, this.asList());
    }
}

