/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.concurrent.ConcurrentHashIndex;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class ConcurrentHashIndexTest
extends TestCase {
    protected Index<String> index;
    protected Index<String> index2;
    protected Index<String> index3;

    protected void setUp() {
        this.index = new ConcurrentHashIndex<String>();
        this.index.add("The");
        this.index.add("Beast");
        this.index2 = new ConcurrentHashIndex<String>();
        this.index2.add("Beauty");
        this.index2.add("And");
        this.index2.add("The");
        this.index2.add("Beast");
        this.index3 = new ConcurrentHashIndex<String>();
        this.index3.add("Markov");
        this.index3.add("The");
        this.index3.add("Beast");
    }

    public void testSize() {
        ConcurrentHashIndexTest.assertEquals((int)2, (int)this.index.size());
    }

    public void testGet() {
        ConcurrentHashIndexTest.assertEquals((int)2, (int)this.index.size());
        ConcurrentHashIndexTest.assertEquals((String)"The", (String)this.index.get(0));
        ConcurrentHashIndexTest.assertEquals((String)"Beast", (String)this.index.get(1));
    }

    public void testIndexOf() {
        ConcurrentHashIndexTest.assertEquals((int)2, (int)this.index.size());
        ConcurrentHashIndexTest.assertEquals((int)0, (int)this.index.indexOf("The"));
        ConcurrentHashIndexTest.assertEquals((int)1, (int)this.index.indexOf("Beast"));
    }

    public void testIterator() {
        Iterator i = this.index.iterator();
        ConcurrentHashIndexTest.assertEquals((String)"The", (String)((String)i.next()));
        ConcurrentHashIndexTest.assertEquals((String)"Beast", (String)((String)i.next()));
        ConcurrentHashIndexTest.assertEquals((boolean)false, (boolean)i.hasNext());
    }

    public void testToArray() {
        String[] strs = new String[2];
        strs = this.index.objectsList().toArray(strs);
        ConcurrentHashIndexTest.assertEquals((int)2, (int)strs.length);
        ConcurrentHashIndexTest.assertTrue((boolean)this.index.contains(strs[0]));
        ConcurrentHashIndexTest.assertTrue((boolean)this.index.contains(strs[1]));
    }

    public void testObjects() {
        List foo = (List)this.index2.objects(new int[]{0, 3});
        ConcurrentHashIndexTest.assertEquals((String)"Beauty", (String)((String)foo.get(0)));
        ConcurrentHashIndexTest.assertEquals((String)"Beast", (String)((String)foo.get(1)));
    }
}

