/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.math;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.Precision;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalGenerator
extends Generator<BigDecimal> {
    private BigDecimal min;
    private BigDecimal max;
    private Precision precision;

    public BigDecimalGenerator() {
        super(BigDecimal.class);
    }

    public void configure(InRange range) {
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = new BigDecimal(range.min());
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = new BigDecimal(range.max());
        }
        if (this.min != null && this.max != null) {
            Ranges.checkRange((Ranges.Type)Ranges.Type.FLOAT, (Comparable)this.min, (Comparable)this.max);
        }
    }

    public void configure(Precision configuration) {
        this.precision = configuration;
    }

    public BigDecimal generate(SourceOfRandomness random, GenerationStatus status) {
        BigInteger generated;
        BigDecimal minToUse = this.min;
        BigDecimal maxToUse = this.max;
        int power = status.size() + 1;
        if (minToUse == null && maxToUse == null) {
            maxToUse = BigDecimal.TEN.pow(power);
            minToUse = maxToUse.negate();
        }
        if (minToUse == null) {
            minToUse = maxToUse.subtract(BigDecimal.TEN.pow(power));
        } else if (maxToUse == null) {
            maxToUse = minToUse.add(BigDecimal.TEN.pow(power));
        }
        int scale = this.decideScale();
        BigDecimal minShifted = minToUse.movePointRight(scale);
        BigDecimal maxShifted = maxToUse.movePointRight(scale);
        BigInteger range = maxShifted.toBigInteger().subtract(minShifted.toBigInteger());
        while ((generated = random.nextBigInteger(range.bitLength())).compareTo(range) >= 0) {
        }
        return minShifted.add(new BigDecimal(generated)).movePointLeft(scale);
    }

    private int decideScale() {
        int scale = Integer.MIN_VALUE;
        if (this.min != null) {
            scale = Math.max(scale, this.min.scale());
        }
        if (this.max != null) {
            scale = Math.max(scale, this.max.scale());
        }
        if (this.precision != null) {
            scale = Math.max(scale, this.precision.scale());
        }
        return Math.max(scale, 0);
    }
}

