/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Map<String, String> primitiveClassAbbrevs = new HashMap<String, String>();

    private Utils() {
    }

    public static void validateNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The validated object is null");
        }
    }

    public static void validateIsTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException("The validated expression is false");
        }
    }

    public static void validateIsTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isArrayEqual(Object[] left, Object[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (Utils.isArrayElementEqual(left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isArrayElementEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        Class<?> leftClass = left.getClass();
        if (!leftClass.isArray()) {
            if (left instanceof BigDecimal) {
                if (right instanceof BigDecimal) {
                    return ((BigDecimal)left).compareTo((BigDecimal)right) == 0;
                }
                return false;
            }
            return left.equals(right);
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        return Utils.isArrayEqual((Object[])left, (Object[])right);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        StringBuilder strBuilder = new StringBuilder();
        int z = array.length;
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                strBuilder.append(separator);
            }
            strBuilder.append(array[i]);
        }
        return strBuilder.toString();
    }

    public static String removeAllWhitespaces(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int originalSize = string.length();
        char[] charArray = new char[originalSize];
        int charCount = 0;
        for (int i = 0; i < originalSize; ++i) {
            char currentChar = string.charAt(i);
            if (Character.isWhitespace(currentChar)) continue;
            charArray[charCount++] = currentChar;
        }
        if (charCount == originalSize) {
            return string;
        }
        return new String(charArray, 0, charCount);
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        ClassLoader loader;
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = loader = contextCL == null ? Utils.class.getClassLoader() : contextCL;
        if (primitiveClassAbbrevs.containsKey(className)) {
            String clsName = "[" + primitiveClassAbbrevs.get(className);
            return Class.forName(clsName, true, loader).getComponentType();
        }
        return Class.forName(Utils.getClassCanonicalName(className), true, loader);
    }

    private static String getClassCanonicalName(String className) {
        String trimmedClassName = Utils.removeAllWhitespaces(className);
        if (trimmedClassName == null) {
            throw new IllegalArgumentException("className cannot be null");
        }
        if (trimmedClassName.endsWith("[]")) {
            StringBuilder strBuilder = new StringBuilder();
            while (trimmedClassName.endsWith("[]")) {
                trimmedClassName = trimmedClassName.substring(0, trimmedClassName.length() - 2);
                strBuilder.append("[");
            }
            String abbreviation = primitiveClassAbbrevs.get(trimmedClassName);
            if (abbreviation != null) {
                strBuilder.append(abbreviation);
            } else {
                strBuilder.append("L").append(trimmedClassName).append(";");
            }
            trimmedClassName = strBuilder.toString();
        }
        return trimmedClassName;
    }

    static {
        primitiveClassAbbrevs.put("int", "I");
        primitiveClassAbbrevs.put("boolean", "Z");
        primitiveClassAbbrevs.put("float", "F");
        primitiveClassAbbrevs.put("long", "J");
        primitiveClassAbbrevs.put("short", "S");
        primitiveClassAbbrevs.put("byte", "B");
        primitiveClassAbbrevs.put("double", "D");
        primitiveClassAbbrevs.put("char", "C");
    }
}

