/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.fsm.DFSA;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RegExFileFilter;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.objectbank.ResettableReaderIteratorFactory;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.CoreTokenFactory;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.IOBUtils;
import edu.stanford.nlp.sequences.KBestSequenceFinder;
import edu.stanford.nlp.sequences.LatticeWriter;
import edu.stanford.nlp.sequences.ObjectBankWrapper;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.sequences.SequenceSampler;
import edu.stanford.nlp.sequences.ViterbiSearchGraphBuilder;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.Sampler;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.stats.TwoDimensionalCounterInterface;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.MaxSizeConcurrentHashSet;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public abstract class AbstractSequenceClassifier<IN extends CoreMap>
implements Function<String, String> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(AbstractSequenceClassifier.class);
    public SeqClassifierFlags flags;
    public Index<String> classIndex;
    public List<FeatureFactory<IN>> featureFactories;
    protected IN pad;
    private CoreTokenFactory<IN> tokenFactory;
    public int windowSize;
    protected MaxSizeConcurrentHashSet<String> knownLCWords;
    private DocumentReaderAndWriter<IN> defaultReaderAndWriter;
    private DocumentReaderAndWriter<IN> plainTextReaderAndWriter;
    private static final String CUT_LABEL = "Cut";
    private transient PrintWriter cliqueWriter;
    private transient int writtenNum;

    public synchronized DocumentReaderAndWriter<IN> defaultReaderAndWriter() {
        if (this.defaultReaderAndWriter == null) {
            this.defaultReaderAndWriter = this.makeReaderAndWriter();
        }
        return this.defaultReaderAndWriter;
    }

    public synchronized DocumentReaderAndWriter<IN> plainTextReaderAndWriter() {
        if (this.plainTextReaderAndWriter == null) {
            this.plainTextReaderAndWriter = this.flags.readerAndWriter != null && this.flags.readerAndWriter.equals(this.flags.plainTextDocumentReaderAndWriter) ? this.defaultReaderAndWriter() : this.makePlainTextReaderAndWriter();
        }
        return this.plainTextReaderAndWriter;
    }

    public AbstractSequenceClassifier(Properties props) {
        this(new SeqClassifierFlags(props));
    }

    public AbstractSequenceClassifier(SeqClassifierFlags flags) {
        this.flags = flags;
        this.featureFactories = Generics.newArrayList();
        if (flags.featureFactory != null) {
            FeatureFactory factory = (FeatureFactory)new MetaClass(flags.featureFactory).createInstance(flags.featureFactoryArgs);
            this.featureFactories.add(factory);
        }
        if (flags.featureFactories != null) {
            for (int i = 0; i < flags.featureFactories.length; ++i) {
                FeatureFactory indFeatureFactory = (FeatureFactory)new MetaClass(flags.featureFactories[i]).createInstance(flags.featureFactoriesArgs.get(i));
                this.featureFactories.add(indFeatureFactory);
            }
        }
        this.tokenFactory = flags.tokenFactory == null ? new CoreLabelTokenFactory() : (CoreTokenFactory)new MetaClass(flags.tokenFactory).createInstance(flags.tokenFactoryArgs);
        this.pad = this.tokenFactory.makeToken();
        this.windowSize = flags.maxLeft + 1;
        this.reinit();
    }

    protected final void reinit() {
        this.pad.set(CoreAnnotations.AnswerAnnotation.class, (String)this.flags.backgroundSymbol);
        this.pad.set(CoreAnnotations.GoldAnswerAnnotation.class, (String)this.flags.backgroundSymbol);
        for (FeatureFactory<IN> featureFactory : this.featureFactories) {
            featureFactory.init(this.flags);
        }
        this.defaultReaderAndWriter = null;
        this.plainTextReaderAndWriter = null;
        if (this.knownLCWords == null || this.knownLCWords.isEmpty()) {
            this.knownLCWords = new MaxSizeConcurrentHashSet(this.flags.maxAdditionalKnownLCWords);
        } else {
            this.knownLCWords.setMaxSize(this.knownLCWords.size() + this.flags.maxAdditionalKnownLCWords);
        }
    }

    public Set<String> getKnownLCWords() {
        return this.knownLCWords;
    }

    public DocumentReaderAndWriter<IN> makeReaderAndWriter() {
        DocumentReaderAndWriter readerAndWriter;
        try {
            readerAndWriter = (DocumentReaderAndWriter)ReflectionLoading.loadByReflection(this.flags.readerAndWriter, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error loading flags.readerAndWriter: '%s'", this.flags.readerAndWriter), e);
        }
        readerAndWriter.init(this.flags);
        return readerAndWriter;
    }

    public DocumentReaderAndWriter<IN> makePlainTextReaderAndWriter() {
        DocumentReaderAndWriter readerAndWriter;
        String readerClassName = this.flags.plainTextDocumentReaderAndWriter;
        if (readerClassName == null) {
            readerClassName = "edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter";
        }
        try {
            readerAndWriter = (DocumentReaderAndWriter)ReflectionLoading.loadByReflection(readerClassName, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error loading flags.plainTextDocumentReaderAndWriter: '%s'", this.flags.plainTextDocumentReaderAndWriter), e);
        }
        readerAndWriter.init(this.flags);
        return readerAndWriter;
    }

    public String backgroundSymbol() {
        return this.flags.backgroundSymbol;
    }

    public Set<String> labels() {
        return Generics.newHashSet(this.classIndex.objectsList());
    }

    public List<IN> classifySentence(List<? extends HasWord> tokenSequence) {
        List<IN> document = this.preprocessTokens(tokenSequence);
        this.classify(document);
        return document;
    }

    private List<IN> preprocessTokens(List<? extends HasWord> tokenSequence) {
        ArrayList<Object> document = new ArrayList<Object>();
        int i = 0;
        for (HasWord hasWord : tokenSequence) {
            Object wi;
            if (hasWord instanceof CoreMap) {
                wi = this.tokenFactory.makeToken((CoreMap)((Object)hasWord));
            } else {
                wi = this.tokenFactory.makeToken();
                wi.set(CoreAnnotations.TextAnnotation.class, (String)hasWord.word());
            }
            wi.set(CoreAnnotations.PositionAnnotation.class, (String)Integer.toString(i));
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.backgroundSymbol());
            document.add(wi);
            ++i;
        }
        ObjectBankWrapper<Object> wrapper = new ObjectBankWrapper<Object>(this.flags, null, this.knownLCWords);
        wrapper.processDocument(document);
        return document;
    }

    public List<IN> classifySentenceWithGlobalInformation(List<? extends HasWord> tokenSequence, CoreMap doc, CoreMap sentence) {
        List<IN> document = this.preprocessTokens(tokenSequence);
        this.classifyWithGlobalInformation(document, doc, sentence);
        return document;
    }

    public SequenceModel getSequenceModel(List<IN> doc) {
        throw new UnsupportedOperationException();
    }

    public Sampler<List<IN>> getSampler(final List<IN> input) {
        return new Sampler<List<IN>>(){
            SequenceModel model;
            SequenceSampler sampler;
            {
                this.model = AbstractSequenceClassifier.this.getSequenceModel(input);
                this.sampler = new SequenceSampler();
            }

            @Override
            public List<IN> drawSample() {
                int[] sampleArray = this.sampler.bestSequence(this.model);
                ArrayList<CoreMap> sample = new ArrayList<CoreMap>();
                int i = 0;
                for (CoreMap word : input) {
                    CoreMap newWord = AbstractSequenceClassifier.this.tokenFactory.makeToken(word);
                    newWord.set(CoreAnnotations.AnswerAnnotation.class, AbstractSequenceClassifier.this.classIndex.get(sampleArray[i++]));
                    sample.add(newWord);
                }
                return sample;
            }
        };
    }

    public Counter<List<IN>> classifyKBest(List<IN> doc, Class<? extends CoreAnnotation<String>> answerField, int k) {
        if (doc.isEmpty()) {
            return new ClassicCounter<List<IN>>();
        }
        ObjectBankWrapper<IN> obw = new ObjectBankWrapper<IN>(this.flags, null, this.knownLCWords);
        doc = obw.processDocument(doc);
        SequenceModel model = this.getSequenceModel(doc);
        KBestSequenceFinder tagInference = new KBestSequenceFinder();
        Counter<int[]> bestSequences = tagInference.kBestSequences(model, k);
        ClassicCounter<List<IN>> kBest = new ClassicCounter<List<IN>>();
        for (int[] seq : bestSequences.keySet()) {
            ArrayList<CoreMap> kth = new ArrayList<CoreMap>();
            int pos = model.leftWindow();
            for (CoreMap fi : doc) {
                CoreMap newFL = this.tokenFactory.makeToken(fi);
                String guess = this.classIndex.get(seq[pos]);
                fi.remove(CoreAnnotations.AnswerAnnotation.class);
                newFL.set(answerField, guess);
                ++pos;
                kth.add(newFL);
            }
            kBest.setCount(kth, bestSequences.getCount(seq));
        }
        return kBest;
    }

    private DFSA<String, Integer> getViterbiSearchGraph(List<IN> doc, Class<? extends CoreAnnotation<String>> answerField) {
        if (doc.isEmpty()) {
            return new DFSA<String, Integer>(null);
        }
        ObjectBankWrapper<IN> obw = new ObjectBankWrapper<IN>(this.flags, null, this.knownLCWords);
        doc = obw.processDocument(doc);
        SequenceModel model = this.getSequenceModel(doc);
        return ViterbiSearchGraphBuilder.getGraph(model, this.classIndex);
    }

    public List<List<IN>> classify(String str) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(str, this.plainTextReaderAndWriter());
        return this.classifyObjectBank(documents);
    }

    public List<List<IN>> classifyRaw(String str, DocumentReaderAndWriter<IN> readerAndWriter) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(str, readerAndWriter);
        return this.classifyObjectBank(documents);
    }

    public List<List<IN>> classifyFile(String filename) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(filename, this.plainTextReaderAndWriter());
        return this.classifyObjectBank(documents);
    }

    private List<List<IN>> classifyObjectBank(ObjectBank<List<IN>> documents) {
        ArrayList<List<IN>> result = new ArrayList<List<IN>>();
        for (List<IN> document : documents) {
            this.classify(document);
            ArrayList<CoreMap> sentence = new ArrayList<CoreMap>();
            for (CoreMap wi : document) {
                sentence.add(wi);
            }
            result.add(sentence);
        }
        return result;
    }

    @Override
    public String apply(String in) {
        return this.classifyWithInlineXML(in);
    }

    public String classifyToString(String sentences, String outputFormat, boolean preserveSpacing) {
        PlainTextDocumentReaderAndWriter.OutputStyle outFormat = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(outputFormat);
        DocumentReaderAndWriter<IN> textDocumentReaderAndWriter = this.plainTextReaderAndWriter();
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(sentences, textDocumentReaderAndWriter);
        StringBuilder sb = new StringBuilder();
        for (List<IN> doc : documents) {
            List<IN> docOutput = this.classify(doc);
            if (textDocumentReaderAndWriter instanceof PlainTextDocumentReaderAndWriter) {
                sb.append(((PlainTextDocumentReaderAndWriter)textDocumentReaderAndWriter).getAnswers(docOutput, outFormat, preserveSpacing));
                continue;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            textDocumentReaderAndWriter.printAnswers(docOutput, pw);
            pw.flush();
            sb.append(sw);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String classifyWithInlineXML(String sentences) {
        return this.classifyToString(sentences, "inlineXML", true);
    }

    public String classifyToString(String sentences) {
        return this.classifyToString(sentences, "slashTags", true);
    }

    public List<Triple<String, Integer, Integer>> classifyToCharacterOffsets(String sentences) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(sentences, this.plainTextReaderAndWriter());
        ArrayList<Triple<String, Integer, Integer>> entities = new ArrayList<Triple<String, Integer, Integer>>();
        for (List<IN> doc : documents) {
            String prevEntityType = this.flags.backgroundSymbol;
            Triple<String, Integer, Integer> prevEntity = null;
            this.classify(doc);
            for (CoreMap fl : doc) {
                String guessedAnswer = (String)fl.get(CoreAnnotations.AnswerAnnotation.class);
                if (guessedAnswer.equals(this.flags.backgroundSymbol)) {
                    if (prevEntity != null) {
                        entities.add(prevEntity);
                        prevEntity = null;
                    }
                } else if (!guessedAnswer.equals(prevEntityType)) {
                    if (prevEntity != null) {
                        entities.add(prevEntity);
                    }
                    prevEntity = new Triple<String, Integer, Integer>(guessedAnswer, (Integer)fl.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), (Integer)fl.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                } else {
                    assert (prevEntity != null);
                    prevEntity.setThird((Integer)fl.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                }
                prevEntityType = guessedAnswer;
            }
            if (prevEntity == null) continue;
            entities.add(prevEntity);
        }
        return entities;
    }

    public List<String> segmentString(String sentence) {
        return this.segmentString(sentence, this.defaultReaderAndWriter());
    }

    public List<String> segmentString(String sentence, DocumentReaderAndWriter<IN> readerAndWriter) {
        ObjectBank<List<IN>> docs = this.makeObjectBankFromString(sentence, readerAndWriter);
        StringWriter stringWriter = new StringWriter();
        PrintWriter stringPrintWriter = new PrintWriter(stringWriter);
        for (List<IN> doc : docs) {
            this.classify(doc);
            readerAndWriter.printAnswers(doc, stringPrintWriter);
            stringPrintWriter.println();
        }
        stringPrintWriter.close();
        String segmented = stringWriter.toString();
        return Arrays.asList(segmented.split("\\s"));
    }

    public abstract List<IN> classify(List<IN> var1);

    public abstract List<IN> classifyWithGlobalInformation(List<IN> var1, CoreMap var2, CoreMap var3);

    public void finalizeClassification(CoreMap document) {
    }

    public void train() {
        if (this.flags.trainFiles != null) {
            this.train(this.flags.baseTrainDir, this.flags.trainFiles, this.defaultReaderAndWriter());
        } else if (this.flags.trainFileList != null) {
            String[] files = this.flags.trainFileList.split(",");
            this.train(files, this.defaultReaderAndWriter());
        } else {
            this.train(this.flags.trainFile, this.defaultReaderAndWriter());
        }
    }

    public void train(String filename) {
        this.train(filename, this.defaultReaderAndWriter());
    }

    public void train(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.train(this.makeObjectBankFromFile(filename, readerAndWriter), readerAndWriter);
    }

    public void train(String baseTrainDir, String trainFiles, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.train(this.makeObjectBankFromFiles(baseTrainDir, trainFiles, readerAndWriter), readerAndWriter);
    }

    public void train(String[] trainFileList, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.train(this.makeObjectBankFromFiles(trainFileList, readerAndWriter), readerAndWriter);
    }

    public void train(Collection<List<IN>> docs) {
        this.train(docs, this.defaultReaderAndWriter());
    }

    public abstract void train(Collection<List<IN>> var1, DocumentReaderAndWriter<IN> var2);

    public ObjectBank<List<IN>> makeObjectBankFromString(String string, DocumentReaderAndWriter<IN> readerAndWriter) {
        if (this.flags.announceObjectBankEntries) {
            log.info("Reading data using " + readerAndWriter.getClass());
            if (this.flags.inputEncoding == null) {
                log.info("Getting data from " + string + " (default encoding)");
            } else {
                log.info("Getting data from " + string + " (" + this.flags.inputEncoding + " encoding)");
            }
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(string), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFile(String filename) {
        return this.makeObjectBankFromFile(filename, this.defaultReaderAndWriter());
    }

    public ObjectBank<List<IN>> makeObjectBankFromFile(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        String[] fileAsArray = new String[]{filename};
        return this.makeObjectBankFromFiles(fileAsArray, readerAndWriter);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFiles(String[] trainFileList, DocumentReaderAndWriter<IN> readerAndWriter) {
        ArrayList<File> files = new ArrayList<File>();
        for (String trainFile : trainFileList) {
            File f = new File(trainFile);
            files.add(f);
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(files, this.flags.inputEncoding), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFiles(String baseDir, String filePattern, DocumentReaderAndWriter<IN> readerAndWriter) {
        File path = new File(baseDir);
        RegExFileFilter filter = new RegExFileFilter(Pattern.compile(filePattern));
        File[] origFiles = path.listFiles(filter);
        ArrayList<File> files = new ArrayList<File>();
        for (File file : origFiles) {
            if (!file.isFile()) continue;
            if (this.flags.announceObjectBankEntries) {
                log.info("Getting data from " + file + " (" + this.flags.inputEncoding + " encoding)");
            }
            files.add(file);
        }
        if (files.isEmpty()) {
            throw new RuntimeException("No matching files: " + baseDir + '\t' + filePattern);
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(files, this.flags.inputEncoding), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFiles(Collection<File> files, DocumentReaderAndWriter<IN> readerAndWriter) {
        if (files.isEmpty()) {
            throw new RuntimeException("Attempt to make ObjectBank with empty file list");
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(files, this.flags.inputEncoding), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromReader(BufferedReader in, DocumentReaderAndWriter<IN> readerAndWriter) {
        if (this.flags.announceObjectBankEntries) {
            log.info("Reading data using " + readerAndWriter.getClass());
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(in), readerAndWriter), this.knownLCWords);
    }

    public void printProbs(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        this.printProbsDocuments(docs);
    }

    public void printProbs(Collection<File> testFiles, DocumentReaderAndWriter<IN> readerWriter) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFiles(testFiles, readerWriter);
        this.printProbsDocuments(documents);
    }

    public void printProbsDocuments(ObjectBank<List<IN>> documents) {
        ClassicCounter<Integer> calibration = new ClassicCounter<Integer>();
        ClassicCounter<Integer> correctByBin = new ClassicCounter<Integer>();
        TwoDimensionalCounter<Integer, String> calibratedTokens = new TwoDimensionalCounter<Integer, String>();
        for (List<IN> doc : documents) {
            Triple<Counter<Integer>, Counter<Integer>, TwoDimensionalCounter<Integer, String>> triple = this.printProbsDocument(doc);
            if (triple != null) {
                Counters.addInPlace(calibration, triple.first());
                Counters.addInPlace(correctByBin, triple.second());
                calibratedTokens.addAll((TwoDimensionalCounterInterface<Integer, String>)triple.third());
            }
            System.out.println();
        }
        if (calibration.size() > 0) {
            PrintWriter pw = new PrintWriter(System.err);
            AbstractSequenceClassifier.outputCalibrationInfo(pw, calibration, correctByBin, calibratedTokens);
            pw.flush();
        }
    }

    private static void outputCalibrationInfo(PrintWriter pw, Counter<Integer> calibration, Counter<Integer> correctByBin, TwoDimensionalCounter<Integer, String> calibratedTokens) {
        int i;
        int numBins = 10;
        pw.println();
        pw.println("----------------------------------------");
        pw.println("Probability distribution given to tokens (Counts for all class-token pairs; accuracy for this bin; examples are gold entity tokens in bin)");
        pw.println("----------------------------------------");
        for (i = 0; i < 10; ++i) {
            pw.printf("[%.1f-%.1f%c: %.0f  %.2f%n", (double)i / 10.0, (double)(i + 1) / 10.0, Character.valueOf(i == 9 ? (char)']' : ')'), calibration.getCount(i), correctByBin.getCount(i) / calibration.getCount(i));
        }
        pw.println("----------------------------------------");
        for (i = 0; i < 10; ++i) {
            pw.printf("[%.1f-%.1f%c: %s%n", (double)i / 10.0, (double)(i + 1) / 10.0, Character.valueOf(i == 9 ? (char)']' : ')'), Counters.toSortedString(calibratedTokens.getCounter((Object)i), 20, "%s=%.0f", ", ", "[%s]"));
        }
        pw.println("----------------------------------------");
    }

    public void classifyStdin() throws IOException {
        this.classifyStdin(this.plainTextReaderAndWriter());
    }

    public void classifyStdin(DocumentReaderAndWriter<IN> readerWriter) throws IOException {
        String line;
        BufferedReader is = IOUtils.readerFromStdin(this.flags.inputEncoding);
        while ((line = is.readLine()) != null) {
            Collection<List<Object>> documents = this.makeObjectBankFromString(line, readerWriter);
            if (this.flags.keepEmptySentences && documents.isEmpty()) {
                documents = Collections.singletonList(Collections.emptyList());
            }
            this.classifyAndWriteAnswers(documents, readerWriter, false);
        }
    }

    public Triple<Counter<Integer>, Counter<Integer>, TwoDimensionalCounter<Integer, String>> printProbsDocument(List<IN> document) {
        throw new UnsupportedOperationException("Not implemented for this class.");
    }

    public void dumpFeatures(Collection<List<IN>> documents) {
    }

    public void classifyAndWriteAnswers(String textFile) throws IOException {
        this.classifyAndWriteAnswers(textFile, this.plainTextReaderAndWriter(), false);
    }

    public Triple<Double, Double, Double> classifyAndWriteAnswers(String testFile, boolean outputScores) throws IOException {
        return this.classifyAndWriteAnswers(testFile, this.defaultReaderAndWriter(), outputScores);
    }

    public Triple<Double, Double, Double> classifyAndWriteAnswers(String testFile, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerWriter);
        return this.classifyAndWriteAnswers(documents, readerWriter, outputScores);
    }

    public Triple<Double, Double, Double> classifyAndWriteAnswers(String testFile, OutputStream outStream, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerWriter);
        PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(outStream, this.flags.outputEncoding, true);
        return this.classifyAndWriteAnswers(documents, pw, readerWriter, outputScores);
    }

    public Triple<Double, Double, Double> classifyAndWriteAnswers(String baseDir, String filePattern, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFiles(baseDir, filePattern, readerWriter);
        return this.classifyAndWriteAnswers(documents, readerWriter, outputScores);
    }

    public void classifyFilesAndWriteAnswers(Collection<File> textFiles) throws IOException {
        this.classifyFilesAndWriteAnswers(textFiles, this.plainTextReaderAndWriter(), false);
    }

    public void classifyFilesAndWriteAnswers(Collection<File> testFiles, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFiles(testFiles, readerWriter);
        this.classifyAndWriteAnswers(documents, readerWriter, outputScores);
    }

    public Triple<Double, Double, Double> classifyAndWriteAnswers(Collection<List<IN>> documents, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        return this.classifyAndWriteAnswers(documents, IOUtils.encodedOutputStreamPrintWriter(System.out, this.flags.outputEncoding, true), readerWriter, outputScores);
    }

    public Triple<Double, Double, Double> classifyAndWriteAnswers(Collection<List<IN>> documents, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        if (this.flags.exportFeatures != null) {
            this.dumpFeatures(documents);
        }
        Timing timer = new Timing();
        ClassicCounter<String> entityTP = new ClassicCounter<String>();
        ClassicCounter<String> entityFP = new ClassicCounter<String>();
        ClassicCounter<String> entityFN = new ClassicCounter<String>();
        boolean resultsCounted = outputScores;
        int numWords = 0;
        int numDocs = 0;
        final AtomicInteger threadCompletionCounter = new AtomicInteger(0);
        ThreadsafeProcessor threadProcessor = new ThreadsafeProcessor<List<IN>, List<IN>>(){

            @Override
            public List<IN> process(List<IN> doc) {
                doc = AbstractSequenceClassifier.this.classify(doc);
                int completedNo = threadCompletionCounter.incrementAndGet();
                if (AbstractSequenceClassifier.this.flags.verboseMode) {
                    log.info(completedNo + " examples completed");
                }
                return doc;
            }

            @Override
            public ThreadsafeProcessor<List<IN>, List<IN>> newInstance() {
                return this;
            }
        };
        MulticoreWrapper wrapper = null;
        if (this.flags.multiThreadClassifier != 0) {
            wrapper = new MulticoreWrapper(this.flags.multiThreadClassifier, threadProcessor);
        }
        for (List<IN> doc : documents) {
            List results;
            numWords += doc.size();
            ++numDocs;
            if (wrapper != null) {
                wrapper.put(doc);
                while (wrapper.peek()) {
                    results = (List)wrapper.poll();
                    this.writeAnswers(results, printWriter, readerWriter);
                    resultsCounted = resultsCounted && this.countResults(results, entityTP, entityFP, entityFN);
                }
                continue;
            }
            results = (List)threadProcessor.process(doc);
            this.writeAnswers(results, printWriter, readerWriter);
            resultsCounted = resultsCounted && this.countResults(results, entityTP, entityFP, entityFN);
        }
        if (wrapper != null) {
            wrapper.join();
            while (wrapper.peek()) {
                List results = (List)wrapper.poll();
                this.writeAnswers(results, printWriter, readerWriter);
                resultsCounted = resultsCounted && this.countResults(results, entityTP, entityFP, entityFN);
            }
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        log.info(StringUtils.getShortClassName(this) + " tagged " + numWords + " words in " + numDocs + " documents at " + nf.format(wordspersec) + " words per second.");
        if (outputScores) {
            return AbstractSequenceClassifier.printResults(entityTP, entityFP, entityFN);
        }
        return null;
    }

    public void classifyAndWriteAnswersKBest(String testFile, int k, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerAndWriter);
        PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(System.out, this.flags.outputEncoding, true);
        this.classifyAndWriteAnswersKBest(documents, k, pw, readerAndWriter);
        pw.flush();
    }

    public void classifyAndWriteAnswersKBest(ObjectBank<List<IN>> documents, int k, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        Timing timer = new Timing();
        int numWords = 0;
        int numSentences = 0;
        for (List<IN> doc : documents) {
            Counter<List<IN>> kBest = this.classifyKBest(doc, CoreAnnotations.AnswerAnnotation.class, k);
            numWords += doc.size();
            List<List<IN>> sorted = Counters.toSortedList(kBest);
            int n = 1;
            for (List<IN> l : sorted) {
                printWriter.println("<sentence id=" + numSentences + " k=" + n + " logProb=" + kBest.getCount(l) + " prob=" + Math.exp(kBest.getCount(l)) + '>');
                this.writeAnswers(l, printWriter, readerAndWriter);
                printWriter.println("</sentence>");
                ++n;
            }
            ++numSentences;
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        log.info(this.getClass().getName() + " tagged " + numWords + " words in " + numSentences + " documents at " + nf.format(wordspersec) + " words per second.");
    }

    public void classifyAndWriteViterbiSearchGraph(String testFile, String searchGraphPrefix, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        Timing timer = new Timing();
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerAndWriter);
        int numWords = 0;
        int numSentences = 0;
        for (List<IN> doc : documents) {
            DFSA<String, Integer> tagLattice = this.getViterbiSearchGraph(doc, CoreAnnotations.AnswerAnnotation.class);
            numWords += doc.size();
            PrintWriter latticeWriter = new PrintWriter(new FileOutputStream(searchGraphPrefix + '.' + numSentences + ".wlattice"));
            PrintWriter vsgWriter = new PrintWriter(new FileOutputStream(searchGraphPrefix + '.' + numSentences + ".lattice"));
            if (readerAndWriter instanceof LatticeWriter) {
                ((LatticeWriter)((Object)readerAndWriter)).printLattice(tagLattice, doc, latticeWriter);
            }
            tagLattice.printAttFsmFormat(vsgWriter);
            latticeWriter.close();
            vsgWriter.close();
            ++numSentences;
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        log.info(this.getClass().getName() + " tagged " + numWords + " words in " + numSentences + " documents at " + nf.format(wordspersec) + " words per second.");
    }

    public void writeAnswers(List<IN> doc, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        if (this.flags.lowerNewgeneThreshold) {
            return;
        }
        if (this.flags.numRuns <= 1) {
            readerAndWriter.printAnswers(doc, printWriter);
            printWriter.flush();
        }
    }

    public boolean countResults(List<IN> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN) {
        String bg;
        String string = bg = this.flags.evaluateBackground ? null : this.flags.backgroundSymbol;
        if (this.flags.sighanPostProcessing) {
            return AbstractSequenceClassifier.countResultsSegmenter(doc, entityTP, entityFP, entityFN);
        }
        return IOBUtils.countEntityResults(doc, entityTP, entityFP, entityFN, bg);
    }

    public static boolean countResultsSegmenter(List<? extends CoreMap> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN) {
        for (int i = 1; i < doc.size(); ++i) {
            CoreMap word = doc.get(i);
            String gold = (String)word.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
            if (gold == null || guess == null) {
                return false;
            }
            if (gold.equals("1") && guess.equals("1")) {
                entityTP.incrementCount(CUT_LABEL, 1.0);
                continue;
            }
            if (gold.equals("0") && guess.equals("1")) {
                entityFP.incrementCount(CUT_LABEL, 1.0);
                continue;
            }
            if (!gold.equals("1") || !guess.equals("0")) continue;
            entityFN.incrementCount(CUT_LABEL, 1.0);
        }
        return true;
    }

    public static Triple<Double, Double, Double> printResults(Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN) {
        TreeSet<String> entities = new TreeSet<String>();
        entities.addAll(entityTP.keySet());
        entities.addAll(entityFP.keySet());
        entities.addAll(entityFN.keySet());
        log.info("         Entity\tP\tR\tF1\tTP\tFP\tFN");
        for (String entity : entities) {
            double tp = entityTP.getCount(entity);
            double fp = entityFP.getCount(entity);
            double fn = entityFN.getCount(entity);
            AbstractSequenceClassifier.printPRLine(entity, tp, fp, fn);
        }
        double tp = entityTP.totalCount();
        double fp = entityFP.totalCount();
        double fn = entityFN.totalCount();
        return AbstractSequenceClassifier.printPRLine("Totals", tp, fp, fn);
    }

    private static Triple<Double, Double, Double> printPRLine(String entity, double tp, double fp, double fn) {
        double precision = tp == 0.0 && fp == 0.0 ? 0.0 : tp / (tp + fp);
        double recall = tp == 0.0 && fn == 0.0 ? 1.0 : tp / (tp + fn);
        double f1 = precision == 0.0 || recall == 0.0 ? 0.0 : 2.0 / (1.0 / precision + 1.0 / recall);
        log.info(String.format("%15s\t%.4f\t%.4f\t%.4f\t%.0f\t%.0f\t%.0f%n", entity, precision, recall, f1, tp, fp, fn));
        return new Triple<Double, Double, Double>(precision * 100.0, recall * 100.0, f1 * 100.0);
    }

    public abstract void serializeClassifier(String var1);

    public abstract void serializeClassifier(ObjectOutputStream var1);

    public void loadClassifierNoExceptions(InputStream in, Properties props) {
        try {
            this.loadClassifier(in, props);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public void loadClassifier(InputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        this.loadClassifier(in, null);
    }

    public void loadClassifier(InputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        this.loadClassifier(new ObjectInputStream(in), props);
    }

    public abstract void loadClassifier(ObjectInputStream var1, Properties var2) throws IOException, ClassCastException, ClassNotFoundException;

    public void loadClassifier(String loadPath) throws ClassCastException, IOException, ClassNotFoundException {
        this.loadClassifier(loadPath, null);
    }

    public void loadClassifier(String loadPath, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(loadPath);){
            Timing t = new Timing();
            this.loadClassifier(is, props);
            t.done(log, "Loading classifier from " + loadPath);
        }
    }

    public void loadClassifierNoExceptions(String loadPath) {
        this.loadClassifierNoExceptions(loadPath, null);
    }

    public void loadClassifierNoExceptions(String loadPath, Properties props) {
        try {
            this.loadClassifier(loadPath, props);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadClassifier(File file) throws ClassCastException, IOException, ClassNotFoundException {
        this.loadClassifier(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadClassifier(File file, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        Timing t = new Timing();
        try (BufferedInputStream bis = file.getName().endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));){
            this.loadClassifier(bis, props);
            t.done(log, "Loading classifier from " + file.getAbsolutePath());
        }
    }

    public void loadClassifierNoExceptions(File file) {
        this.loadClassifierNoExceptions(file, null);
    }

    public void loadClassifierNoExceptions(File file, Properties props) {
        try {
            this.loadClassifier(file, props);
        }
        catch (Exception e) {
            log.info("Error deserializing " + file.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    protected void printFeatures(IN wi, Collection<String> features) {
        if (this.flags.printFeatures == null || this.writtenNum >= this.flags.printFeaturesUpto) {
            return;
        }
        if (this.cliqueWriter == null) {
            this.cliqueWriter = IOUtils.getPrintWriterOrDie("features-" + this.flags.printFeatures + ".txt");
            this.writtenNum = 0;
        }
        if (wi instanceof CoreLabel) {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.PartOfSpeechAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        } else {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        }
        boolean first = true;
        ArrayList<String> featsList = new ArrayList<String>(features);
        Collections.sort(featsList);
        for (String feat : featsList) {
            if (first) {
                first = false;
            } else {
                this.cliqueWriter.print(" ");
            }
            this.cliqueWriter.print(feat);
        }
        this.cliqueWriter.println();
        ++this.writtenNum;
    }

    protected void printFeatureLists(IN wi, Collection<List<String>> features) {
        if (this.flags.printFeatures == null || this.writtenNum >= this.flags.printFeaturesUpto) {
            return;
        }
        this.printFeatureListsHelper(wi, features);
    }

    private void printFeatureListsHelper(IN wi, Collection<List<String>> features) {
        if (this.cliqueWriter == null) {
            this.cliqueWriter = IOUtils.getPrintWriterOrDie("features-" + this.flags.printFeatures + ".txt");
            this.writtenNum = 0;
        }
        if (wi instanceof CoreLabel) {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.PartOfSpeechAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        } else {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        }
        boolean first = true;
        for (List<String> featList : features) {
            ArrayList<String> sortedFeatList = new ArrayList<String>(featList);
            Collections.sort(sortedFeatList);
            for (String feat : sortedFeatList) {
                if (first) {
                    first = false;
                } else {
                    this.cliqueWriter.print(" ");
                }
                this.cliqueWriter.print(feat);
            }
            this.cliqueWriter.print("  ");
        }
        this.cliqueWriter.println();
        ++this.writtenNum;
    }

    public int windowSize() {
        return this.windowSize;
    }
}

