/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.ie.machinereading.structure.ExtractionSentence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ExtractionDataSet
implements Serializable {
    private static final long serialVersionUID = 201150461234284548L;
    private final List<ExtractionSentence> sentences = new ArrayList<ExtractionSentence>();

    public ExtractionDataSet() {
    }

    public ExtractionDataSet(ExtractionDataSet original) {
        for (ExtractionSentence sent : original.getSentences()) {
            ExtractionSentence sentCopy = new ExtractionSentence(sent);
            this.sentences.add(sentCopy);
        }
    }

    public ExtractionSentence getSentence(int i) {
        return this.sentences.get(i);
    }

    public int sentenceCount() {
        return this.sentences.size();
    }

    public void addSentence(ExtractionSentence sentence) {
        this.sentences.add(sentence);
    }

    public void addSentences(List<ExtractionSentence> sentences) {
        for (ExtractionSentence sent : sentences) {
            this.addSentence(sent);
        }
    }

    public List<ExtractionSentence> getSentences() {
        return Collections.unmodifiableList(this.sentences);
    }

    public void shuffle() {
        Collections.shuffle(this.sentences, new Random(0L));
    }
}

