/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.ner;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.classify.LogPrior;
import edu.stanford.nlp.classify.NBLinearClassifierFactory;
import edu.stanford.nlp.classify.ProbabilisticClassifier;
import edu.stanford.nlp.classify.SVMLightClassifierFactory;
import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.sequences.BeamBestSequenceFinder;
import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.MaxSizeConcurrentHashSet;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class CMMClassifier<IN extends CoreLabel>
extends AbstractSequenceClassifier<IN> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(CMMClassifier.class);
    private ProbabilisticClassifier<String, String> classifier;
    Set<List<String>> answerArrays;
    public static final String DEFAULT_CLASSIFIER = "edu/stanford/nlp/models/ner/ner-eng-ie.cmm-3-all2006.ser.gz";
    private static int lastPos = -1;

    protected CMMClassifier() {
        super(new SeqClassifierFlags());
    }

    public CMMClassifier(Properties props) {
        super(props);
    }

    public CMMClassifier(SeqClassifierFlags flags) {
        super(flags);
    }

    public Set<String> getTags() {
        Set<String> tags = Generics.newHashSet(this.classIndex.objectsList());
        tags.remove(this.flags.backgroundSymbol);
        return tags;
    }

    @Override
    public List<IN> classify(List<IN> document) {
        if (this.flags.useSequences) {
            this.classifySeq(document);
        } else {
            this.classifyNoSeq(document);
        }
        return document;
    }

    private void classifyNoSeq(List<IN> document) {
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        if (this.flags.lowerNewgeneThreshold) {
            log.info("Using NEWGENE threshold: " + this.flags.newgeneThreshold);
            int docSize = document.size();
            for (int i = 0; i < docSize; ++i) {
                CoreLabel wordInfo = (CoreLabel)document.get(i);
                Datum<String, String> d = this.makeDatum(document, i, this.featureFactories);
                Counter<String> scores = this.classifier.scoresOf(d);
                String answer = this.flags.backgroundSymbol;
                if ("NEWGENE".equals(wordInfo.get(CoreAnnotations.GazAnnotation.class))) {
                    for (String label : scores.keySet()) {
                        if (!"G".equals(label)) continue;
                        log.info(wordInfo.word() + ':' + scores.getCount(label));
                        if (!(scores.getCount(label) > this.flags.newgeneThreshold)) continue;
                        answer = label;
                    }
                }
                wordInfo.set(CoreAnnotations.AnswerAnnotation.class, answer);
            }
        } else {
            int listSize = document.size();
            for (int i = 0; i < listSize; ++i) {
                String answer = this.classOf(document, i);
                CoreLabel wordInfo = (CoreLabel)document.get(i);
                wordInfo.set(CoreAnnotations.AnswerAnnotation.class, answer);
            }
            if (this.flags.justify && this.classifier instanceof LinearClassifier) {
                LinearClassifier lc = (LinearClassifier)this.classifier;
                int lsize = document.size();
                for (int i = 0; i < lsize; ++i) {
                    CoreLabel lineInfo = (CoreLabel)document.get(i);
                    log.info("@@ Position " + i + ": ");
                    log.info(lineInfo.word() + " chose " + (String)lineInfo.get(CoreAnnotations.AnswerAnnotation.class));
                    lc.justificationOf(this.makeDatum(document, i, this.featureFactories));
                }
            }
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
    }

    protected String classOf(List<IN> lineInfos, int pos) {
        Datum<String, String> d = this.makeDatum(lineInfos, pos, this.featureFactories);
        return this.classifier.classOf(d);
    }

    public double loglikelihood(List<IN> lineInfos) {
        double cll = 0.0;
        for (int i = 0; i < lineInfos.size(); ++i) {
            Datum<String, String> d = this.makeDatum(lineInfos, i, this.featureFactories);
            Counter<String> c = this.classifier.logProbabilityOf(d);
            double total = Double.NEGATIVE_INFINITY;
            for (String s : c.keySet()) {
                total = SloppyMath.logAdd(total, c.getCount(s));
            }
            cll -= c.getCount(d.label()) - total;
        }
        if (this.classifier instanceof LinearClassifier) {
            double sigmaSq = this.flags.sigma * this.flags.sigma;
            LinearClassifier lc = (LinearClassifier)this.classifier;
            for (String feature : lc.features()) {
                for (String classLabel : this.classIndex) {
                    double w = lc.weight(feature, classLabel);
                    cll += w * w / 2.0 / sigmaSq;
                }
            }
        }
        return cll;
    }

    @Override
    public SequenceModel getSequenceModel(List<IN> document) {
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        Scorer<IN> ts = new Scorer<IN>(document, this.classIndex, this, !this.flags.useTaggySequences ? (this.flags.usePrevSequences ? 1 : 0) : this.flags.maxLeft, this.flags.useNextSequences ? 1 : 0, this.answerArrays);
        return ts;
    }

    private void classifySeq(List<IN> document) {
        int[] tags;
        BestSequenceFinder ti;
        if (document.isEmpty()) {
            return;
        }
        SequenceModel ts = this.getSequenceModel(document);
        if (this.flags.useViterbi) {
            ti = new ExactBestSequenceFinder();
            tags = ((ExactBestSequenceFinder)ti).bestSequence(ts);
        } else {
            ti = new BeamBestSequenceFinder(this.flags.beamSize, true, true);
            tags = ((BeamBestSequenceFinder)ti).bestSequence(ts, document.size());
        }
        if (this.flags.lowerNewgeneThreshold) {
            log.info("Using NEWGENE threshold: " + this.flags.newgeneThreshold);
            int[] copy = new int[tags.length];
            System.arraycopy(tags, 0, copy, 0, tags.length);
            int ngTag = this.classIndex.indexOf("G");
            int bgTag = this.classIndex.indexOf(this.flags.backgroundSymbol);
            int dSize = document.size();
            for (int i = 0; i < dSize; ++i) {
                int k;
                int j;
                CoreLabel wordInfo = (CoreLabel)document.get(i);
                if (!"NEWGENE".equals(wordInfo.get(CoreAnnotations.GazAnnotation.class))) continue;
                int start = i;
                for (j = i; j < document.size() && "NEWGENE".equals((wordInfo = (CoreLabel)document.get(j)).get(CoreAnnotations.GazAnnotation.class)); ++j) {
                }
                int end = j;
                int winStart = Math.max(0, start - 4);
                int winEnd = Math.min(tags.length, end + 4);
                for (j = winStart; j < winEnd; ++j) {
                    copy[j] = bgTag;
                }
                double bgScore = 0.0;
                for (j = start; j < end; ++j) {
                    double[] scores = ts.scoresOf(copy, j);
                    scores = Scorer.recenter(scores);
                    bgScore += scores[bgTag];
                }
                ClassicCounter<Pair<Integer, Integer>> prevScores = new ClassicCounter<Pair<Integer, Integer>>();
                for (j = start; j < end; ++j) {
                    for (k = start; k < end; ++k) {
                        copy[k] = bgTag;
                    }
                    for (k = j; k < end; ++k) {
                        copy[k] = ngTag;
                        double ngScore = 0.0;
                        for (int m = start; m < end; ++m) {
                            double[] scores = ts.scoresOf(copy, m);
                            scores = Scorer.recenter(scores);
                            ngScore += scores[tags[m]];
                        }
                        prevScores.incrementCount(new Pair<Integer, Integer>(j, k), ngScore - bgScore);
                    }
                }
                for (j = start; j < end; ++j) {
                    for (k = j; k < end; ++k) {
                        double score = prevScores.getCount(new Pair<Integer, Integer>(j, k));
                        Pair<Integer, Integer> al = new Pair<Integer, Integer>(j - 1, k);
                        Pair<Integer, Integer> ar = new Pair<Integer, Integer>(j, k + 1);
                        Pair<Integer, Integer> sl = new Pair<Integer, Integer>(j + 1, k);
                        Pair<Integer, Integer> sr = new Pair<Integer, Integer>(j, k - 1);
                        if (!(score >= this.flags.newgeneThreshold) || prevScores.containsKey(al) && !(score > prevScores.getCount(al)) || prevScores.containsKey(ar) && !(score > prevScores.getCount(ar)) || prevScores.containsKey(sl) && !(score > prevScores.getCount(sl)) || prevScores.containsKey(sr) && !(score > prevScores.getCount(sr))) continue;
                        StringBuilder sb = new StringBuilder();
                        wordInfo = (CoreLabel)document.get(j);
                        String docId = (String)wordInfo.get(CoreAnnotations.IDAnnotation.class);
                        String startIndex = (String)wordInfo.get(CoreAnnotations.PositionAnnotation.class);
                        wordInfo = (CoreLabel)document.get(k);
                        String endIndex = (String)wordInfo.get(CoreAnnotations.PositionAnnotation.class);
                        for (int m = j; m <= k; ++m) {
                            wordInfo = (CoreLabel)document.get(m);
                            sb.append(wordInfo.word());
                            sb.append(' ');
                        }
                        System.out.println(docId + '|' + startIndex + ' ' + endIndex + '|' + sb.toString().trim());
                    }
                }
                for (j = winStart; j < winEnd; ++j) {
                    copy[j] = tags[j];
                }
                i = end;
            }
        }
        int docSize = document.size();
        for (int i = 0; i < docSize; ++i) {
            CoreLabel lineInfo = (CoreLabel)document.get(i);
            String answer = (String)this.classIndex.get(tags[i]);
            lineInfo.set(CoreAnnotations.AnswerAnnotation.class, answer);
        }
        if (this.flags.justify && this.classifier instanceof LinearClassifier) {
            LinearClassifier lc = (LinearClassifier)this.classifier;
            if (this.flags.dump) {
                lc.dump();
            }
            int docSize2 = document.size();
            for (int i = 0; i < docSize2; ++i) {
                CoreLabel lineInfo = (CoreLabel)document.get(i);
                log.info("@@ Position is: " + i + ": ");
                log.info(lineInfo.word() + ' ' + (String)lineInfo.get(CoreAnnotations.AnswerAnnotation.class));
                lc.justificationOf(this.makeDatum(document, i, this.featureFactories));
            }
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
    }

    public void adapt(String filename, Dataset<String, String> trainDataset, DocumentReaderAndWriter<IN> readerWriter) {
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerWriter);
        this.adapt(docs, trainDataset);
    }

    public void adapt(ObjectBank<List<IN>> featureLabels, Dataset<String, String> trainDataset) {
        Dataset<String, String> adapt = this.getDataset(featureLabels, trainDataset);
        this.adapt(adapt);
    }

    public void retrain(ObjectBank<List<IN>> featureLabels, Index<String> featureIndex, Index<String> labelIndex) {
        int fs = featureIndex.size();
        int ls = labelIndex.size();
        Dataset<String, String> adapt = this.getDataset(featureLabels, featureIndex, labelIndex);
        int prior = LogPrior.LogPriorType.QUADRATIC.ordinal();
        LinearClassifier lc = (LinearClassifier)this.classifier;
        LinearClassifierFactory<String, String> lcf = new LinearClassifierFactory<String, String>(this.flags.tolerance, this.flags.useSum, prior, this.flags.sigma, this.flags.epsilon, this.flags.QNsize);
        double[][] weights = lc.weights();
        Index newF = adapt.featureIndex;
        Index newL = adapt.labelIndex;
        int newFS = newF.size();
        int newLS = newL.size();
        double[] x = new double[newFS * newLS];
        for (int i = 0; i < fs; ++i) {
            for (int j = 0; j < ls; ++j) {
                String f = featureIndex.get(i);
                String l = labelIndex.get(j);
                int newi = newF.indexOf(f) * newLS + newL.indexOf(l);
                x[newi] = weights[i][j];
            }
        }
        weights = lcf.trainWeights(adapt, x);
        lc.setWeights(weights);
    }

    public void retrain(ObjectBank<List<IN>> doc) {
        if (this.classifier == null) {
            throw new UnsupportedOperationException("Cannot retrain before you train!");
        }
        Index<String> findex = ((LinearClassifier)this.classifier).featureIndex();
        Index<String> lindex = ((LinearClassifier)this.classifier).labelIndex();
        log.info("Starting retrain:\t# of original features" + findex.size() + ", # of original labels" + lindex.size());
        this.retrain(doc, findex, lindex);
    }

    @Override
    public void train(Collection<List<IN>> wordInfos, DocumentReaderAndWriter<IN> readerAndWriter) {
        Dataset<String, String> train = this.getDataset(wordInfos);
        this.train(train);
        for (int i = 0; i < this.flags.numTimesPruneFeatures; ++i) {
            Index<String> featuresAboveThreshold = this.getFeaturesAboveThreshold(train, this.flags.featureDiffThresh);
            log.info("Removing features with weight below " + this.flags.featureDiffThresh + " and retraining...");
            train = this.getDataset(train, featuresAboveThreshold);
            int tmp = this.flags.QNsize;
            this.flags.QNsize = this.flags.QNsize2;
            this.train(train);
            this.flags.QNsize = tmp;
        }
        if (this.flags.doAdaptation && this.flags.adaptFile != null) {
            this.adapt(this.flags.adaptFile, train, readerAndWriter);
        }
        log.info("Built this classifier: ");
        if (this.classifier instanceof LinearClassifier) {
            String classString = ((LinearClassifier)this.classifier).toString(this.flags.printClassifier, this.flags.printClassifierParam);
            log.info(classString);
        } else {
            String classString = this.classifier.toString();
            log.info(classString);
        }
    }

    private Index<String> getFeaturesAboveThreshold(Dataset<String, String> dataset, double thresh) {
        if (!(this.classifier instanceof LinearClassifier)) {
            throw new RuntimeException("Attempting to remove features based on weight from a non-linear classifier");
        }
        Index featureIndex = dataset.featureIndex;
        Index labelIndex = dataset.labelIndex;
        HashIndex<String> features = new HashIndex<String>();
        Iterator featureIt = featureIndex.iterator();
        LinearClassifier lc = (LinearClassifier)this.classifier;
        block0: while (featureIt.hasNext()) {
            String f = (String)featureIt.next();
            double smallest = Double.POSITIVE_INFINITY;
            double biggest = Double.NEGATIVE_INFINITY;
            for (String l : labelIndex) {
                double weight = lc.weight(f, l);
                if (weight < smallest) {
                    smallest = weight;
                }
                if (weight > biggest) {
                    biggest = weight;
                }
                if (!(biggest - smallest > thresh)) continue;
                features.add(f);
                continue block0;
            }
        }
        return features;
    }

    public Dataset<String, String> getDataset(Collection<List<IN>> data) {
        return this.getDataset(data, null, null);
    }

    public Dataset<String, String> getDataset(Collection<List<IN>> data, Index<String> featureIndex, Index<String> classIndex) {
        Dataset<Object, Object> train;
        this.makeAnswerArraysAndTagIndex(data);
        int size = 0;
        for (List<IN> list : data) {
            size += list.size();
        }
        log.info("Making Dataset ... ");
        System.err.flush();
        if (featureIndex != null && classIndex != null) {
            log.info("  Using feature/class Index from existing Dataset...");
            log.info("  (This is used when getting Dataset from adaptation set. We want to make the index consistent.)");
            train = new Dataset<String, String>(size, featureIndex, classIndex);
        } else {
            train = new Dataset(size);
        }
        for (List<IN> list : data) {
            if (this.flags.useReverse) {
                Collections.reverse(list);
            }
            int dSize = list.size();
            for (int i = 0; i < dSize; ++i) {
                Datum<String, String> d = this.makeDatum(list, i, this.featureFactories);
                train.add(d);
            }
            if (!this.flags.useReverse) continue;
            Collections.reverse(list);
        }
        log.info("done.");
        if (this.flags.featThreshFile != null) {
            log.info("applying thresholds...");
            List<Pair<Pattern, Integer>> list = CMMClassifier.getThresholds(this.flags.featThreshFile);
            train.applyFeatureCountThreshold(list);
        } else if (this.flags.featureThreshold > 1) {
            log.info("Removing Features with counts < " + this.flags.featureThreshold);
            train.applyFeatureCountThreshold(this.flags.featureThreshold);
        }
        train.summaryStatistics();
        return train;
    }

    public Dataset<String, String> getBiasedDataset(ObjectBank<List<IN>> data, Index<String> featureIndex, Index<String> classIndex) {
        this.makeAnswerArraysAndTagIndex(data);
        HashIndex<String> origFeatIndex = new HashIndex<String>(featureIndex.objectsList());
        int size = 0;
        for (List<IN> list : data) {
            size += list.size();
        }
        log.info("Making Dataset ... ");
        System.err.flush();
        Dataset<String, String> train = new Dataset<String, String>(size, featureIndex, classIndex);
        for (List<IN> list : data) {
            if (this.flags.useReverse) {
                Collections.reverse(list);
            }
            int dsize = list.size();
            for (int i = 0; i < dsize; ++i) {
                Datum<String, String> d = this.makeDatum(list, i, this.featureFactories);
                ArrayList<String> newFeats = new ArrayList<String>();
                for (String f : d.asFeatures()) {
                    if (origFeatIndex.contains(f)) continue;
                    newFeats.add(f);
                }
                train.add(d);
            }
            if (!this.flags.useReverse) continue;
            Collections.reverse(list);
        }
        log.info("done.");
        if (this.flags.featThreshFile != null) {
            log.info("applying thresholds...");
            List<Pair<Pattern, Integer>> list = CMMClassifier.getThresholds(this.flags.featThreshFile);
            train.applyFeatureCountThreshold(list);
        } else if (this.flags.featureThreshold > 1) {
            log.info("Removing Features with counts < " + this.flags.featureThreshold);
            train.applyFeatureCountThreshold(this.flags.featureThreshold);
        }
        train.summaryStatistics();
        return train;
    }

    public Dataset<String, String> getDataset(ObjectBank<List<IN>> data, Dataset<String, String> origDataset) {
        if (origDataset == null) {
            return this.getDataset(data);
        }
        return this.getDataset(data, origDataset.featureIndex, origDataset.labelIndex);
    }

    public Dataset<String, String> getDataset(Dataset<String, String> oldData, Index<String> goodFeatures) {
        int i;
        int[][] oldDataArray = oldData.getDataArray();
        int[] oldLabelArray = oldData.getLabelsArray();
        Index oldFeatureIndex = oldData.featureIndex;
        int[] oldToNewFeatureMap = new int[oldFeatureIndex.size()];
        int[][] newDataArray = new int[oldDataArray.length][];
        log.info("Building reduced dataset...");
        int size = oldFeatureIndex.size();
        int max = 0;
        for (i = 0; i < size; ++i) {
            oldToNewFeatureMap[i] = goodFeatures.indexOf((String)oldFeatureIndex.get(i));
            if (oldToNewFeatureMap[i] <= max) continue;
            max = oldToNewFeatureMap[i];
        }
        for (i = 0; i < oldDataArray.length; ++i) {
            int[] data = oldDataArray[i];
            size = 0;
            for (int oldF : data) {
                if (oldToNewFeatureMap[oldF] <= 0) continue;
                ++size;
            }
            int[] newData = new int[size];
            int index = 0;
            for (int oldF : data) {
                int f = oldToNewFeatureMap[oldF];
                if (f <= 0) continue;
                newData[index++] = f;
            }
            newDataArray[i] = newData;
        }
        Dataset<String, String> train = new Dataset<String, String>(oldData.labelIndex, oldLabelArray, goodFeatures, newDataArray, newDataArray.length);
        log.info("done.");
        if (this.flags.featThreshFile != null) {
            log.info("applying thresholds...");
            List<Pair<Pattern, Integer>> thresh = CMMClassifier.getThresholds(this.flags.featThreshFile);
            train.applyFeatureCountThreshold(thresh);
        } else if (this.flags.featureThreshold > 1) {
            log.info("Removing Features with counts < " + this.flags.featureThreshold);
            train.applyFeatureCountThreshold(this.flags.featureThreshold);
        }
        train.summaryStatistics();
        return train;
    }

    private void adapt(Dataset<String, String> adapt) {
        if (this.flags.classifierType.equalsIgnoreCase("SVM")) {
            throw new UnsupportedOperationException();
        }
        this.adaptMaxEnt(adapt);
    }

    private void adaptMaxEnt(Dataset<String, String> adapt) {
        int prior;
        if (this.classifier instanceof LinearClassifier) {
            prior = LogPrior.LogPriorType.QUADRATIC.ordinal();
            if (this.flags.useHuber) {
                throw new UnsupportedOperationException();
            }
            if (this.flags.useQuartic) {
                throw new UnsupportedOperationException();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        LinearClassifierFactory lcf = new LinearClassifierFactory(this.flags.tolerance, this.flags.useSum, prior, this.flags.adaptSigma, this.flags.epsilon, this.flags.QNsize);
        ((LinearClassifier)this.classifier).adaptWeights(adapt, lcf);
    }

    private void train(Dataset<String, String> train) {
        if (this.flags.classifierType.equalsIgnoreCase("SVM")) {
            this.trainSVM(train);
        } else {
            this.trainMaxEnt(train);
        }
    }

    private void trainSVM(Dataset<String, String> train) {
        SVMLightClassifierFactory fact = new SVMLightClassifierFactory();
        this.classifier = fact.trainClassifier((GeneralDataset)train);
    }

    private void trainMaxEnt(Dataset<String, String> train) {
        Classifier lc;
        int prior = LogPrior.LogPriorType.QUADRATIC.ordinal();
        if (this.flags.useHuber) {
            prior = LogPrior.LogPriorType.HUBER.ordinal();
        } else if (this.flags.useQuartic) {
            prior = LogPrior.LogPriorType.QUARTIC.ordinal();
        }
        if (this.flags.useNB) {
            lc = new NBLinearClassifierFactory(this.flags.sigma).trainClassifier((GeneralDataset)train);
        } else {
            LinearClassifierFactory lcf = new LinearClassifierFactory(this.flags.tolerance, this.flags.useSum, prior, this.flags.sigma, this.flags.epsilon, this.flags.QNsize);
            lcf.setVerbose(true);
            if (this.flags.useQN) {
                lcf.useQuasiNewton(this.flags.useRobustQN);
            } else if (this.flags.useStochasticQN) {
                lcf.useStochasticQN(this.flags.initialGain, this.flags.stochasticBatchSize);
            } else if (this.flags.useSMD) {
                lcf.useStochasticMetaDescent(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.stochasticMethod, this.flags.SGDPasses);
            } else if (this.flags.useSGD) {
                lcf.useStochasticGradientDescent(this.flags.gainSGD, this.flags.stochasticBatchSize);
            } else if (this.flags.useSGDtoQN) {
                lcf.useStochasticGradientDescentToQuasiNewton(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.SGDPasses, this.flags.QNPasses, this.flags.SGD2QNhessSamples, this.flags.QNsize, this.flags.outputIterationsToFile);
            } else if (this.flags.useHybrid) {
                lcf.useHybridMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.stochasticMethod, this.flags.hybridCutoffIteration);
            } else {
                lcf.useConjugateGradientAscent();
            }
            lc = lcf.trainClassifier((GeneralDataset)train);
        }
        this.classifier = lc;
    }

    private void trainSemiSup(Dataset<String, String> data, Dataset<String, String> biasedData, double[][] confusionMatrix) {
        int prior = LogPrior.LogPriorType.QUADRATIC.ordinal();
        if (this.flags.useHuber) {
            prior = LogPrior.LogPriorType.HUBER.ordinal();
        } else if (this.flags.useQuartic) {
            prior = LogPrior.LogPriorType.QUARTIC.ordinal();
        }
        LinearClassifierFactory<String, String> lcf = new LinearClassifierFactory<String, String>(this.flags.tolerance, this.flags.useSum, prior, this.flags.sigma, this.flags.epsilon, this.flags.QNsize);
        if (this.flags.useQN) {
            lcf.useQuasiNewton();
        } else {
            lcf.useConjugateGradientAscent();
        }
        this.classifier = (LinearClassifier)lcf.trainClassifierSemiSup(data, biasedData, confusionMatrix, null);
    }

    @Override
    public void serializeClassifier(String serializePath) {
        log.info("Serializing classifier to " + serializePath + "...");
        try {
            ObjectOutputStream oos = IOUtils.writeStreamFromString(serializePath);
            oos.writeObject(this.classifier);
            oos.writeObject(this.flags);
            oos.writeObject(this.featureFactories);
            oos.writeObject(this.classIndex);
            oos.writeObject(this.answerArrays);
            oos.writeObject(this.knownLCWords);
            oos.close();
            log.info("Done.");
        }
        catch (Exception e) {
            log.info("Error serializing to " + serializePath);
            log.err(e);
        }
    }

    @Override
    public void serializeClassifier(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.classifier);
            oos.writeObject(this.flags);
            oos.writeObject(this.featureFactories);
            oos.writeObject(this.classIndex);
            oos.writeObject(this.answerArrays);
            oos.writeObject(this.knownLCWords);
            oos.close();
            log.info("Done.");
        }
        catch (Exception e) {
            log.err(e);
        }
    }

    public void loadDefaultClassifier() {
        this.loadClassifierNoExceptions(DEFAULT_CLASSIFIER, null);
    }

    public static CMMClassifier<? extends CoreLabel> getDefaultClassifier() {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadDefaultClassifier();
        return cmm;
    }

    @Override
    public void loadClassifier(ObjectInputStream ois, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        this.classifier = (LinearClassifier)ois.readObject();
        this.flags = (SeqClassifierFlags)ois.readObject();
        Object featureFactory = ois.readObject();
        if (featureFactory instanceof List) {
            this.featureFactories = (List)ErasureUtils.uncheckedCast(featureFactory);
        } else if (featureFactory instanceof FeatureFactory) {
            this.featureFactories = Generics.newArrayList();
            this.featureFactories.add((FeatureFactory)featureFactory);
        }
        if (props != null) {
            this.flags.setProperties(props);
        }
        this.reinit();
        this.classIndex = (Index)ois.readObject();
        this.answerArrays = (Set)ois.readObject();
        this.knownLCWords = (MaxSizeConcurrentHashSet)ois.readObject();
    }

    public static CMMClassifier<? extends CoreLabel> getClassifierNoExceptions(File file) {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadClassifierNoExceptions(file);
        return cmm;
    }

    public static CMMClassifier<? extends CoreLabel> getClassifier(File file) throws IOException, ClassCastException, ClassNotFoundException {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadClassifier(file);
        return cmm;
    }

    public static CMMClassifier<CoreLabel> getClassifierNoExceptions(String loadPath) {
        CMMClassifier<CoreLabel> cmm = new CMMClassifier<CoreLabel>();
        cmm.loadClassifierNoExceptions(loadPath);
        return cmm;
    }

    public static CMMClassifier<? extends CoreLabel> getClassifier(String loadPath) throws IOException, ClassCastException, ClassNotFoundException {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadClassifier(loadPath);
        return cmm;
    }

    public static CMMClassifier<? extends CoreLabel> getClassifierNoExceptions(InputStream in) {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadClassifierNoExceptions(new BufferedInputStream(in), null);
        return cmm;
    }

    public static <INN extends CoreMap> CMMClassifier<? extends CoreLabel> getClassifier(ObjectInputStream ois) throws IOException, ClassCastException, ClassNotFoundException {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadClassifier(ois, null);
        return cmm;
    }

    public static <INN extends CoreMap> CMMClassifier<? extends CoreLabel> getClassifier(ObjectInputStream ois, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadClassifier(ois, props);
        return cmm;
    }

    public static CMMClassifier<? extends CoreLabel> getClassifier(InputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        CMMClassifier cmm = new CMMClassifier();
        cmm.loadClassifier(new BufferedInputStream(in));
        return cmm;
    }

    private void makeAnswerArraysAndTagIndex(Collection<List<IN>> docs) {
        if (this.answerArrays == null) {
            this.answerArrays = Generics.newHashSet();
        }
        if (this.classIndex == null) {
            this.classIndex = new HashIndex();
        }
        for (List<IN> doc : docs) {
            if (this.flags.useReverse) {
                Collections.reverse(doc);
            }
            int leng = doc.size();
            for (int start = 0; start < leng; ++start) {
                for (int diff = 1; diff <= this.flags.maxLeft && start + diff <= leng; ++diff) {
                    String[] seq = new String[diff];
                    for (int i = start; i < start + diff; ++i) {
                        seq[i - start] = (String)((CoreLabel)doc.get(i)).get(CoreAnnotations.AnswerAnnotation.class);
                    }
                    this.answerArrays.add(Arrays.asList(seq));
                }
            }
            for (CoreLabel wordInfo : doc) {
                this.classIndex.add((String)wordInfo.get(CoreAnnotations.AnswerAnnotation.class));
            }
            if (!this.flags.useReverse) continue;
            Collections.reverse(doc);
        }
    }

    public Datum<String, String> makeDatum(List<IN> info, int loc, List<FeatureFactory<IN>> featureFactories) {
        PaddedList<CoreLabel> pInfo = new PaddedList<CoreLabel>(info, (CoreLabel)this.pad);
        ArrayList<String> features = new ArrayList<String>();
        for (FeatureFactory<CoreLabel> featureFactory : featureFactories) {
            List<Clique> cliques = featureFactory.getCliques();
            for (Clique c : cliques) {
                Collection<String> feats = featureFactory.getCliqueFeatures(pInfo, loc, c);
                feats = CMMClassifier.addOtherClasses(feats, pInfo, loc, c);
                features.addAll(feats);
            }
        }
        this.printFeatures(pInfo.get(loc), features);
        CoreLabel c = (CoreLabel)info.get(loc);
        return new BasicDatum<String, String>(features, (String)c.get(CoreAnnotations.AnswerAnnotation.class));
    }

    private static Collection<String> addOtherClasses(Collection<String> feats, List<? extends CoreLabel> info, int loc, Clique c) {
        String addend = null;
        String pAnswer = (String)info.get(loc - 1).get(CoreAnnotations.AnswerAnnotation.class);
        String p2Answer = (String)info.get(loc - 2).get(CoreAnnotations.AnswerAnnotation.class);
        String p3Answer = (String)info.get(loc - 3).get(CoreAnnotations.AnswerAnnotation.class);
        String p4Answer = (String)info.get(loc - 4).get(CoreAnnotations.AnswerAnnotation.class);
        String p5Answer = (String)info.get(loc - 5).get(CoreAnnotations.AnswerAnnotation.class);
        String nAnswer = (String)info.get(loc + 1).get(CoreAnnotations.AnswerAnnotation.class);
        if (c == FeatureFactory.cliqueCpC) {
            addend = '|' + pAnswer;
        } else if (c == FeatureFactory.cliqueCp2C) {
            addend = '|' + p2Answer;
        } else if (c == FeatureFactory.cliqueCp3C) {
            addend = '|' + p3Answer;
        } else if (c == FeatureFactory.cliqueCp4C) {
            addend = '|' + p4Answer;
        } else if (c == FeatureFactory.cliqueCp5C) {
            addend = '|' + p5Answer;
        } else if (c == FeatureFactory.cliqueCpCp2C) {
            addend = '|' + pAnswer + '-' + p2Answer;
        } else if (c == FeatureFactory.cliqueCpCp2Cp3C) {
            addend = '|' + pAnswer + '-' + p2Answer + '-' + p3Answer;
        } else if (c == FeatureFactory.cliqueCpCp2Cp3Cp4C) {
            addend = '|' + pAnswer + '-' + p2Answer + '-' + p3Answer + '-' + p4Answer;
        } else if (c == FeatureFactory.cliqueCpCp2Cp3Cp4Cp5C) {
            addend = '|' + pAnswer + '-' + p2Answer + '-' + p3Answer + '-' + p4Answer + '-' + p5Answer;
        } else if (c == FeatureFactory.cliqueCnC) {
            addend = '|' + nAnswer;
        } else if (c == FeatureFactory.cliqueCpCnC) {
            addend = '|' + pAnswer + '-' + nAnswer;
        }
        if (addend == null) {
            return feats;
        }
        Set<String> newFeats = Generics.newHashSet();
        for (String feat : feats) {
            String newFeat = feat + addend;
            newFeats.add(newFeat);
        }
        return newFeats;
    }

    private static List<Pair<Pattern, Integer>> getThresholds(String filename) {
        BufferedReader in = null;
        try {
            String line;
            in = IOUtils.readerFromString(filename);
            ArrayList<Pair<Pattern, Integer>> thresholds = new ArrayList<Pair<Pattern, Integer>>();
            while ((line = in.readLine()) != null) {
                int i = line.lastIndexOf(32);
                Pattern p = Pattern.compile(line.substring(0, i));
                Integer t = Integer.valueOf(line.substring(i + 1));
                Pair<Pattern, Integer> pair = new Pair<Pattern, Integer>(p, t);
                thresholds.add(pair);
            }
            in.close();
            ArrayList<Pair<Pattern, Integer>> arrayList = thresholds;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error reading threshold file", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(in);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void trainSemiSup() {
        void var13_19;
        int j;
        int n;
        String[] bits;
        DocumentReaderAndWriter readerAndWriter = this.makeReaderAndWriter();
        String filename = this.flags.trainFile;
        String biasedFilename = this.flags.biasedTrainFile;
        ObjectBank data = this.makeObjectBankFromFile(filename, readerAndWriter);
        ObjectBank biasedData = this.makeObjectBankFromFile(biasedFilename, readerAndWriter);
        HashIndex<String> featureIndex = new HashIndex<String>();
        HashIndex<String> classIndex = new HashIndex<String>();
        Dataset<String, String> dataset = this.getDataset(data, featureIndex, classIndex);
        Dataset<String, String> biasedDataset = this.getBiasedDataset(biasedData, featureIndex, classIndex);
        double[][] confusionMatrix = new double[classIndex.size()][classIndex.size()];
        for (int i2 = 0; i2 < confusionMatrix.length; ++i2) {
            confusionMatrix[i2][i2] = 1.0;
        }
        String cm = this.flags.confusionMatrix;
        for (String bit : bits = cm.split(":")) {
            double d;
            String[] bits1 = bit.split("\\|");
            int i1 = classIndex.indexOf(bits1[0]);
            int i2 = classIndex.indexOf(bits1[1]);
            confusionMatrix[i2][i1] = d = Double.parseDouble(bits1[2]);
        }
        for (double[] row : confusionMatrix) {
            ArrayMath.normalize(row);
        }
        boolean bl = false;
        while (n < confusionMatrix.length) {
            for (j = 0; j < n; ++j) {
                double d = confusionMatrix[n][j];
                confusionMatrix[n][j] = confusionMatrix[j][n];
                confusionMatrix[j][n] = d;
            }
            ++n;
        }
        boolean bl2 = false;
        while (var13_19 < confusionMatrix.length) {
            for (j = 0; j < confusionMatrix.length; ++j) {
                log.info("P(" + (String)classIndex.get(j) + '|' + (String)classIndex.get((int)var13_19) + ") = " + confusionMatrix[j][var13_19]);
            }
            ++var13_19;
        }
        this.trainSemiSup(dataset, biasedDataset, confusionMatrix);
    }

    public double weight(String feature, String label) {
        return ((LinearClassifier)this.classifier).weight(feature, label);
    }

    public double[][] weights() {
        return ((LinearClassifier)this.classifier).weights();
    }

    @Override
    public List<IN> classifyWithGlobalInformation(List<IN> tokenSeq, CoreMap doc, CoreMap sent) {
        return this.classify(tokenSeq);
    }

    private boolean normalize() {
        return this.flags.normalize;
    }

    public Counter<String> scoresOf(List<IN> lineInfos, int pos) {
        Datum<String, String> d = this.makeDatum(lineInfos, pos, this.featureFactories);
        return this.classifier.logProbabilityOf(d);
    }

    @Override
    public Triple<Counter<Integer>, Counter<Integer>, TwoDimensionalCounter<Integer, String>> printProbsDocument(List<IN> document) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        StringUtils.logInvocationString(log, args);
        Properties props = StringUtils.argsToProperties(args);
        CMMClassifier cmm = new CMMClassifier(props);
        String testFile = cmm.flags.testFile;
        String textFile = cmm.flags.textFile;
        String loadPath = cmm.flags.loadClassifier;
        String serializeTo = cmm.flags.serializeTo;
        if (loadPath != null) {
            cmm.loadClassifierNoExceptions(loadPath, props);
        } else if (cmm.flags.loadJarClassifier != null) {
            cmm.loadClassifierNoExceptions(cmm.flags.loadJarClassifier, props);
        } else if (cmm.flags.trainFile != null) {
            if (cmm.flags.biasedTrainFile != null) {
                cmm.trainSemiSup();
            } else {
                cmm.train();
            }
        } else {
            cmm.loadDefaultClassifier();
        }
        if (serializeTo != null) {
            cmm.serializeClassifier(serializeTo);
        }
        if (testFile != null) {
            cmm.classifyAndWriteAnswers(testFile, cmm.makeReaderAndWriter(), true);
        } else if (cmm.flags.testFiles != null) {
            cmm.classifyAndWriteAnswers(cmm.flags.baseTestDir, cmm.flags.testFiles, cmm.makeReaderAndWriter(), true);
        }
        if (textFile != null) {
            PlainTextDocumentReaderAndWriter readerAndWriter = new PlainTextDocumentReaderAndWriter();
            cmm.classifyAndWriteAnswers(textFile, readerAndWriter, false);
        }
    }

    static class Scorer<INN extends CoreLabel>
    implements SequenceModel {
        private final CMMClassifier<INN> classifier;
        private final int[] tagArray;
        private final int[] backgroundTags;
        private final Index<String> tagIndex;
        private final List<INN> lineInfos;
        private final int pre;
        private final int post;
        private final Set<List<String>> legalTags;
        private static final boolean VERBOSE = false;
        private double[] scoreCache = null;
        private int[] lastWindow = null;
        private int percent = -1;
        private int num = 0;
        private long secs = System.currentTimeMillis();
        private long hit = 0L;
        private long tot = 0L;

        private static int[] buildTagArray(int sz) {
            int[] temp = new int[sz];
            for (int i = 0; i < sz; ++i) {
                temp[i] = i;
            }
            return temp;
        }

        @Override
        public int length() {
            return this.lineInfos.size() - this.pre - this.post;
        }

        @Override
        public int leftWindow() {
            return this.pre;
        }

        @Override
        public int rightWindow() {
            return this.post;
        }

        @Override
        public int[] getPossibleValues(int position) {
            if (position < this.pre) {
                return this.backgroundTags;
            }
            return this.tagArray;
        }

        @Override
        public double scoreOf(int[] sequence) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            int i;
            if (this.lastWindow == null) {
                this.lastWindow = new int[this.leftWindow() + this.rightWindow() + 1];
                Arrays.fill(this.lastWindow, -1);
            }
            boolean match = pos == lastPos;
            for (i = pos - this.leftWindow(); i <= pos + this.rightWindow(); ++i) {
                if (i == pos || i < 0) continue;
                match &= tags[i] == this.lastWindow[i - pos + this.leftWindow()];
            }
            if (!match) {
                this.scoreCache = this.scoresOf(tags, pos);
                for (i = pos - this.leftWindow(); i <= pos + this.rightWindow(); ++i) {
                    if (i < 0) continue;
                    this.lastWindow[i - pos + this.leftWindow()] = tags[i];
                }
                lastPos = pos;
            }
            return this.scoreCache[tags[pos]];
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            String[] answers = new String[1 + this.leftWindow() + this.rightWindow()];
            String[] pre = new String[this.leftWindow()];
            for (int i = 0; i < 1 + this.leftWindow() + this.rightWindow(); ++i) {
                int absPos = pos - this.leftWindow() + i;
                if (absPos < 0) continue;
                answers[i] = this.tagIndex.get(tags[absPos]);
                CoreLabel li = (CoreLabel)this.lineInfos.get(absPos);
                li.set(CoreAnnotations.AnswerAnnotation.class, answers[i]);
                if (i >= this.leftWindow()) continue;
                pre[i] = answers[i];
            }
            double[] scores = new double[this.tagIndex.size()];
            if (!this.legalTags.contains(Arrays.asList(pre)) && this.classifier.flags.useObservedSequencesOnly) {
                Arrays.fill(scores, -1000.0);
                return scores;
            }
            ++this.num;
            ++this.hit;
            Counter<String> c = this.classifier.scoresOf(this.lineInfos, pos);
            for (String s : c.keySet()) {
                int t = this.tagIndex.indexOf(s);
                if (t <= -1) continue;
                int[] tA = this.getPossibleValues(pos);
                for (int j = 0; j < tA.length; ++j) {
                    if (tA[j] != t) continue;
                    scores[j] = c.getCount(s);
                }
            }
            if (((CMMClassifier)this.classifier).normalize()) {
                ArrayMath.logNormalize(scores);
            }
            return scores;
        }

        static double[] recenter(double[] x) {
            double[] r = new double[x.length];
            double logTotal = ArrayMath.logSum(x);
            for (int i = 0; i < x.length; ++i) {
                r[i] = x[i] - logTotal;
            }
            return r;
        }

        Scorer(List<INN> lineInfos, Index<String> tagIndex, CMMClassifier<INN> classifier, int pre, int post, Set<List<String>> legalTags) {
            this.pre = pre;
            this.post = post;
            this.lineInfos = lineInfos;
            this.tagIndex = tagIndex;
            this.classifier = classifier;
            this.legalTags = legalTags;
            this.backgroundTags = new int[]{tagIndex.indexOf(classifier.flags.backgroundSymbol)};
            this.tagArray = Scorer.buildTagArray(tagIndex.size());
        }
    }
}

