/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic;

import edu.stanford.nlp.international.arabic.Buckwalter;
import edu.stanford.nlp.international.arabic.pipeline.DefaultLexicalMapper;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.trees.treebank.Mapper;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ArabicVerbStemBank {
    private static Redwood.RedwoodChannels log = Redwood.channels(ArabicVerbStemBank.class);
    private static ArabicVerbStemBank thisInstance = null;
    private final Map<String, String> verbStems = Generics.newHashMap();
    private final Buckwalter b2a = new Buckwalter();
    private final Mapper lexMapper = new DefaultLexicalMapper();

    private ArabicVerbStemBank() {
    }

    public static synchronized ArabicVerbStemBank getInstance() {
        if (thisInstance == null) {
            thisInstance = new ArabicVerbStemBank();
        }
        return thisInstance;
    }

    public String getStem(String word) {
        if (this.verbStems.containsKey(word)) {
            return this.verbStems.get(word);
        }
        return word;
    }

    public void load(String filename) {
        try {
            BufferedReader br = IOUtils.readerFromString(filename);
            while (br.ready()) {
                String[] toks = br.readLine().split("\\t");
                List<String> toksList = Arrays.asList(toks);
                assert (toksList.size() == 8);
                String word = toksList.get(0).replaceAll("\\|", "");
                String stem = toksList.get(7).replaceAll("[_|-].*\\d$", "");
                if (stem.equals("NA") || stem.equals("O")) continue;
                stem = this.lexMapper.map(null, stem);
                String uniStem = this.b2a.buckwalterToUnicode(stem);
                if (this.verbStems.containsKey(word)) continue;
                this.verbStems.put(word, uniStem);
            }
            System.err.printf("%s: Loaded %d stems\n", this.getClass().getName(), this.verbStems.keySet().size());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void debugPrint(PrintWriter pw) {
        for (String word : this.verbStems.keySet()) {
            pw.printf("%s : %s\n", word, this.getStem(word));
        }
    }

    public static void main(String[] args) {
        ArabicVerbStemBank vsb = ArabicVerbStemBank.getInstance();
        vsb.load("e.test");
        PrintWriter pw = new PrintWriter(System.out, true);
        vsb.debugPrint(pw);
    }
}

