/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordTag;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabelsTest {
    @Before
    public void setUp() {
    }

    private static void internalValidation(String type, Label lab, String val) {
        Assert.assertEquals((String)(type + " does not have value it was constructed with"), (Object)lab.value(), (Object)val);
        String newVal = "feijoa";
        lab.setValue(newVal);
        Assert.assertEquals((String)(type + " does not have value set with setValue"), (Object)newVal, (Object)lab.value());
        lab.setValue(val);
        String out2 = lab.toString();
        Label lab3 = lab.labelFactory().newLabel(val);
        Assert.assertEquals((String)(type + " made by label factory has different value"), (Object)lab.value(), (Object)lab3.value());
        lab3 = lab.labelFactory().newLabel(lab);
        Assert.assertEquals((String)(type + " made from label factory is not equal"), (Object)lab, (Object)lab3);
        try {
            Label lab2 = lab.labelFactory().newLabelFromString(out2);
            Assert.assertEquals((String)(type + " factory fromString and toString are not inverses"), (Object)lab, (Object)lab2);
            lab3.setFromString(out2);
            Assert.assertEquals((String)(type + " setFromString and toString are not inverses"), (Object)lab, (Object)lab3);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static void validateHasTag(String type, HasTag lab, String tag) {
        Assert.assertEquals((String)(type + " does not have tag it was constructed with"), (Object)lab.tag(), (Object)tag);
        String newVal = "feijoa";
        lab.setTag(newVal);
        Assert.assertEquals((String)(type + " does not have tag set with setTag"), (Object)newVal, (Object)lab.tag());
        lab.setTag(tag);
    }

    @Test
    public void testStringLabel() {
        String val = "octopus";
        StringLabel sl = new StringLabel(val);
        LabelsTest.internalValidation("StringLabel ", sl, val);
    }

    @Test
    public void testWord() {
        String val = "octopus";
        Word sl = new Word(val);
        LabelsTest.internalValidation("Word ", sl, val);
    }

    @Test
    public void testTaggedWord() {
        String val = "fish";
        TaggedWord sl = new TaggedWord(val);
        LabelsTest.internalValidation("TaggedWord", sl, val);
        String tag = "NN";
        sl = new TaggedWord(val, tag);
        LabelsTest.internalValidation("TaggedWord", sl, val);
        LabelsTest.validateHasTag("TaggedWord", sl, tag);
        TaggedWord tw2 = new TaggedWord(sl);
        LabelsTest.internalValidation("TaggedWord", tw2, val);
        LabelsTest.validateHasTag("TaggedWord", tw2, tag);
    }

    @Test
    public void testWordTag() {
        String val = "fowl";
        WordTag sl = new WordTag(val);
        LabelsTest.internalValidation("WordTag", sl, val);
        String tag = "NN";
        sl = new WordTag(val, tag);
        LabelsTest.internalValidation("WordTag", sl, val);
        LabelsTest.validateHasTag("WordTag", sl, tag);
        WordTag wt2 = new WordTag(sl);
        LabelsTest.internalValidation("WordTag", wt2, val);
        LabelsTest.validateHasTag("WordTag", wt2, tag);
    }
}

