/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.process.Morphology;

public class WordLemmaTagFactory
implements LabelFactory {
    public static final int LEMMA_LABEL = 1;
    public static final int TAG_LABEL = 2;
    private final char divider;

    public WordLemmaTagFactory() {
        this('/');
    }

    public WordLemmaTagFactory(char divider) {
        this.divider = divider;
    }

    @Override
    public Label newLabel(String labelStr) {
        return new WordLemmaTag(labelStr);
    }

    @Override
    public Label newLabel(String labelStr, int options) {
        if (options == 2) {
            return new WordLemmaTag(null, null, labelStr);
        }
        if (options == 1) {
            return new WordLemmaTag(null, labelStr, null);
        }
        return new WordLemmaTag(labelStr);
    }

    @Override
    public Label newLabelFromString(String labelStr) {
        int second;
        int first = labelStr.indexOf(this.divider);
        if (first == (second = labelStr.lastIndexOf(this.divider))) {
            return new WordLemmaTag(labelStr.substring(0, first), Morphology.lemmaStatic(labelStr.substring(0, first), labelStr.substring(first + 1)), labelStr.substring(first + 1));
        }
        if (first >= 0) {
            return new WordLemmaTag(labelStr.substring(0, first), labelStr.substring(first + 1, second), labelStr.substring(second + 1));
        }
        return new WordLemmaTag(labelStr);
    }

    @Override
    public Label newLabel(Label oldLabel) {
        return new WordLemmaTag(oldLabel);
    }
}

