/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.NDArray;
import edu.stanford.nlp.loglinear.model.proto.ConcatVectorTableProto;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Supplier;

public class ConcatVectorTable
extends NDArray<Supplier<ConcatVector>> {
    NDArray<Supplier<ConcatVector>> originalThunks = null;

    public ConcatVectorTable(int[] dimensions) {
        super(dimensions);
    }

    public void writeToStream(OutputStream stream) throws IOException {
        this.getProtoBuilder().build().writeTo(stream);
    }

    public static ConcatVectorTable readFromStream(InputStream stream) throws IOException {
        return ConcatVectorTable.readFromProto(ConcatVectorTableProto.ConcatVectorTable.parseFrom(stream));
    }

    public ConcatVectorTableProto.ConcatVectorTable.Builder getProtoBuilder() {
        ConcatVectorTableProto.ConcatVectorTable.Builder b = ConcatVectorTableProto.ConcatVectorTable.newBuilder();
        for (int n : this.getDimensions()) {
            b.addDimensionSize(n);
        }
        Object object = this.iterator();
        while (object.hasNext()) {
            int[] assignment = (int[])object.next();
            b.addFactorTable(((ConcatVector)((Supplier)this.getAssignmentValue(assignment)).get()).getProtoBuilder());
        }
        return b;
    }

    public static ConcatVectorTable readFromProto(ConcatVectorTableProto.ConcatVectorTable proto) {
        int[] neighborSizes = new int[proto.getDimensionSizeCount()];
        for (int i = 0; i < neighborSizes.length; ++i) {
            neighborSizes[i] = proto.getDimensionSize(i);
        }
        ConcatVectorTable factor = new ConcatVectorTable(neighborSizes);
        int i = 0;
        for (int[] assignment : factor) {
            ConcatVector vector = ConcatVector.readFromProto(proto.getFactorTable(i));
            factor.setAssignmentValue(assignment, () -> vector);
            ++i;
        }
        return factor;
    }

    public boolean valueEquals(ConcatVectorTable other, double tolerance) {
        if (!Arrays.equals(other.getDimensions(), this.getDimensions())) {
            return false;
        }
        for (int[] assignment : this) {
            if (((ConcatVector)((Supplier)this.getAssignmentValue(assignment)).get()).valueEquals((ConcatVector)((Supplier)other.getAssignmentValue(assignment)).get(), tolerance)) continue;
            return false;
        }
        return true;
    }

    public void cacheVectors() {
        if (this.originalThunks != null) {
            return;
        }
        this.originalThunks = new NDArray(this.getDimensions());
        Iterator<int[]> fastPassByReferenceIterator = this.fastPassByReferenceIterator();
        int[] assignment = fastPassByReferenceIterator.next();
        while (true) {
            Supplier originalThunk = (Supplier)this.getAssignmentValue(assignment);
            this.originalThunks.setAssignmentValue(assignment, originalThunk);
            ConcatVector result = (ConcatVector)originalThunk.get();
            this.setAssignmentValue(assignment, () -> result);
            if (!fastPassByReferenceIterator.hasNext()) break;
            fastPassByReferenceIterator.next();
        }
    }

    public void releaseCache() {
        if (this.originalThunks != null) {
            Iterator<int[]> fastPassByReferenceIterator = this.fastPassByReferenceIterator();
            int[] assignment = fastPassByReferenceIterator.next();
            while (true) {
                this.setAssignmentValue(assignment, this.originalThunks.getAssignmentValue(assignment));
                if (!fastPassByReferenceIterator.hasNext()) break;
                fastPassByReferenceIterator.next();
            }
            this.originalThunks = null;
        }
    }

    public ConcatVectorTable cloneTable() {
        ConcatVectorTable copy = new ConcatVectorTable((int[])this.getDimensions().clone());
        Iterator<int[]> fastPassByReferenceIterator = this.fastPassByReferenceIterator();
        int[] assignment = fastPassByReferenceIterator.next();
        while (true) {
            copy.setAssignmentValue(assignment, (Supplier)this.getAssignmentValue(assignment));
            if (!fastPassByReferenceIterator.hasNext()) break;
            fastPassByReferenceIterator.next();
        }
        return copy;
    }
}

