/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.math;

public class DoubleAD
extends Number {
    private static final long serialVersionUID = -5702334375099248894L;
    private double val;
    private double dot;

    public DoubleAD() {
        this.setval(0.0);
        this.setdot(1.0);
    }

    public DoubleAD(double initVal, double initDot) {
        this.val = initVal;
        this.dot = initDot;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleAD)) {
            return false;
        }
        DoubleAD b = (DoubleAD)obj;
        return b.getval() == this.val && b.getdot() == this.dot;
    }

    public boolean equals(double valToCompare, double dotToCompare) {
        return valToCompare == this.val && dotToCompare == this.dot;
    }

    public boolean equals(double valToCompare, double dotToCompare, double TOL) {
        return Math.abs(valToCompare - this.val) < TOL && Math.abs(dotToCompare - this.dot) < TOL;
    }

    public double getval() {
        return this.val;
    }

    public double getdot() {
        return this.dot;
    }

    public void set(double value, double dotValue) {
        this.val = value;
        this.dot = dotValue;
    }

    public void setval(double a) {
        this.val = a;
    }

    public void setdot(double a) {
        this.dot = a;
    }

    public void plusEqualsConst(double a) {
        this.setval(this.val + a);
    }

    public void plusEquals(DoubleAD a) {
        this.setval(this.val + a.getval());
        this.setdot(this.dot + a.getdot());
    }

    public void minusEquals(DoubleAD a) {
        this.setval(this.val - a.getval());
        this.setdot(this.dot - a.getdot());
    }

    public void minusEqualsConst(double a) {
        this.setval(this.val - a);
    }

    @Override
    public double doubleValue() {
        return this.getval();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public String toString() {
        return "Value= " + this.val + "; Dot= " + this.dot;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.val);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.dot);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

