/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Function;
import java.util.Random;
import junit.framework.TestCase;

public class DiffFunctionTest
extends TestCase {
    private static final Random r = new Random();

    private static double[] estimateGradient(Function f, double[] x, int[] testIndices, double eps) {
        double[] lowAnswer = new double[testIndices.length];
        double[] answer = new double[testIndices.length];
        for (int i = 0; i < testIndices.length; ++i) {
            double orig = x[testIndices[i]];
            int n = testIndices[i];
            x[n] = x[n] - eps;
            lowAnswer[i] = f.valueAt(x);
            x[testIndices[i]] = orig + eps;
            answer[i] = f.valueAt(x);
            x[testIndices[i]] = orig;
            answer[i] = (answer[i] - lowAnswer[i]) / (2.0 * eps);
        }
        return answer;
    }

    public static void gradientCheck(DiffFunction f) {
        for (int deg = -2; deg > -7; --deg) {
            double eps = Math.pow(10.0, deg);
            System.err.println("testing for eps " + eps);
            DiffFunctionTest.gradientCheck(f, eps);
        }
    }

    public static void gradientCheck(DiffFunction f, double eps) {
        double[] x = new double[f.domainDimension()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.random() - 0.5;
        }
        DiffFunctionTest.gradientCheck(f, x, eps);
    }

    public static void gradientCheck(DiffFunction f, double[] x, double eps) {
        int numDim = Math.min(10, x.length);
        int[] ind = new int[numDim];
        if (numDim == x.length) {
            for (int i = 0; i < ind.length; ++i) {
                ind[i] = i;
            }
        } else {
            ind[0] = 0;
            ind[1] = x.length - 1;
            for (int i = 2; i < ind.length; ++i) {
                ind[i] = r.nextInt(x.length - 2) + 1;
            }
        }
        DiffFunctionTest.gradientCheck(f, x, ind, eps);
    }

    public static void gradientCheck(DiffFunction f, double[] x, int[] ind, double eps) {
        double[] testGrad = DiffFunctionTest.estimateGradient(f, x, ind, eps);
        double[] fullGrad = f.derivativeAt(x);
        double[] fGrad = new double[ind.length];
        for (int i = 0; i < ind.length; ++i) {
            fGrad[i] = fullGrad[ind[i]];
        }
        double[] diff = ArrayMath.pairwiseSubtract(testGrad, fGrad);
        System.err.println("1-norm:" + ArrayMath.norm_1(diff));
        DiffFunctionTest.assertEquals((double)0.0, (double)ArrayMath.norm_1(diff), (double)(2.0 * eps));
        System.err.println("2-norm:" + ArrayMath.norm(diff));
        DiffFunctionTest.assertEquals((double)0.0, (double)ArrayMath.norm(diff), (double)(2.0 * eps));
        System.err.println("inf-norm:" + ArrayMath.norm_inf(diff));
        DiffFunctionTest.assertEquals((double)0.0, (double)ArrayMath.norm_inf(diff), (double)(2.0 * eps));
        System.err.println("pearson:" + ArrayMath.pearsonCorrelation(testGrad, fGrad));
        DiffFunctionTest.assertEquals((double)1.0, (double)ArrayMath.pearsonCorrelation(testGrad, fGrad), (double)(2.0 * eps));
    }

    public void testXSquaredPlusOne() {
        DiffFunctionTest.gradientCheck(new DiffFunction(){

            @Override
            public double[] derivativeAt(double[] x) {
                return ArrayMath.add(ArrayMath.multiply(x, 2.0), 1.0);
            }

            @Override
            public double valueAt(double[] x) {
                return ArrayMath.innerProduct(x, ArrayMath.add(x, 1.0));
            }

            @Override
            public int domainDimension() {
                return 10000;
            }
        });
    }
}

