/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class ThreadedParserSlowITest
extends TestCase {
    public static final String englishTrees = "/u/nlp/data/lexparser/testtrees/engwsj160.mrg";
    public static final String englishEncoding = "utf-8";
    public static final String englishPCFG = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    public static final String englishFactored = "/u/nlp/data/lexparser/englishFactored.ser.gz";
    public static final String germanTrees = "/u/nlp/data/lexparser/testtrees/german133.mrg";
    public static final String germanEncoding = "ISO-8859-1";
    public static final String germanPCFG = "/u/nlp/data/lexparser/germanPCFG.ser.gz";
    public static final String germanFactored = "/u/nlp/data/lexparser/germanFactored.ser.gz";
    public static final String frenchTrees = "/u/nlp/data/lexparser/testtrees/french99.mrg";
    public static final String frenchEncoding = "UTF-8";
    public static final String frenchFactored = "/u/nlp/data/lexparser/frenchFactored.ser.gz";
    public static final String arabicTrees = "/u/nlp/data/lexparser/testtrees/arabic99.mrg";
    public static final String arabicEncoding = "UTF-8";
    public static final String arabicFactored = "/u/nlp/data/lexparser/arabicFactored.ser.gz";
    public static final String chineseTrees = "/u/nlp/data/lexparser/testtrees/chinese100.mrg";
    public static final String chineseEncoding = "utf-8";
    public static final String chinesePCFG = "/u/nlp/data/lexparser/chinesePCFG.ser.gz";
    public static final String chineseFactored = "/u/nlp/data/lexparser/chineseFactored.ser.gz";
    public static Map<String, List<Tree>> expectedResults;
    public static Map<String, List<Tree>> inputTrees;

    public static List<Tree> readTrees(String filename, String encoding) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        try {
            Tree next;
            LabeledScoredTreeReaderFactory trf = new LabeledScoredTreeReaderFactory();
            TreeReader tr = trf.newTreeReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
            while ((next = tr.readTree()) != null) {
                trees.add(next);
            }
            System.out.println("Read " + trees.size() + " trees from " + filename);
            return trees;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Tree> processFile(LexicalizedParser parser, List<Tree> input) {
        ArrayList<Tree> results = new ArrayList<Tree>();
        for (Tree tree : input) {
            ArrayList sentence = tree.yieldHasWord();
            Tree output = parser.parseTree(sentence);
            results.add(output);
            if (results.size() % 10 != 0 && results.size() != input.size()) continue;
            System.out.println("Processed " + results.size() + " trees");
        }
        return results;
    }

    public static void setupExpectedResults() {
        expectedResults = new HashMap<String, List<Tree>>();
        inputTrees = new HashMap<String, List<Tree>>();
        List<Tree> input = ThreadedParserSlowITest.readTrees(englishTrees, "utf-8");
        inputTrees.put(englishPCFG, input);
        inputTrees.put(englishFactored, input);
        input = ThreadedParserSlowITest.readTrees(germanTrees, germanEncoding);
        inputTrees.put(germanPCFG, input);
        inputTrees.put(germanFactored, input);
        input = ThreadedParserSlowITest.readTrees(frenchTrees, "UTF-8");
        inputTrees.put(frenchFactored, input);
        input = ThreadedParserSlowITest.readTrees(arabicTrees, "UTF-8");
        inputTrees.put(arabicFactored, input);
        input = ThreadedParserSlowITest.readTrees(chineseTrees, "utf-8");
        inputTrees.put(chinesePCFG, input);
        inputTrees.put(chineseFactored, input);
        LexicalizedParser parser = LexicalizedParser.loadModel(englishPCFG, new String[0]);
        List<Tree> results = ThreadedParserSlowITest.processFile(parser, inputTrees.get(englishPCFG));
        expectedResults.put(englishPCFG, results);
        parser = LexicalizedParser.loadModel(englishFactored, new String[0]);
        results = ThreadedParserSlowITest.processFile(parser, inputTrees.get(englishFactored));
        expectedResults.put(englishFactored, results);
        parser = LexicalizedParser.loadModel(germanPCFG, new String[0]);
        results = ThreadedParserSlowITest.processFile(parser, inputTrees.get(germanPCFG));
        expectedResults.put(germanPCFG, results);
        parser = LexicalizedParser.loadModel(germanFactored, new String[0]);
        results = ThreadedParserSlowITest.processFile(parser, inputTrees.get(germanFactored));
        expectedResults.put(germanFactored, results);
        parser = LexicalizedParser.loadModel(frenchFactored, new String[0]);
        parser = LexicalizedParser.loadModel(arabicFactored, new String[0]);
        parser = LexicalizedParser.loadModel(chinesePCFG, new String[0]);
        results = ThreadedParserSlowITest.processFile(parser, inputTrees.get(chinesePCFG));
        expectedResults.put(chinesePCFG, results);
        parser = LexicalizedParser.loadModel(chineseFactored, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() {
        Class<ThreadedParserSlowITest> clazz = ThreadedParserSlowITest.class;
        synchronized (ThreadedParserSlowITest.class) {
            if (expectedResults == null) {
                ThreadedParserSlowITest.setupExpectedResults();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void runFourTests(String pcfg, String factored) throws Exception {
        List<Tree> pcfgInput = inputTrees.get(pcfg);
        List<Tree> factoredInput = inputTrees.get(factored);
        List<Tree> pcfgResults = expectedResults.get(pcfg);
        List<Tree> factoredResults = expectedResults.get(factored);
        LexicalizedParser parser = LexicalizedParser.loadModel(pcfg, new String[0]);
        ThreadedParserSlowITest.runTest(new ParserThread(parser, pcfgInput, pcfgResults), new ParserThread(parser, pcfgInput, pcfgResults));
        parser = LexicalizedParser.loadModel(factored, new String[0]);
        ThreadedParserSlowITest.runTest(new ParserThread(parser, factoredInput, factoredResults), new ParserThread(parser, factoredInput, factoredResults));
        ThreadedParserSlowITest.runTest(new ParserThread(pcfg, pcfgInput, pcfgResults), new ParserThread(pcfg, pcfgInput, pcfgResults));
        ThreadedParserSlowITest.runTest(new ParserThread(pcfg, pcfgInput, pcfgResults), new ParserThread(factored, factoredInput, factoredResults));
    }

    public static void runTwoTests(String parserPath) throws Exception {
        List<Tree> input = inputTrees.get(parserPath);
        List<Tree> results = expectedResults.get(parserPath);
        LexicalizedParser parser = LexicalizedParser.loadModel(parserPath, new String[0]);
        ThreadedParserSlowITest.runTest(new ParserThread(parser, input, results), new ParserThread(parser, input, results));
        ThreadedParserSlowITest.runTest(new ParserThread(parserPath, input, results), new ParserThread(parserPath, input, results));
    }

    public void testEnglish() throws Exception {
        ThreadedParserSlowITest.runFourTests(englishPCFG, englishFactored);
    }

    public void testGerman() throws Exception {
        ThreadedParserSlowITest.runFourTests(germanPCFG, germanFactored);
    }

    public void testChinese() throws Exception {
        ThreadedParserSlowITest.runTwoTests(chinesePCFG);
    }

    public static void runTest(ParserThread ... threads) throws Exception {
        for (ParserThread thread : threads) {
            thread.start();
        }
        for (ParserThread thread : threads) {
            thread.join();
            thread.compareResults();
        }
    }

    public static class ParserThread
    extends Thread {
        private final LexicalizedParser parser;
        private final List<Tree> input;
        private List<Tree> results;
        private List<Tree> expectedResults;

        public ParserThread(String parserFilename, List<Tree> input, List<Tree> expectedResults) {
            this.parser = LexicalizedParser.loadModel(parserFilename, new String[0]);
            this.input = input;
            this.expectedResults = expectedResults;
        }

        public ParserThread(LexicalizedParser parser, List<Tree> input, List<Tree> expectedResults) {
            this.parser = parser;
            this.input = input;
            this.expectedResults = expectedResults;
        }

        public void compareResults() {
            TestCase.assertEquals((int)this.expectedResults.size(), (int)this.results.size());
            for (int i = 0; i < this.expectedResults.size(); ++i) {
                TestCase.assertEquals((Object)this.expectedResults.get(i), (Object)this.results.get(i));
            }
        }

        @Override
        public void run() {
            this.results = ThreadedParserSlowITest.processFile(this.parser, this.input);
        }
    }
}

