/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.dep;

import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.surface.Token;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class DepPattern
extends Pattern {
    int hashCode;
    List<Pair<Token, GrammaticalRelation>> relations;

    public DepPattern(List<Pair<Token, GrammaticalRelation>> relations) {
        super(PatternFactory.PatternType.DEP);
        this.relations = relations;
        this.hashCode = this.toString().hashCode();
    }

    public DepPattern(Token token, GrammaticalRelation relation) {
        super(PatternFactory.PatternType.DEP);
        this.relations = new ArrayList<Pair<Token, GrammaticalRelation>>();
        this.relations.add(new Pair<Token, GrammaticalRelation>(token, relation));
        this.hashCode = this.toString().hashCode();
    }

    @Override
    public CollectionValuedMap<String, String> getRelevantWords() {
        CollectionValuedMap<String, String> relwordsThisPat = new CollectionValuedMap<String, String>();
        for (Pair<Token, GrammaticalRelation> r : this.relations) {
            DepPattern.getRelevantWordsBase(r.first(), relwordsThisPat);
        }
        return relwordsThisPat;
    }

    @Override
    public int equalContext(Pattern p) {
        return -1;
    }

    @Override
    public String toStringSimple() {
        return this.toString();
    }

    @Override
    public String toString(List<String> notAllowedClasses) {
        return this.toString();
    }

    public String toString() {
        if (this.relations.size() > 1) {
            throw new UnsupportedOperationException();
        }
        Pair<Token, GrammaticalRelation> rel = this.relations.get(0);
        String p = "(" + rel.first().toString() + "=parent >" + rel.second().toString() + "=reln {}=node)";
        return p;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object p) {
        if (!(p instanceof DepPattern)) {
            return false;
        }
        return this.toString().equals(((DepPattern)p).toString());
    }

    public static boolean sameGenre(DepPattern p1, DepPattern p2) {
        return true;
    }

    public static boolean subsumes(DepPattern pat, DepPattern p) {
        return false;
    }
}

