/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.dep;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.patterns.dep.DataInstanceDep;
import edu.stanford.nlp.patterns.dep.DepPattern;
import edu.stanford.nlp.patterns.surface.Token;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class DepPatternFactory
extends PatternFactory {
    @ArgumentParser.Option(name="ignoreRels")
    static String ignoreRels = "";
    @ArgumentParser.Option(name="upDepth")
    static int upDepth = 2;
    @ArgumentParser.Option(name="allowedTagsForTrigger")
    static String allowedTagsForTrigger = ".*";
    static Set<Pattern> allowedTagPatternForTrigger = new HashSet<Pattern>();
    static Set<GrammaticalRelation> ignoreRelsSet = new HashSet<GrammaticalRelation>();

    public static void setUp(Properties props) {
        ArgumentParser.fillOptions(DepPatternFactory.class, props);
        ArgumentParser.fillOptions(PatternFactory.class, props);
        for (String s : ignoreRels.split("[,;]")) {
            ignoreRelsSet.add(GrammaticalRelation.valueOf(s));
        }
        for (String s : allowedTagsForTrigger.split("[,;]")) {
            allowedTagPatternForTrigger.add(Pattern.compile(s));
        }
    }

    public static Map<Integer, Set<DepPattern>> getPatternsAroundTokens(DataInstance sent, Set<CandidatePhrase> stopWords) {
        return DepPatternFactory.getPatternsForAllPhrases(sent, stopWords);
    }

    static Map<Integer, Set<DepPattern>> getPatternsForAllPhrases(DataInstance sent, Set<CandidatePhrase> commonWords) {
        Set<IndexedWord> allNodes;
        SemanticGraph graph = ((DataInstanceDep)sent).getGraph();
        HashMap<Integer, Set<DepPattern>> pats4Sent = new HashMap<Integer, Set<DepPattern>>();
        if (graph == null || graph.isEmpty()) {
            System.out.println("graph is empty or null!");
            return null;
        }
        try {
            allNodes = graph.getLeafVertices();
        }
        catch (IllegalArgumentException i) {
            return null;
        }
        for (IndexedWord w : allNodes) {
            pats4Sent.put(w.index() - 1, DepPatternFactory.getContext(w, graph, commonWords, sent));
        }
        return pats4Sent;
    }

    public static DepPattern patternToDepPattern(Pair<IndexedWord, GrammaticalRelation> p, DataInstance sent) {
        Token token = new Token(PatternFactory.PatternType.DEP);
        CoreLabel backingLabel = sent.getTokens().get(p.first().index() - 1);
        assert (backingLabel.containsKey(PatternsAnnotations.ProcessedTextAnnotation.class)) : "the keyset are " + backingLabel.toString(CoreLabel.OutputFormat.ALL);
        token.addORRestriction(PatternsAnnotations.ProcessedTextAnnotation.class, (String)backingLabel.get(PatternsAnnotations.ProcessedTextAnnotation.class));
        return new DepPattern(token, p.second());
    }

    private static boolean ifIgnoreRel(GrammaticalRelation rel) {
        return ignoreRelsSet.contains(rel);
    }

    static Set<DepPattern> getContext(IndexedWord w, SemanticGraph graph, Set<CandidatePhrase> stopWords, DataInstance sent) {
        IndexedWord parent;
        HashSet<DepPattern> patterns = new HashSet<DepPattern>();
        IndexedWord node = w;
        for (int depth = 1; depth <= upDepth && (parent = graph.getParent(node)) != null; ++depth) {
            GrammaticalRelation rel = graph.reln(parent, node);
            for (Pattern tagPattern : allowedTagPatternForTrigger) {
                if (!tagPattern.matcher(parent.tag()).matches() || DepPatternFactory.ifIgnoreRel(rel) || stopWords.contains(CandidatePhrase.createOrGet(parent.word())) || parent.word().length() <= 1) continue;
                Pair<IndexedWord, GrammaticalRelation> pattern = new Pair<IndexedWord, GrammaticalRelation>(parent, rel);
                DepPattern patterndep = DepPatternFactory.patternToDepPattern(pattern, sent);
                if (depth > upDepth) continue;
                patterns.add(patterndep);
            }
            node = parent;
        }
        return patterns;
    }

    public static Set getContext(DataInstance sent, int i, Set<CandidatePhrase> stopWords) {
        SemanticGraph graph = ((DataInstanceDep)sent).getGraph();
        try {
            IndexedWord w = graph.getNodeByIndex(i + 1);
            return DepPatternFactory.getContext(w, graph, stopWords, sent);
        }
        catch (IllegalArgumentException e) {
            return Collections.emptySet();
        }
    }
}

