/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.PatternsForEachTokenDB;
import edu.stanford.nlp.patterns.surface.PatternsForEachTokenInMemory;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class PatternsForEachToken<E> {
    private static ConstantsAndVariables.PatternForEachTokenWay storeWay;

    public abstract void addPatterns(Map<String, Map<Integer, Set<E>>> var1);

    public abstract void addPatterns(String var1, Map<Integer, Set<E>> var2);

    public abstract void createIndexIfUsingDBAndNotExists();

    public abstract Map<Integer, Set<E>> getPatternsForAllTokens(String var1);

    public abstract boolean save(String var1);

    public abstract void setupSearch();

    abstract int size();

    public void updatePatterns(Map<String, Map<Integer, Set<E>>> tempPatsForSents) {
        for (Map.Entry<String, Map<Integer, Set<E>>> en : tempPatsForSents.entrySet()) {
            Map<Integer, Set<E>> m = this.getPatternsForAllTokens(en.getKey());
            if (m == null) {
                m = new HashMap<Integer, Set<E>>();
            }
            tempPatsForSents.get(en.getKey()).putAll(m);
        }
        this.addPatterns(tempPatsForSents);
        this.close();
    }

    public ConstantsAndVariables.PatternForEachTokenWay getStoreWay() {
        return storeWay;
    }

    public static PatternsForEachToken getPatternsInstance(Properties props, ConstantsAndVariables.PatternForEachTokenWay storePatsForEachToken) {
        storeWay = storePatsForEachToken;
        PatternsForEachToken p = null;
        switch (storePatsForEachToken) {
            case MEMORY: {
                p = new PatternsForEachTokenInMemory(props);
                break;
            }
            case DB: {
                p = new PatternsForEachTokenDB(props);
                break;
            }
            case LUCENE: {
                try {
                    Class<?> c = Class.forName("edu.stanford.nlp.patterns.surface.PatternsForEachTokenLucene");
                    p = (PatternsForEachToken)c.getDeclaredConstructor(Properties.class).newInstance(props);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Lucene option is not distributed (license clash). Email us if you really want it.");
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return p;
    }

    public abstract Map<String, Map<Integer, Set<E>>> getPatternsForAllTokens(Collection<String> var1);

    public abstract void close();

    public abstract void load(String var1);
}

