/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.CoreQuote;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.Properties;
import junit.framework.TestCase;

public class QuoteAttributionAnnotatorITest
extends TestCase {
    public String COREF_EXAMPLE = "Joe Smith decided to get lunch.  He said, \"I am going to order a pizza.\"";
    public String COREF_EXAMPLE_TWO = "Chris Anderson went to the store.  Chris said, \"I'd like to order that item.\"";
    public StanfordCoreNLP pipeline;

    public void setUp() {
    }

    public void testCorefExample() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,depparse,coref,quote");
        this.pipeline = new StanfordCoreNLP(props);
        CoreDocument corefDocOne = new CoreDocument(this.COREF_EXAMPLE);
        CoreDocument corefDocTwo = new CoreDocument(this.COREF_EXAMPLE_TWO);
        this.pipeline.annotate(corefDocOne);
        this.pipeline.annotate(corefDocTwo);
        CoreQuote quoteOne = corefDocOne.quotes().get(0);
        CoreQuote quoteTwo = corefDocTwo.quotes().get(0);
        QuoteAttributionAnnotatorITest.assertEquals((String)"\"I am going to order a pizza.\"", (String)quoteOne.text());
        QuoteAttributionAnnotatorITest.assertEquals((String)"He", (String)quoteOne.speaker().get());
        QuoteAttributionAnnotatorITest.assertEquals((String)"Joe Smith", (String)quoteOne.canonicalSpeaker().get());
        QuoteAttributionAnnotatorITest.assertEquals((int)1, (int)corefDocOne.quotes().size());
        QuoteAttributionAnnotatorITest.assertEquals((String)"\"I'd like to order that item.\"", (String)quoteTwo.text());
        QuoteAttributionAnnotatorITest.assertEquals((String)"Chris", (String)quoteTwo.speaker().get());
        QuoteAttributionAnnotatorITest.assertEquals((String)"Chris Anderson", (String)quoteTwo.canonicalSpeaker().get());
        QuoteAttributionAnnotatorITest.assertEquals((int)1, (int)corefDocTwo.quotes().size());
    }
}

