/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import junit.framework.TestCase;

public class StanfordCoreNLPSpeedSlowITest
extends TestCase {
    public String WORKING_DIR = "/scr/nlp/data/stanford-corenlp-testing/speed-test";

    public void setUp() {
    }

    public StanfordCoreNLP buildPipeline() throws IOException {
        File dir = File.createTempFile("StanfordCoreNLPSpeedSlowITest", "");
        dir.delete();
        dir.mkdir();
        dir.deleteOnExit();
        System.out.println("Temp path: " + dir.getPath());
        Properties props = StringUtils.argsToProperties("-props", this.WORKING_DIR + "/test.props");
        props.setProperty("outputDirectory", dir.getPath());
        return new StanfordCoreNLP(props);
    }

    public void testStanfordCoreNLPSpeed() throws IOException {
        List<String> kbp2016FileList = IOUtils.linesFromFile(this.WORKING_DIR + "/kbp-2016-files.txt");
        StanfordCoreNLP pipeline = this.buildPipeline();
        long startTime = System.currentTimeMillis();
        for (String filePath : kbp2016FileList) {
            System.err.println("Processing file: " + filePath);
            CoreDocument currentDoc = new CoreDocument(IOUtils.stringFromFile(filePath));
            pipeline.annotate(currentDoc);
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        System.err.println("run time for single thread test: " + duration);
        StanfordCoreNLPSpeedSlowITest.assertTrue((duration < 390000L ? 1 : 0) != 0);
    }

    public void testStanfordCoreNLPSpeedMultiThread() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        List<String> kbpFilePaths = IOUtils.linesFromFile(this.WORKING_DIR + "/kbp-2016-files.txt");
        for (String filePath : kbpFilePaths) {
            files.add(new File(filePath));
        }
        StanfordCoreNLP pipeline = this.buildPipeline();
        long startTime = System.currentTimeMillis();
        pipeline.processFiles(files, 4, false, Optional.empty());
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        System.err.println("run time for multi-thread test: " + duration);
        StanfordCoreNLPSpeedSlowITest.assertTrue((duration < 390000L ? 1 : 0) != 0);
    }
}

