/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.StanfordCoreNLPSlowITest;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class ThreadedStanfordCoreNLPSlowITest
extends TestCase {
    private static final int numThreads = 2;
    private static final int numDocs = 10;

    static List<String> convertAnnotations(List<Annotation> annotations, StanfordCoreNLP pipeline) throws IOException {
        ArrayList<String> converted = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            StringWriter out2 = new StringWriter();
            pipeline.xmlPrint(annotation, out2);
            converted.add(out2.toString());
        }
        return converted;
    }

    static List<String> getAnnotations(List<File> files, StanfordCoreNLP pipeline) throws IOException {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (File file : files) {
            String text = IOUtils.slurpFile(file);
            Annotation annotation = pipeline.process(text);
            annotations.add(annotation);
            System.out.println("Processed " + annotations.size());
        }
        return ThreadedStanfordCoreNLPSlowITest.convertAnnotations(annotations, pipeline);
    }

    public void testTwoThreads() throws Exception {
        int i;
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("maxAdditionalKnownLCWords", "0"));
        List<File> files = StanfordCoreNLPSlowITest.getFileList();
        files = files.subList(0, 10);
        List<String> baseline = ThreadedStanfordCoreNLPSlowITest.getAnnotations(files, pipeline);
        CoreNLPThread[] threads = new CoreNLPThread[2];
        for (i = 0; i < 2; ++i) {
            threads[i] = new CoreNLPThread(files, pipeline);
            threads[i].start();
        }
        for (i = 0; i < 2; ++i) {
            threads[i].join();
            ThreadedStanfordCoreNLPSlowITest.assertEquals((String)("Thread " + i + " did not produce " + baseline.size() + " results"), (int)baseline.size(), (int)threads[i].annotations.size());
        }
        for (i = 0; i < baseline.size(); ++i) {
            for (int j = 0; j < 2; ++j) {
                ThreadedStanfordCoreNLPSlowITest.assertEquals((String)("Annotating document " + i + ": thread " + j + " produced annotation:\n" + threads[j].annotations.get(i) + "versus the baseline:\n" + baseline.get(i)), (String)baseline.get(i), (String)threads[j].annotations.get(i));
            }
        }
    }

    static class CoreNLPThread
    extends Thread {
        List<String> annotations;
        private final List<File> files;
        private final StanfordCoreNLP pipeline;

        CoreNLPThread(List<File> files, StanfordCoreNLP pipeline) {
            this.files = files;
            this.pipeline = pipeline;
        }

        @Override
        public void run() {
            try {
                this.annotations = ThreadedStanfordCoreNLPSlowITest.getAnnotations(this.files, this.pipeline);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

