/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.tagger.maxent.DataWordTag;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.HistoryTable;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.ReadDataTagged;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;
import edu.stanford.nlp.tagger.maxent.TaggerFeatures;
import edu.stanford.nlp.tagger.maxent.TemplateHash;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TaggerExperiments
extends Experiments {
    private static final Redwood.RedwoodChannels log = Redwood.channels(TaggerExperiments.class);
    private static final boolean DEBUG = true;
    private static final String zeroSt = "0";
    private final TaggerFeatures feats;
    private final Set<FeatureKey> sTemplates = Generics.newHashSet();
    private final HistoryTable tHistories = new HistoryTable();
    private final int numFeatsGeneral;
    private final int numFeatsAll;
    private final MaxentTagger maxentTagger;
    private final TemplateHash tFeature;
    private byte[][] fnumArr;

    TaggerExperiments(MaxentTagger maxentTagger) {
        this.maxentTagger = maxentTagger;
        this.tFeature = new TemplateHash(maxentTagger);
        this.numFeatsGeneral = maxentTagger.extractors.size();
        this.numFeatsAll = this.numFeatsGeneral + maxentTagger.extractorsRare.size();
        this.feats = new TaggerFeatures(this);
    }

    protected TaggerExperiments(TaggerConfig config, MaxentTagger maxentTagger) throws IOException {
        this(maxentTagger);
        log.info("TaggerExperiments: adding word/tags");
        PairsHolder pairs = new PairsHolder();
        ReadDataTagged c = new ReadDataTagged(config, maxentTagger, pairs);
        this.vArray = new int[c.getSize()][2];
        this.initTemplatesNew();
        log.info("Featurizing tagged data tokens...");
        int size = c.getSize();
        for (int i = 0; i < size; ++i) {
            DataWordTag d = c.get(i);
            String yS = d.getY();
            History h = d.getHistory();
            int indX = this.tHistories.add(h);
            int indY = d.getYInd();
            this.addTemplatesNew(h, yS);
            this.addRareTemplatesNew(h, yS);
            this.vArray[i][0] = indX;
            this.vArray[i][1] = indY;
        }
        log.info("Featurized " + c.getSize() + " data tokens [done].");
        c.release();
        this.ptilde();
        maxentTagger.xSize = this.xSize;
        maxentTagger.ySize = this.ySize;
        log.info("xSize [num Phi templates] = " + this.xSize + "; ySize [num classes] = " + this.ySize);
        this.hashHistories();
        if (!maxentTagger.occurringTagsOnly && !maxentTagger.possibleTagsOnly) {
            this.tHistories.release();
            pairs.clear();
        }
        this.getFeaturesNew();
    }

    public TaggerFeatures getTaggerFeatures() {
        return this.feats;
    }

    protected boolean add(FeatureKey s) {
        if (this.sTemplates.contains(s)) {
            return false;
        }
        this.sTemplates.add(s);
        return true;
    }

    byte[][] getFnumArr() {
        return this.fnumArr;
    }

    private void getFeaturesNew() {
        try {
            int y;
            log.info("TaggerExperiments.getFeaturesNew: initializing fnumArr.");
            this.fnumArr = new byte[this.xSize][this.ySize];
            File hFile = File.createTempFile("temp", ".x", new File("./"));
            RandomAccessFile hF = new RandomAccessFile(hFile, "rw");
            log.info("  length of sTemplates keys: " + this.sTemplates.size());
            log.info("getFeaturesNew adding features ...");
            int current = 0;
            int numFeats = 0;
            boolean VERBOSE = false;
            for (FeatureKey fK : this.sTemplates) {
                Map<String, int[]> fValueAssociations;
                int[] fTagAssociations;
                int xValue2;
                int numF = fK.num;
                Pair<Integer, String> wT = new Pair<Integer, String>(numF, fK.val);
                int[] xValues = this.tFeature.getXValues(wT);
                if (xValues == null) {
                    log.info("  xValues is null: " + fK);
                    continue;
                }
                int numEvidence = 0;
                y = this.maxentTagger.tags.getIndex(fK.tag);
                for (int xValue2 : xValues) {
                    String word;
                    if (this.maxentTagger.occurringTagsOnly && this.maxentTagger.dict.getCount(word = ExtractorFrames.cWord.extract(this.tHistories.getHistory(xValue2)), fK.tag) == 0) continue;
                    if (this.maxentTagger.possibleTagsOnly) {
                        word = ExtractorFrames.cWord.extract(this.tHistories.getHistory(xValue2));
                        String[] tags = this.maxentTagger.dict.getTags(word);
                        Set<String> s = Generics.newHashSet(Arrays.asList(this.maxentTagger.tags.deterministicallyExpandTags(tags)));
                        System.err.printf("possible tags for %s: %s\n", word, Arrays.toString(s.toArray()));
                        if (!s.contains(fK.tag)) continue;
                    }
                    numEvidence += this.px[xValue2];
                }
                if (!this.populated(numF, numEvidence)) continue;
                int[] positions = this.tFeature.getPositions(fK);
                if (this.maxentTagger.occurringTagsOnly || this.maxentTagger.possibleTagsOnly) {
                    positions = null;
                }
                if (positions == null) {
                    int numElements = 0;
                    int[] nArray = xValues;
                    xValue2 = nArray.length;
                    for (int word = 0; word < xValue2; ++word) {
                        String[] tags;
                        Set<String> s;
                        String word2;
                        int x = nArray[word];
                        if (this.maxentTagger.occurringTagsOnly && this.maxentTagger.dict.getCount(word2 = ExtractorFrames.cWord.extract(this.tHistories.getHistory(x)), fK.tag) == 0 || this.maxentTagger.possibleTagsOnly && !(s = Generics.newHashSet(Arrays.asList(this.maxentTagger.tags.deterministicallyExpandTags(tags = this.maxentTagger.dict.getTags(word2 = ExtractorFrames.cWord.extract(this.tHistories.getHistory(x))))))).contains(fK.tag)) continue;
                        ++numElements;
                        hF.writeInt(x);
                        byte[] byArray = this.fnumArr[x];
                        int n = y;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    TaggerFeature tF = new TaggerFeature(current, current + numElements - 1, fK, this.maxentTagger.getTagIndex(fK.tag), this);
                    this.tFeature.addPositions(current, current + numElements - 1, fK);
                    current += numElements;
                    this.feats.add(tF);
                } else {
                    int[] numElements = xValues;
                    int tF = numElements.length;
                    for (xValue2 = 0; xValue2 < tF; ++xValue2) {
                        int x = numElements[xValue2];
                        byte[] byArray = this.fnumArr[x];
                        int n = y;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    TaggerFeature tF2 = new TaggerFeature(positions[0], positions[1], fK, this.maxentTagger.getTagIndex(fK.tag), this);
                    this.feats.add(tF2);
                }
                if (this.maxentTagger.fAssociations.size() <= fK.num) {
                    for (int i = this.maxentTagger.fAssociations.size(); i <= fK.num; ++i) {
                        this.maxentTagger.fAssociations.add(Generics.newHashMap());
                    }
                }
                if ((fTagAssociations = (fValueAssociations = this.maxentTagger.fAssociations.get(fK.num)).get(fK.val)) == null) {
                    fTagAssociations = new int[this.ySize];
                    for (int i = 0; i < this.ySize; ++i) {
                        fTagAssociations[i] = -1;
                    }
                    fValueAssociations.put(fK.val, fTagAssociations);
                }
                fTagAssociations[this.maxentTagger.tags.getIndex((String)fK.tag)] = numFeats++;
            }
            this.tFeature.release();
            this.feats.xIndexed = new int[current];
            hF.seek(0L);
            for (int current1 = 0; current1 < current; ++current1) {
                this.feats.xIndexed[current1] = hF.readInt();
            }
            log.info("  total feats: " + this.sTemplates.size() + ", populated: " + numFeats);
            hF.close();
            hFile.delete();
            byte max = 0;
            int maxGt = 0;
            int numZeros = 0;
            for (int x = 0; x < this.xSize; ++x) {
                int numGt = 0;
                for (y = 0; y < this.ySize; ++y) {
                    if (this.fnumArr[x][y] > 0) {
                        ++numGt;
                        if (max >= this.fnumArr[x][y]) continue;
                        max = this.fnumArr[x][y];
                        continue;
                    }
                    ++numZeros;
                }
                if (maxGt >= numGt) continue;
                maxGt = numGt;
            }
            log.info("  Max features per x,y pair: " + max);
            log.info("  Max non-zero y values for an x: " + maxGt);
            log.info("  Number of non-zero feature x,y pairs: " + (this.xSize * this.ySize - numZeros));
            log.info("  Number of zero feature x,y pairs: " + numZeros);
            log.info("end getFeaturesNew.");
        }
        catch (Exception e) {
            throw new RuntimeIOException(e);
        }
    }

    private void hashHistories() {
        int i;
        int fSize;
        History h;
        int x;
        int fAll = this.maxentTagger.extractors.size() + this.maxentTagger.extractorsRare.size();
        int fGeneral = this.maxentTagger.extractors.size();
        log.info("Hashing histories ...");
        for (x = 0; x < this.xSize; ++x) {
            h = this.tHistories.getHistory(x);
            fSize = this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h)) ? fAll : fGeneral;
            for (i = 0; i < fSize; ++i) {
                this.tFeature.addPrev(i, h);
            }
        }
        log.info("Hashed " + this.xSize + " histories.");
        log.info("Hashing populated histories ...");
        for (x = 0; x < this.xSize; ++x) {
            h = this.tHistories.getHistory(x);
            fSize = this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h)) ? fAll : fGeneral;
            for (i = 0; i < fSize; ++i) {
                this.tFeature.add(i, h, x);
            }
        }
        log.info("Hashed populated histories.");
    }

    protected boolean populated(int fNo, int size) {
        return TaggerExperiments.isPopulated(fNo, size, this.maxentTagger);
    }

    protected static boolean isPopulated(int fNo, int size, MaxentTagger maxentTagger) {
        if (fNo == 0) {
            return size > maxentTagger.curWordMinFeatureThresh;
        }
        if (fNo < maxentTagger.extractors.size()) {
            return size > maxentTagger.minFeatureThresh;
        }
        return size > maxentTagger.rareWordMinFeatureThresh;
    }

    private void initTemplatesNew() {
        this.maxentTagger.dict.setAmbClasses(this.maxentTagger.ambClasses, this.maxentTagger.veryCommonWordThresh, this.maxentTagger.tags);
    }

    private void addTemplatesNew(History h, String tag) {
        for (int i = 0; i < this.numFeatsGeneral; ++i) {
            String s = this.maxentTagger.extractors.extract(i, h);
            if (s.equals(zeroSt)) continue;
            Objects.requireNonNull(this.maxentTagger);
            FeatureKey key = new FeatureKey(i, s, tag);
            if (!this.maxentTagger.extractors.get(i).precondition(tag)) continue;
            this.add(key);
        }
    }

    private void addRareTemplatesNew(History h, String tag) {
        int start;
        if (!this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h))) {
            return;
        }
        for (int i = start = this.numFeatsGeneral; i < this.numFeatsAll; ++i) {
            String s = this.maxentTagger.extractorsRare.extract(i - start, h);
            if (s.equals(zeroSt)) continue;
            Objects.requireNonNull(this.maxentTagger);
            FeatureKey key = new FeatureKey(i, s, tag);
            if (!this.maxentTagger.extractorsRare.get(i - start).precondition(tag)) continue;
            this.add(key);
        }
    }

    HistoryTable getHistoryTable() {
        return this.tHistories;
    }
}

