/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureConversionUtils;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import junit.framework.TestCase;

public class EnglishGrammaticalStructureTest
extends TestCase {
    public void testBasicRelations() {
        String[] testTrees = new String[]{"(ROOT (S (NP (NNP Reagan)) (VP (VBZ has) (VP (VBN died))) (. .)))", "(ROOT (S (NP (NNP Kennedy)) (VP (VBZ has) (VP (VBN been) (VP (VBN killed)))) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (NP (DT an) (JJ honest) (NN man))) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (ADJP (JJ big) (CC and) (JJ honest))) (. .)))", "(ROOT (S (NP (NNP Clinton)) (VP (VBD defeated) (NP (NNP Dole))) (. .)))", "(ROOT (S (SBAR (WHNP (WP What)) (S (NP (PRP she)) (VP (VBD said)))) (VP (VBZ is) (ADJP (JJ untrue))) (. .)))", "(ROOT (S (NP (NNP Dole)) (VP (VBD was) (VP (VBN defeated) (PP (IN by) (NP (NNP Clinton))))) (. .)))", "(ROOT (S (SBAR (IN That) (S (NP (PRP she)) (VP (VBD lied)))) (VP (VBD was) (VP (VBN suspected) (PP (IN by) (NP (NN everyone))))) (. .)))", "(ROOT (S (NP (PRP She)) (VP (VBD gave) (NP (PRP me)) (NP (DT a) (NN raise))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD sat) (PP (IN on) (NP (DT the) (NN chair)))) (. .)))", "(ROOT (S (NP (PRP We)) (VP (VBP have) (NP (NP (DT no) (JJ useful) (NN information)) (PP (IN on) (SBAR (IN whether) (S (NP (NNS users)) (VP (VBP are) (PP (IN at) (NP (NN risk))))))))) (. .)))", "(ROOT (S (NP (PRP They)) (VP (VBD heard) (PP (IN about) (NP (NN asbestos))) (S (VP (VBG having) (NP (JJ questionable) (NNS properties))))) (. .)))", "(ROOT (S (NP (PRP He)) (VP (VBZ says) (SBAR (IN that) (S (NP (PRP you)) (VP (VBP like) (S (VP (TO to) (VP (VB swim)))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ certain) (SBAR (IN that) (S (NP (PRP he)) (VP (VBD did) (NP (PRP it))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ ready) (S (VP (TO to) (VP (VB leave)))))) (. .)))", "(ROOT (S (NP (NNP U.S.) (NNS forces)) (VP (VBP have) (VP (VBN been) (VP (VBN engaged) (PP (IN in) (NP (JJ intense) (NN fighting))) (SBAR (IN after) (S (NP (NNS insurgents)) (VP (VBD launched) (NP (JJ simultaneous) (NNS attacks)))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP who)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NP (NN wife))) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NN wife)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN statue)) (PP (IN in) (NP (DT the) (NN corner))))) (. .)))", "(ROOT (S (NP (PRP She)) (VP (VBZ looks) (ADJP (RB very) (JJ beautiful))) (. .)))", "(ROOT (S (NP (DT The) (NN accident)) (VP (VBD happened) (SBAR (IN as) (S (NP (DT the) (NN night)) (VP (VBD was) (VP (VBG falling)))))) (. .)))", "(ROOT (S (SBAR (IN If) (S (NP (PRP you)) (VP (VBP know) (SBAR (WHNP (WP who)) (S (VP (VBD did) (NP (PRP it)))))))) (, ,) (NP (PRP you)) (VP (MD should) (VP (VB tell) (NP (DT the) (NN teacher)))) (. .)))", "(ROOT (S (NP-TMP (JJ Last) (NN night)) (, ,) (NP (PRP I)) (VP (VBP swam) (PP (IN in) (NP (DT the) (NN pool)))) (. .)))", "(ROOT (S (NP (PRP He)) (VP (VBD talked) (PP (TO to) (NP (DT the) (NN president))) (SBAR (IN in) (NN order) (S (VP (TO to) (VP (VB secure) (NP (DT the) (NN account))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN book)) (SBAR (WHNP (WDT which)) (S (NP (PRP you)) (VP (VBD bought)))))) (. .)))", "(ROOT (S (NP (NNP Sam)) (VP (VBZ eats) (NP (CD 3) (NN sheep))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD lost) (NP (QP ($ $) (CD 3.2) (CD billion)))) (. .)))", "(ROOT (S (NP (QP (RB About) (CD 200)) (NNS people)) (VP (VBD came) (PP (TO to) (NP (DT the) (NN party)))) (. .)))", "(ROOT (S (NP (NP (NNP Sam)) (, ,) (NP (PRP$ my) (NN brother)) (, ,)) (VP (VBZ eats) (NP (JJ red) (NN meat))) (. .)))", "(ROOT (NP (NP (DT The) (JJ Australian) (NNP Broadcasting) (NNP Corporation)) (PRN (-LRB- -LRB-) (NP (NNP ABC)) (-RRB- -RRB-)) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBD picked) (NP (NP (NNP Fred)) (PP (IN for) (NP (NP (DT the) (NN team)) (VP (VBG demonstrating) (NP (PRP$ his) (NN incompetence))))))) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (RB not) (NP (DT a) (NN scientist))) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBZ does) (RB n't) (VP (VB drive))) (. .)))", "(ROOT (S (NP (DT The) (NN director)) (VP (VBZ is) (ADJP (NP (CD 65) (NNS years)) (JJ old))) (. .)))", "(ROOT (S (NP (DT The) (NN man)) (VP (VBZ is) (ADVP (RB here))) (. .)))", "(ROOT (SBARQ (WHPP (IN In) (WHNP (WDT which) (NN city))) (SQ (VBP do) (NP (PRP you)) (VP (VB live))) (. ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBD did) (NP (NNP Charles) (NNP Babbage)) (VP (VB invent))) (? ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT the) (NN esophagus)) (VP (VBN used) (PP (IN for)))) (? ?)))", "(ROOT (S (NP (PDT All) (DT the) (NNS boys)) (VP (VBP are) (ADVP (RB here))) (. .)))", "(ROOT (S (NP (CC Both) (NP (DT the) (NNS boys)) (CC and) (NP (DT the) (NNS girls))) (VP (VBP are) (ADVP (RB here))) (. .)))", "(ROOT (S (NP (PRP They)) (VP (VBD shut) (PRT (RP down)) (NP (DT the) (NN station))) (. .)))", "(ROOT (S (NP (NP (NNS Truffles)) (VP (VBN picked) (PP (IN during) (NP (DT the) (NN spring))))) (VP (VBP are) (ADJP (JJ tasty))) (. .)))", "(ROOT (S  (NP-SBJ-38 (DT Neither) (NP (PRP they) ) (CC nor) (NP (NNP Mr.) (NNP McAlpine) )) (VP (MD could) (VP (VB be) (VP (VBN reached) (NP (-NONE- *-38) ) (PP-PRP (IN for) (NP (NN comment) ))))) (. .) ))", "(ROOT (S (NP (NNP Xml) (NN field)) (VP (MD should) (VP (VB include) (NP (PDT both) (NP (DT the) (NN entity) (NN id)) (CC and) (NP (DT the) (NN entity) (NN name))) (SBAR (IN since) (S (NP (DT the) (NN entity) (NNS names)) (VP (VBP are) (RB not) (ADJP (JJ unique))))))) (. .)))", "(ROOT (S (S (NP (DT The) (NN government)) (VP (VBZ counts) (NP (NN money)) (SBAR (IN as) (S (NP (PRP it)) (VP (VBZ is) (VP (VBN spent))))))) (: ;) (S (NP (NNP Dodge)) (VP (VBZ counts) (NP (NNS contracts)) (SBAR (WHADVP (WRB when)) (S (NP (PRP they)) (VP (VBP are) (VP (VBN awarded))))))) (. .)))", "( (S (CC But) (NP (PRP she)) (VP (VBD did) (RB n't) (VP (VB deserve) (S (VP (TO to) (VP (VB have) (S (NP (PRP$ her) (NN head)) (VP (VBN chopped) (PRT (RP off))))))))) (. .)))", "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NNS dogs)) (CONJP (RB rather) (IN than)) (NP (NNS cats)))) (. .)))", "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NN brandy)) (CONJP (RB not) (TO to) (VB mention)) (NP (NN cognac)))) (. .)))", "( (S (NP (PRP I)) (VP (VBP like) (NP (CONJP (RB not) (RB only)) (NP (NNS cats)) (CONJP (CC but) (RB also)) (NP (NN dogs)))) (. .)))", "( (S (NP (PRP He)) (VP (VBZ knows) (NP (DT the) (NML (JJ mechanical) (NN engineering)) (NN industry))) (. .)))", "( (SBARQ (WHNP (WP What) (NN weapon)) (SQ (VBZ is) (NP (DT the) (JJ mythological) (NN character) (NN Apollo)) (ADJP (RBS most) (JJ proficient) (PP (IN with)))) (. ?)))", "( (SINV (CC Nor) (VBP are) (NP (PRP you)) (ADJP (JJ free) (S (VP (TO to) (VP (VB reprint) (NP (JJ such) (NN material))))))) )", "(ROOT (SBARQ (WHNP (WHADJP (WRB How) (JJ many)) (NP (NNP James) (NNP Bond) (NNS novels))) (SQ (VBP are) (NP (EX there))) (. ?)))", "( (S (NP (NP (NNS Investments)) (PP (IN in) (NP (NNP South) (NNP Africa)))) (VP (MD will) (VP (VB be) (VP (VBN excluded)))) (. .)))", "( (SINV (ADVP (RB Also)) (VP (VBN excluded)) (VP (MD will) (VP (VB be))) (NP (NP (NNS investments)) (PP (IN in) (NP (NNP South) (NNP Africa)))) (. .)))", "( (SINV (VP (VBG Defending) (NP (PRP$ their) (NNS ramparts))) (VP (VBP are)) (NP (NP (NNP Wall) (NNP Street) (POS 's)) (NNP Old) (NNP Guard)) (. .)))", "( (S (NP-SBJ (JJ Institutional) (NNS investors)) (ADVP (RB mostly)) (VP (VBD remained) (PP-LOC-PRD (IN on) (NP (DT the) (NNS sidelines))) (NP-TMP (NNP Tuesday))) (. .)))", "( (SQ (VBZ Is) (NP-SBJ (DT this)) (NP-PRD (NP (DT the) (NN future)) (PP (IN of) (NP (NN chamber) (NN music)))) (. ?)))", "( (SQ (VBZ Is) (NP-SBJ (DT the) (NN trouble)) (ADVP-PRD (RP over)) (. ?)))", "( (SBARQ (SBAR (IN Although) (S (NP (NNP Sue)) (VP (VBP is) (ADJP (JJ smart))))) (, ,) (WHNP (WP who)) (SQ (MD will) (VP (VB win))) (. ?)))", "(NP (NP (NNP Xerox))(, ,) (SBAR (WHNP (WHNP (WP$ whose) (JJ chief) (JJ executive) (NN officer))(, ,) (NP (NNP James) (NNP Gatward))(, ,)) (S (NP-SBJ (-NONE- *T*-1)) (VP (VBZ has) (VP (VBN resigned))))))", "(ROOT (S (NP (PRP He)) (VP (VBZ gets) (NP (PRP me)) (ADVP-TMP (DT every) (NN time))) (. .)))", "( (S (NP-SBJ (CC Both) (NP (NNP Mr.) (NNP Parenteau)) (CC and) (NP (NNP Ms.) (NNP Doyon))) (, ,) (ADVP (RB however)) (, ,) (VP (VBD were) (VP (VBG bleeding) (ADVP (RB badly)))) (. .)))", "(NP-SBJ-1 (ADJP (ADJP (VBN Rusted) (RP out)) (CC and) (ADJP (JJ unsafe))) (NNS cars))", "( (S (NP-SBJ (PRP u)) (VP (VBP r) (VP (VBG holding) (NP (PRP it)) (ADVP (RB too) (RB tight))))))", "( (S (NP-SBJ (PRP You)) (VP (MD should) (VP (GW e) (VB mail) (NP (PRP her)) (ADVP-TMP (RB sometimes)))) (. .)))", "( (S (NP-SBJ (NN Interest)) (VP (VBZ is) (ADJP-PRD (ADJP (NP-ADV (DT a) (JJ great) (NN deal)) (JJR higher)) (SBAR (IN than) (S (NP-SBJ (PRP it)) (VP (VBD was) (ADJP-PRD (-NONE- *?*)) (ADVP-TMP (NP (DT a) (NN year)) (RB ago))))))) (. .)))", "( (S (NP-SBJ (DT The) (NN strike)) (VP (MD may) (VP (VB have) (VP (VBN ended) (SBAR-TMP (ADVP (RB almost)) (IN before) (S (NP-SBJ (PRP it)) (VP (VBD began)))))))))", "( (S (SBAR-ADV (IN Although) (S (VP (VBN set) (PP-LOC (IN in) (NP (NNP Japan)))))) (, ,) (NP-SBJ-2 (NP (DT the) (NN novel) (POS 's)) (NN texture)) (VP (VBZ is) (ADJP (JJ American))) (. .)))", "( (S-IMP (INTJ (UH please)) (NP-SBJ (-NONE- *PRO*)) (VP (VB specify) (NP (WDT which) (NML (NNP royal) (CC or) (NNP carnival)) (NN ship))) (NFP -LRB-:)))", "(NP (DT those) (RRC (ADVP-TMP (RB still)) (PP-LOC (IN under) (NP (NNP GASB) (NNS rules)))))", "(NP (NP (DT the) (NN auction) (NN house)) (RRC (RRC (VP (VBN founded) (NP (-NONE- *)) (PP-LOC (IN in) (NP (NNP London))) (NP-TMP (CD 1744)))) (CC and) (RRC (ADVP-TMP (RB now)) (PP (IN under) (NP (NP (DT the) (NN umbrella)) (PP (IN of) (NP (NP (NNP Sotheby) (POS 's)) (NNPS Holdings) (NNP Inc.))))))))", "(S (NP-SBJ (NNS morcillas)) (VP (VBP are) (ADVP (RB basically)) (ADJP-PRD (JJ impossible) (SBAR (WHNP-1 (-NONE- *0*)) (S (NP-SBJ (-NONE- *PRO*)) (VP (TO to) (VP (VB find) (NP-1 (-NONE- *T*)) (PP-LOC (IN in) (NP (NNP California))))))))))", "( (S (S (NP-SBJ (-NONE- *)) (VP (VBP Do) (RB n't) (VP (VB wait)))) (: --) (S (NP-SBJ (-NONE- *)) (VP (VBP act) (ADVP-TMP (RB now)))) (. !)))", "( (S (NP-SBJ (DT The) (NNPS Parks) (NNP Council)) (VP (VBD wrote) (NP (DT the) (NNP BPCA)) (SBAR (IN that) (S (NP-SBJ (DT this) (ADJP (`` ``) (RB too) (`` `) (JJ private) ('' ') (: ...) (JJ exclusive) (, ,) ('' '') (JJ complex) (CC and) (JJ expensive)) (`` ``) (VBN enclosed) (NN garden)) (: ...) (VP (VBZ belongs) (PP-LOC-CLR (IN in) (NP (NP (RB almost) (DT any) (NN location)) (CC but) (NP (DT the) (NN waterfront)))))))) (. .) ('' '')))", "( (S (`` ``) (CC And) (NP-SBJ (PRP you)) (VP (MD ca) (RB n't) (VP (VB have) (S (NP-SBJ (NP (NNS taxpayers)) (VP (VBG coming) (PP-DIR (IN into) (NP (DT an) (NN audit))))) (VP (VBG hearing) (NP (`` `) (UH oohs) (: ') (CC and) (`` `) (UH ahs)))))) (. .) ('' ') ('' '')))", "( (S (NP-SBJ-1 (VBN Freed) (JJ black) (NNS nationalists)) (VP (VP (VBD resumed) (NP (JJ political) (NN activity)) (PP-LOC (IN in) (NP (NNP South) (NNP Africa)))) (CC and) (VP (VBD vowed) (S (NP-SBJ (-NONE- *-1)) (VP (TO to) (VP (VB fight) (PP-CLR (IN against) (NP (NN apartheid))))))) (, ,) (S-ADV (NP-SBJ (-NONE- *)) (VP (VBG raising) (NP (NP (NNS fears)) (PP (IN of) (NP (DT a) (JJ possible) (JJ white) (NN backlash))))))) (. .)))", "( (S (S-NOM-SBJ (NP-SBJ-1 (-NONE- *)) (VP (VBG Being) (VP (VBN held) (S (NP-SBJ (-NONE- *-1)) (PP-PRD (ADVP (RB well)) (IN below) (NP (NN capacity))))))) (VP (VP (ADVP-MNR (RB greatly)) (VBZ irritates) (NP (PRP them))) (, ,) (CC and) (VP (VBZ has) (VP (VBN led) (PP-CLR (TO to) (NP (JJ widespread) (NN cheating)))))) (. .)))", "( (S (NP-SBJ (PRP They)) (VP (VBD acquired) (NP (NP (NNS stakes)) (PP (IN in) (NP (NP (VBG bottling) (NNS companies)) (UCP-LOC (PP (IN in) (NP (DT the) (NNP U.S.))) (CC and) (ADVP (RB overseas))))))) (. .)))"};
        String[] testAnswers = new String[]{"nsubj(died-3, Reagan-1)\naux(died-3, has-2)\nroot(ROOT-0, died-3)\n", "nsubjpass(killed-4, Kennedy-1)\naux(killed-4, has-2)\nauxpass(killed-4, been-3)\nroot(ROOT-0, killed-4)\n", "nsubj(man-5, Bill-1)\ncop(man-5, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nroot(ROOT-0, man-5)\n", "nsubj(big-3, Bill-1)\ncop(big-3, is-2)\nroot(ROOT-0, big-3)\ncc(big-3, and-4)\nconj(big-3, honest-5)\n", "nsubj(defeated-2, Clinton-1)\nroot(ROOT-0, defeated-2)\ndobj(defeated-2, Dole-3)\n", "dobj(said-3, What-1)\nnsubj(said-3, she-2)\ncsubj(untrue-5, said-3)\ncop(untrue-5, is-4)\nroot(ROOT-0, untrue-5)\n", "nsubjpass(defeated-3, Dole-1)\nauxpass(defeated-3, was-2)\nroot(ROOT-0, defeated-3)\nprep(defeated-3, by-4)\npobj(by-4, Clinton-5)\n", "mark(lied-3, That-1)\nnsubj(lied-3, she-2)\ncsubjpass(suspected-5, lied-3)\nauxpass(suspected-5, was-4)\nroot(ROOT-0, suspected-5)\nprep(suspected-5, by-6)\npobj(by-6, everyone-7)\n", "nsubj(gave-2, She-1)\nroot(ROOT-0, gave-2)\niobj(gave-2, me-3)\ndet(raise-5, a-4)\ndobj(gave-2, raise-5)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\naux(swim-4, to-3)\nxcomp(like-2, swim-4)\n", "nsubj(sat-2, I-1)\nroot(ROOT-0, sat-2)\nprep(sat-2, on-3)\ndet(chair-5, the-4)\npobj(on-3, chair-5)\n", "nsubj(have-2, We-1)\nroot(ROOT-0, have-2)\nneg(information-5, no-3)\namod(information-5, useful-4)\ndobj(have-2, information-5)\nprep(information-5, on-6)\nmark(are-9, whether-7)\nnsubj(are-9, users-8)\npcomp(on-6, are-9)\nprep(are-9, at-10)\npobj(at-10, risk-11)\n", "nsubj(heard-2, They-1)\nroot(ROOT-0, heard-2)\nprep(heard-2, about-3)\npobj(about-3, asbestos-4)\nxcomp(heard-2, having-5)\namod(properties-7, questionable-6)\ndobj(having-5, properties-7)\n", "nsubj(says-2, He-1)\nroot(ROOT-0, says-2)\nmark(like-5, that-3)\nnsubj(like-5, you-4)\nccomp(says-2, like-5)\naux(swim-7, to-6)\nxcomp(like-5, swim-7)\n", "nsubj(certain-3, I-1)\ncop(certain-3, am-2)\nroot(ROOT-0, certain-3)\nmark(did-6, that-4)\nnsubj(did-6, he-5)\nccomp(certain-3, did-6)\ndobj(did-6, it-7)\n", "nsubj(ready-3, I-1)\ncop(ready-3, am-2)\nroot(ROOT-0, ready-3)\naux(leave-5, to-4)\nxcomp(ready-3, leave-5)\n", "nn(forces-2, U.S.-1)\nnsubjpass(engaged-5, forces-2)\naux(engaged-5, have-3)\nauxpass(engaged-5, been-4)\nroot(ROOT-0, engaged-5)\nprep(engaged-5, in-6)\namod(fighting-8, intense-7)\npobj(in-6, fighting-8)\nmark(launched-11, after-9)\nnsubj(launched-11, insurgents-10)\nadvcl(engaged-5, launched-11)\namod(attacks-13, simultaneous-12)\ndobj(launched-11, attacks-13)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\ndobj(love-7, who-5)\nnsubj(love-7, you-6)\nrcmod(man-4, love-7)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nposs(wife-6, whose-5)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nrcmod(man-4, love-8)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nposs(wife-6, whose-5)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nrcmod(man-4, love-8)\n", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(statue-4, a-3)\nnsubj(is-2, statue-4)\nprep(statue-4, in-5)\ndet(corner-7, the-6)\npobj(in-5, corner-7)\n", "nsubj(looks-2, She-1)\nroot(ROOT-0, looks-2)\nadvmod(beautiful-4, very-3)\nacomp(looks-2, beautiful-4)\n", "det(accident-2, The-1)\nnsubj(happened-3, accident-2)\nroot(ROOT-0, happened-3)\nmark(falling-8, as-4)\ndet(night-6, the-5)\nnsubj(falling-8, night-6)\naux(falling-8, was-7)\nadvcl(happened-3, falling-8)\n", "mark(know-3, If-1)\nnsubj(know-3, you-2)\nadvcl(tell-10, know-3)\nnsubj(did-5, who-4)\nccomp(know-3, did-5)\ndobj(did-5, it-6)\nnsubj(tell-10, you-8)\naux(tell-10, should-9)\nroot(ROOT-0, tell-10)\ndet(teacher-12, the-11)\ndobj(tell-10, teacher-12)\n", "amod(night-2, Last-1)\ntmod(swam-5, night-2)\nnsubj(swam-5, I-4)\nroot(ROOT-0, swam-5)\nprep(swam-5, in-6)\ndet(pool-8, the-7)\npobj(in-6, pool-8)\n", "nsubj(talked-2, He-1)\nroot(ROOT-0, talked-2)\nprep(talked-2, to-3)\ndet(president-5, the-4)\npobj(to-3, president-5)\nmark(secure-9, in-6)\ndep(secure-9, order-7)\naux(secure-9, to-8)\nadvcl(talked-2, secure-9)\ndet(account-11, the-10)\ndobj(secure-9, account-11)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(book-4, the-3)\ndobj(saw-2, book-4)\ndobj(bought-7, which-5)\nnsubj(bought-7, you-6)\nrcmod(book-4, bought-7)\n", "nsubj(eats-2, Sam-1)\nroot(ROOT-0, eats-2)\nnum(sheep-4, 3-3)\ndobj(eats-2, sheep-4)\n", "nsubj(lost-2, I-1)\nroot(ROOT-0, lost-2)\ndobj(lost-2, $-3)\nnumber(billion-5, 3.2-4)\nnum($-3, billion-5)\n", "quantmod(200-2, About-1)\nnum(people-3, 200-2)\nnsubj(came-4, people-3)\nroot(ROOT-0, came-4)\nprep(came-4, to-5)\ndet(party-7, the-6)\npobj(to-5, party-7)\n", "nsubj(eats-6, Sam-1)\nposs(brother-4, my-3)\nappos(Sam-1, brother-4)\nroot(ROOT-0, eats-6)\namod(meat-8, red-7)\ndobj(eats-6, meat-8)\n", "det(Corporation-4, The-1)\namod(Corporation-4, Australian-2)\nnn(Corporation-4, Broadcasting-3)\nroot(ROOT-0, Corporation-4)\nappos(Corporation-4, ABC-6)\n", "nsubj(picked-2, Bill-1)\nroot(ROOT-0, picked-2)\ndobj(picked-2, Fred-3)\nprep(Fred-3, for-4)\ndet(team-6, the-5)\npobj(for-4, team-6)\nvmod(team-6, demonstrating-7)\nposs(incompetence-9, his-8)\ndobj(demonstrating-7, incompetence-9)\n", "nsubj(scientist-5, Bill-1)\ncop(scientist-5, is-2)\nneg(scientist-5, not-3)\ndet(scientist-5, a-4)\nroot(ROOT-0, scientist-5)\n", "nsubj(drive-4, Bill-1)\naux(drive-4, does-2)\nneg(drive-4, n't-3)\nroot(ROOT-0, drive-4)\n", "det(director-2, The-1)\nnsubj(old-6, director-2)\ncop(old-6, is-3)\nnum(years-5, 65-4)\nnpadvmod(old-6, years-5)\nroot(ROOT-0, old-6)\n", "det(man-2, The-1)\nnsubj(is-3, man-2)\nroot(ROOT-0, is-3)\nadvmod(is-3, here-4)\n", "prep(live-6, In-1)\ndet(city-3, which-2)\npobj(In-1, city-3)\naux(live-6, do-4)\nnsubj(live-6, you-5)\nroot(ROOT-0, live-6)\n", "dobj(invent-5, What-1)\naux(invent-5, did-2)\nnn(Babbage-4, Charles-3)\nnsubj(invent-5, Babbage-4)\nroot(ROOT-0, invent-5)\n", "pobj(for-6, What-1)\nauxpass(used-5, is-2)\ndet(esophagus-4, the-3)\nnsubjpass(used-5, esophagus-4)\nroot(ROOT-0, used-5)\nprep(used-5, for-6)\n", "predet(boys-3, All-1)\ndet(boys-3, the-2)\nnsubj(are-4, boys-3)\nroot(ROOT-0, are-4)\nadvmod(are-4, here-5)\n", "preconj(boys-3, Both-1)\ndet(boys-3, the-2)\nnsubj(are-7, boys-3)\ncc(boys-3, and-4)\ndet(girls-6, the-5)\nconj(boys-3, girls-6)\nroot(ROOT-0, are-7)\nadvmod(are-7, here-8)\n", "nsubj(shut-2, They-1)\nroot(ROOT-0, shut-2)\nprt(shut-2, down-3)\ndet(station-5, the-4)\ndobj(shut-2, station-5)\n", "nsubj(tasty-7, Truffles-1)\nvmod(Truffles-1, picked-2)\nprep(picked-2, during-3)\ndet(spring-5, the-4)\npobj(during-3, spring-5)\ncop(tasty-7, are-6)\nroot(ROOT-0, tasty-7)\n", "preconj(they-2, Neither-1)\nnsubjpass(reached-8, they-2)\ncc(they-2, nor-3)\nnn(McAlpine-5, Mr.-4)\nconj(they-2, McAlpine-5)\naux(reached-8, could-6)\nauxpass(reached-8, be-7)\nroot(ROOT-0, reached-8)\nprep(reached-8, for-9)\npobj(for-9, comment-10)\n", "nn(field-2, Xml-1)\nnsubj(include-4, field-2)\naux(include-4, should-3)\nroot(ROOT-0, include-4)\npreconj(id-8, both-5)\ndet(id-8, the-6)\nnn(id-8, entity-7)\ndobj(include-4, id-8)\ncc(id-8, and-9)\ndet(name-12, the-10)\nnn(name-12, entity-11)\nconj(id-8, name-12)\nmark(unique-19, since-13)\ndet(names-16, the-14)\nnn(names-16, entity-15)\nnsubj(unique-19, names-16)\ncop(unique-19, are-17)\nneg(unique-19, not-18)\nadvcl(include-4, unique-19)\n", "det(government-2, The-1)\nnsubj(counts-3, government-2)\nroot(ROOT-0, counts-3)\ndobj(counts-3, money-4)\nmark(spent-8, as-5)\nnsubjpass(spent-8, it-6)\nauxpass(spent-8, is-7)\nadvcl(counts-3, spent-8)\nnsubj(counts-11, Dodge-10)\nparataxis(counts-3, counts-11)\ndobj(counts-11, contracts-12)\nadvmod(awarded-16, when-13)\nnsubjpass(awarded-16, they-14)\nauxpass(awarded-16, are-15)\nadvcl(counts-11, awarded-16)\n", "cc(deserve-5, But-1)\nnsubj(deserve-5, she-2)\naux(deserve-5, did-3)\nneg(deserve-5, n't-4)\nroot(ROOT-0, deserve-5)\naux(have-7, to-6)\nxcomp(deserve-5, have-7)\nposs(head-9, her-8)\nnsubj(chopped-10, head-9)\nccomp(have-7, chopped-10)\nprt(chopped-10, off-11)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, dogs-3)\ncc(dogs-3, rather-4)\nmwe(rather-4, than-5)\nconj(dogs-3, cats-6)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, brandy-3)\nneg(mention-6, not-4)\naux(mention-6, to-5)\ncc(brandy-3, mention-6)\nconj(brandy-3, cognac-7)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\nneg(only-4, not-3)\npreconj(cats-5, only-4)\ndobj(like-2, cats-5)\ncc(also-7, but-6)\ncc(cats-5, also-7)\nconj(cats-5, dogs-8)\n", "nsubj(knows-2, He-1)\nroot(ROOT-0, knows-2)\ndet(industry-6, the-3)\namod(engineering-5, mechanical-4)\nnn(industry-6, engineering-5)\ndobj(knows-2, industry-6)\n", "det(weapon-2, What-1)\npobj(with-10, weapon-2)\ncop(proficient-9, is-3)\ndet(Apollo-7, the-4)\namod(Apollo-7, mythological-5)\nnn(Apollo-7, character-6)\nnsubj(proficient-9, Apollo-7)\nadvmod(proficient-9, most-8)\nroot(ROOT-0, proficient-9)\nprep(proficient-9, with-10)\n", "cc(free-4, Nor-1)\ncop(free-4, are-2)\nnsubj(free-4, you-3)\nroot(ROOT-0, free-4)\naux(reprint-6, to-5)\nxcomp(free-4, reprint-6)\namod(material-8, such-7)\ndobj(reprint-6, material-8)\n", "advmod(many-2, How-1)\namod(novels-5, many-2)\nnn(novels-5, James-3)\nnn(novels-5, Bond-4)\nnsubj(are-6, novels-5)\nroot(ROOT-0, are-6)\nexpl(are-6, there-7)\n", "nsubjpass(excluded-7, Investments-1)\nprep(Investments-1, in-2)\nnn(Africa-4, South-3)\npobj(in-2, Africa-4)\naux(excluded-7, will-5)\nauxpass(excluded-7, be-6)\nroot(ROOT-0, excluded-7)\n", "advmod(excluded-2, Also-1)\nroot(ROOT-0, excluded-2)\naux(be-4, will-3)\nauxpass(excluded-2, be-4)\nnsubjpass(excluded-2, investments-5)\nprep(investments-5, in-6)\nnn(Africa-8, South-7)\npobj(in-6, Africa-8)\n", "root(ROOT-0, Defending-1)\nposs(ramparts-3, their-2)\ndobj(Defending-1, ramparts-3)\naux(Defending-1, are-4)\nnn(Street-6, Wall-5)\nposs(Guard-9, Street-6)\npossessive(Street-6, 's-7)\nnn(Guard-9, Old-8)\nnsubj(Defending-1, Guard-9)\n", "amod(investors-2, Institutional-1)\nnsubj(remained-4, investors-2)\nadvmod(remained-4, mostly-3)\nroot(ROOT-0, remained-4)\nprep(remained-4, on-5)\ndet(sidelines-7, the-6)\npobj(on-5, sidelines-7)\ntmod(remained-4, Tuesday-8)\n", "cop(future-4, Is-1)\nnsubj(future-4, this-2)\ndet(future-4, the-3)\nroot(ROOT-0, future-4)\nprep(future-4, of-5)\nnn(music-7, chamber-6)\npobj(of-5, music-7)\n", "root(ROOT-0, Is-1)\ndet(trouble-3, the-2)\nnsubj(Is-1, trouble-3)\nadvmod(Is-1, over-4)\n", "mark(smart-4, Although-1)\nnsubj(smart-4, Sue-2)\ncop(smart-4, is-3)\nadvcl(win-8, smart-4)\nnsubj(win-8, who-6)\naux(win-8, will-7)\nroot(ROOT-0, win-8)\n", "root(ROOT-0, Xerox-1)\nposs(officer-6, whose-3)\namod(officer-6, chief-4)\namod(officer-6, executive-5)\nnsubj(resigned-12, officer-6)\nnn(Gatward-9, James-8)\nappos(officer-6, Gatward-9)\naux(resigned-12, has-11)\nrcmod(Xerox-1, resigned-12)\n", "nsubj(gets-2, He-1)\nroot(ROOT-0, gets-2)\ndobj(gets-2, me-3)\ndet(time-5, every-4)\nadvmod(gets-2, time-5)\n", "preconj(Parenteau-3, Both-1)\nnn(Parenteau-3, Mr.-2)\nnsubj(bleeding-11, Parenteau-3)\ncc(Parenteau-3, and-4)\nnn(Doyon-6, Ms.-5)\nconj(Parenteau-3, Doyon-6)\nadvmod(bleeding-11, however-8)\naux(bleeding-11, were-10)\nroot(ROOT-0, bleeding-11)\nadvmod(bleeding-11, badly-12)\n", "amod(cars-5, Rusted-1)\nprt(Rusted-1, out-2)\ncc(Rusted-1, and-3)\nconj(Rusted-1, unsafe-4)\nroot(ROOT-0, cars-5)\n", "nsubj(holding-3, u-1)\naux(holding-3, r-2)\nroot(ROOT-0, holding-3)\ndobj(holding-3, it-4)\nadvmod(tight-6, too-5)\nadvmod(holding-3, tight-6)\n", "nsubj(mail-4, You-1)\naux(mail-4, should-2)\ngoeswith(mail-4, e-3)\nroot(ROOT-0, mail-4)\ndobj(mail-4, her-5)\nadvmod(mail-4, sometimes-6)\n", "nsubj(higher-6, Interest-1)\ncop(higher-6, is-2)\ndet(deal-5, a-3)\namod(deal-5, great-4)\nnpadvmod(higher-6, deal-5)\nroot(ROOT-0, higher-6)\nmark(was-9, than-7)\nnsubj(was-9, it-8)\nccomp(higher-6, was-9)\ndet(year-11, a-10)\nnpadvmod(ago-12, year-11)\nadvmod(was-9, ago-12)\n", "det(strike-2, The-1)\nnsubj(ended-5, strike-2)\naux(ended-5, may-3)\naux(ended-5, have-4)\nroot(ROOT-0, ended-5)\nadvmod(began-9, almost-6)\nmark(began-9, before-7)\nnsubj(began-9, it-8)\nadvcl(ended-5, began-9)\n", "mark(set-2, Although-1)\nadvcl(American-11, set-2)\nprep(set-2, in-3)\npobj(in-3, Japan-4)\ndet(novel-7, the-6)\nposs(texture-9, novel-7)\npossessive(novel-7, 's-8)\nnsubj(American-11, texture-9)\ncop(American-11, is-10)\nroot(ROOT-0, American-11)\n", "discourse(specify-2, please-1)\nroot(ROOT-0, specify-2)\ndet(ship-7, which-3)\nnn(ship-7, royal-4)\ncc(royal-4, or-5)\nconj(royal-4, carnival-6)\ndobj(specify-2, ship-7)\ndiscourse(specify-2, -LRB-:-8)\n", "root(ROOT-0, those-1)\nadvmod(under-3, still-2)\nrcmod(those-1, under-3)\nnn(rules-5, GASB-4)\npobj(under-3, rules-5)\n", "det(house-3, the-1)\nnn(house-3, auction-2)\nroot(ROOT-0, house-3)\nrcmod(house-3, founded-4)\nprep(founded-4, in-5)\npobj(in-5, London-6)\ntmod(founded-4, 1744-7)\ncc(founded-4, and-8)\nadvmod(under-10, now-9)\nconj(founded-4, under-10)\ndet(umbrella-12, the-11)\npobj(under-10, umbrella-12)\nprep(umbrella-12, of-13)\nposs(Inc.-17, Sotheby-14)\npossessive(Sotheby-14, 's-15)\nnn(Inc.-17, Holdings-16)\npobj(of-13, Inc.-17)\n", "nsubj(impossible-4, morcillas-1)\ncop(impossible-4, are-2)\nadvmod(impossible-4, basically-3)\nroot(ROOT-0, impossible-4)\naux(find-6, to-5)\nccomp(impossible-4, find-6)\nprep(find-6, in-7)\npobj(in-7, California-8)\n", "aux(wait-3, Do-1)\nneg(wait-3, n't-2)\nroot(ROOT-0, wait-3)\nparataxis(wait-3, act-5)\nadvmod(act-5, now-6)\n", "det(Council-3, The-1)\nnn(Council-3, Parks-2)\nnsubj(wrote-4, Council-3)\nroot(ROOT-0, wrote-4)\ndet(BPCA-6, the-5)\ndobj(wrote-4, BPCA-6)\nmark(belongs-25, that-7)\ndet(garden-23, this-8)\nadvmod(private-12, too-10)\namod(garden-23, private-12)\nconj(private-12, exclusive-15)\nconj(private-12, complex-18)\ncc(private-12, and-19)\nconj(private-12, expensive-20)\namod(garden-23, enclosed-22)\nnsubj(belongs-25, garden-23)\nccomp(wrote-4, belongs-25)\nprep(belongs-25, in-26)\nadvmod(location-29, almost-27)\ndet(location-29, any-28)\npobj(in-26, location-29)\ncc(location-29, but-30)\ndet(waterfront-32, the-31)\nconj(location-29, waterfront-32)\n", "cc(have-6, And-2)\nnsubj(have-6, you-3)\naux(have-6, ca-4)\nneg(have-6, n't-5)\nroot(ROOT-0, have-6)\nnsubj(hearing-12, taxpayers-7)\nvmod(taxpayers-7, coming-8)\nprep(coming-8, into-9)\ndet(audit-11, an-10)\npobj(into-9, audit-11)\nccomp(have-6, hearing-12)\ndobj(hearing-12, oohs-14)\ncc(oohs-14, and-16)\nconj(oohs-14, ahs-18)\n", "amod(nationalists-3, Freed-1)\namod(nationalists-3, black-2)\nnsubj(resumed-4, nationalists-3)\nroot(ROOT-0, resumed-4)\namod(activity-6, political-5)\ndobj(resumed-4, activity-6)\nprep(resumed-4, in-7)\nnn(Africa-9, South-8)\npobj(in-7, Africa-9)\ncc(resumed-4, and-10)\nconj(resumed-4, vowed-11)\naux(fight-13, to-12)\nxcomp(vowed-11, fight-13)\nprep(fight-13, against-14)\npobj(against-14, apartheid-15)\nvmod(resumed-4, raising-17)\ndobj(raising-17, fears-18)\nprep(fears-18, of-19)\ndet(backlash-23, a-20)\namod(backlash-23, possible-21)\namod(backlash-23, white-22)\npobj(of-19, backlash-23)\n", "auxpass(held-2, Being-1)\ncsubj(irritates-7, held-2)\nadvmod(below-4, well-3)\nprep(held-2, below-4)\npobj(below-4, capacity-5)\nadvmod(irritates-7, greatly-6)\nroot(ROOT-0, irritates-7)\ndobj(irritates-7, them-8)\ncc(irritates-7, and-10)\naux(led-12, has-11)\nconj(irritates-7, led-12)\nprep(led-12, to-13)\namod(cheating-15, widespread-14)\npobj(to-13, cheating-15)\n", "nsubj(acquired-2, They-1)\nroot(ROOT-0, acquired-2)\ndobj(acquired-2, stakes-3)\nprep(stakes-3, in-4)\namod(companies-6, bottling-5)\npobj(in-4, companies-6)\nprep(companies-6, in-7)\ndet(U.S.-9, the-8)\npobj(in-7, U.S.-9)\ncc(in-7, and-10)\nconj(in-7, overseas-11)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependencies(GrammaticalStructure.Extras.NONE), tree, false, false, false));
        }
    }

    public void testMoreBasicRelations() {
        String[] testTrees = new String[]{"(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN woman)) (SBAR (WHNP (WP whom)) (S (NP (PRP you)) (VP (VBD gave) (NP (DT the) (NN package)) (PP (TO to))))))) (. .)))", "( (S (NP-SBJ (PRP i)) (VP (VBP m) (ADJP-PRD (JJ fat)))))", "(NP (NP (NNP Mr.) (NNP Laidig)) (, ,) (SBAR (WHNP-1 (WP whom)) (S (NP-SBJ (PRP he)) (VP (VBD referred) (PP-CLR (TO to) (NP (-NONE- *T*-1))) (PP-CLR (IN as) (NP (DT a) (NN friend)))))))", "( (SBARQ (WHNP-9 (WP what)) (SQ (VBZ does) (NP-SBJ (PRP it)) (VP (VB mean) (NP-9 (-NONE- *T*)) (SBAR-TMP (WHADVP-1 (WRB when)) (S (NP-SBJ (DT a) (JJ veiled) (NN chameleon) (NN egg)) (VP (VBZ is) (ADJP-PRD (JJ soft)) (ADVP-TMP-1 (-NONE- *T*))))))) (. ?)))", "( (S (NP-SBJ (PRP it)) (VP (VBD wase) (RB nt) (VP (VBG going))) (. ....)))", "( (S (NP-SBJ (DT An) (NN arbitrator) ) (VP (VP (VBD awarded) (NP (NNP Eastern) (NNPS Airlines) (NNS pilots) ) (NP (NP (QP (IN between) ($ $) (CD 60) (CD million) (CC and) ($ $) (CD 100) (CD million) ) (-NONE- *U*) ) (PP (IN in) (NP (JJ back) (NN pay) )))) (, ,) (NP-ADV (NP (DT a) (NN decision) ) (SBAR (WHNP-285 (WDT that) ) (S (NP-SBJ (-NONE- *T*-285) ) (VP (MD could) (VP (VB complicate) (NP (NP (DT the) (NN carrier) (POS 's) ) (NN bankruptcy-law) (NN reorganization) ))))))) (. .) ))", "(ROOT (S (NP (CD Two) (JJ former) (NNS ministers) ) (VP (VBD were) (ADJP (ADJP (ADVP (RB heavily) ) (VBN implicated) )) (PP (IN in) (NP (DT the) (NNP Koskotas) (NN affair) )))))", "( (S (NP-SBJ (CD Two) (JJ former) (NNS ministers) ) (VP (VBD were) (ADJP-PRD (ADJP (ADVP (RB heavily) ) (VBN implicated) )) (PP-LOC (IN in) (NP (DT the) (NNP Koskotas) (NN affair) )))))", "(NP-ADV (NP (DT The) (JJR more) (NNS accounts) ) (SBAR (WHNP-1 (-NONE- 0) ) (S (NP-SBJ (NNS customers) ) (VP (VBP have) (NP (-NONE- *T*-1) )))))", "(NP-ADV (NP-ADV (DT a) (NN-ADV lesson)) (VP (ADVP (RB once)) (VBN learned) (PP (IN by) (NP (NNP Henry) (NNP Kissinger)))))", "(NP (NP (NNP U.S.)) (PP (CC v.) (NP (NNP Hudson) (CC and) (NNP Goodwin))))", "(NP (NP (NN nothing)) (PP (CC but) (NP (PRP$ their) (NNS scratches))))", "(FRAG (ADVP (ADVP (RB So) (RB long)) (SBAR (IN as) (S (NP-SBJ (PRP you)) (VP (VBP do) (RB n't) (VP (VB look) (ADVP-DIR (RB down))))))) (. .))"};
        String[] testAnswers = new String[]{"nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(woman-4, the-3)\ndobj(saw-2, woman-4)\npobj(to-10, whom-5)\nnsubj(gave-7, you-6)\nrcmod(woman-4, gave-7)\ndet(package-9, the-8)\ndobj(gave-7, package-9)\nprep(gave-7, to-10)\n", "nsubj(fat-3, i-1)\ncop(fat-3, m-2)\nroot(ROOT-0, fat-3)\n", "nn(Laidig-2, Mr.-1)\nroot(ROOT-0, Laidig-2)\npobj(to-7, whom-4)\nnsubj(referred-6, he-5)\nrcmod(Laidig-2, referred-6)\nprep(referred-6, to-7)\nprep(referred-6, as-8)\ndet(friend-10, a-9)\npobj(as-8, friend-10)\n", "dobj(mean-4, what-1)\naux(mean-4, does-2)\nnsubj(mean-4, it-3)\nroot(ROOT-0, mean-4)\nadvmod(soft-11, when-5)\ndet(egg-9, a-6)\namod(egg-9, veiled-7)\nnn(egg-9, chameleon-8)\nnsubj(soft-11, egg-9)\ncop(soft-11, is-10)\nadvcl(mean-4, soft-11)\n", "nsubj(going-4, it-1)\naux(going-4, wase-2)\nneg(going-4, nt-3)\nroot(ROOT-0, going-4)\npunct(going-4, ....-5)\n", "det(arbitrator-2, An-1)\nnsubj(awarded-3, arbitrator-2)\nroot(ROOT-0, awarded-3)\nnn(pilots-6, Eastern-4)\nnn(pilots-6, Airlines-5)\niobj(awarded-3, pilots-6)\nquantmod($-8, between-7)\ndobj(awarded-3, $-8)\nnumber(million-10, 60-9)\nnum($-8, million-10)\ncc($-8, and-11)\nconj($-8, $-12)\nnumber(million-14, 100-13)\nnum($-12, million-14)\nprep($-8, in-15)\namod(pay-17, back-16)\npobj(in-15, pay-17)\ndet(decision-20, a-19)\nnpadvmod(awarded-3, decision-20)\nnsubj(complicate-23, that-21)\naux(complicate-23, could-22)\nrcmod(decision-20, complicate-23)\ndet(carrier-25, the-24)\nposs(reorganization-28, carrier-25)\npossessive(carrier-25, 's-26)\nnn(reorganization-28, bankruptcy-law-27)\ndobj(complicate-23, reorganization-28)\n", "num(ministers-3, Two-1)\namod(ministers-3, former-2)\nnsubjpass(implicated-6, ministers-3)\nauxpass(implicated-6, were-4)\nadvmod(implicated-6, heavily-5)\nroot(ROOT-0, implicated-6)\nprep(implicated-6, in-7)\ndet(affair-10, the-8)\nnn(affair-10, Koskotas-9)\npobj(in-7, affair-10)\n", "num(ministers-3, Two-1)\namod(ministers-3, former-2)\nnsubjpass(implicated-6, ministers-3)\nauxpass(implicated-6, were-4)\nadvmod(implicated-6, heavily-5)\nroot(ROOT-0, implicated-6)\nprep(implicated-6, in-7)\ndet(affair-10, the-8)\nnn(affair-10, Koskotas-9)\npobj(in-7, affair-10)\n", "det(accounts-3, The-1)\namod(accounts-3, more-2)\nroot(ROOT-0, accounts-3)\nnsubj(have-5, customers-4)\nrcmod(accounts-3, have-5)\n", "det(lesson-2, a-1)\nroot(ROOT-0, lesson-2)\nadvmod(learned-4, once-3)\nvmod(lesson-2, learned-4)\nprep(learned-4, by-5)\nnn(Kissinger-7, Henry-6)\npobj(by-5, Kissinger-7)\n", "root(ROOT-0, U.S.-1)\nprep(U.S.-1, v.-2)\npobj(v.-2, Hudson-3)\ncc(Hudson-3, and-4)\nconj(Hudson-3, Goodwin-5)\n", "root(ROOT-0, nothing-1)\nprep(nothing-1, but-2)\nposs(scratches-4, their-3)\npobj(but-2, scratches-4)\n", "advmod(long-2, So-1)\nroot(ROOT-0, long-2)\nmark(look-7, as-3)\nnsubj(look-7, you-4)\naux(look-7, do-5)\nneg(look-7, n't-6)\nadvcl(long-2, look-7)\nadvmod(look-7, down-8)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory trf = new NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependencies(GrammaticalStructure.Extras.NONE), tree, false, false, false));
        }
    }

    public void testToBeRelations() {
        String[] testTrees = new String[]{"(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (VP (VBG speaking))) (. .)))", "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is)  (VP (VBG speaking))) (. ?)))", "(ROOT (S (VP (VB Be) (ADJP (JJ honest))) (. .)))", "(ROOT (SBARQ (WHNP (WP What) ) (SQ (VBZ is) (NP (PRP he) ) (VP (VBG doing)))))", "(ROOT (SBARQ (WHNP (WP What) ) (SQ (VBP am) (NP (PRP I) ) (VP (VBG doing) (PP (IN in) (NP (NNP Jackson) (NNP Hole) )))) (. ?) ))", "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBP am) (NP (PRP I)) (S (VP (TO to) (VP (VB judge))))) (. ?)))", "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (NP (DT an) (JJ honest) (NN man))) (. .)))", "(ROOT (SBARQ (WHNP (WP What) (NN dignity) ) (SQ (VBZ is) (NP (EX there)) (PP (IN in) (NP (DT that) ))) (. ?)))", "(ROOT (S (NP (NN Hand-holding) ) (VP (VBZ is) (VP (VBG becoming) (NP (DT an) (NN investment-banking) (NN job) (NN requirement) ))) (. .) ))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (ADJP (JJ wrong) (PP (IN with) (S (VP (VBG expecting) (NP (NN pizza))))))) (. ?)))", "(ROOT (SBARQ (WHNP (WP Who) ) (SQ (VBZ is) (VP (VBG going) (S (VP (TO to) (VP (VB carry) (NP (DT the) (NN water) )))))) (. ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBP am) (NP (PRP I)) (VP (VBG doing) (S (VP (VBG dating) (NP (PRP her)))))) (. ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT that))) (. ?)))", "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is) (NP (NNP John))) (. ?)))", "(ROOT (SBARQ (WHNP (WDT What) (NN dog)) (SQ (VP (VBZ is) (VP (VBG barking) (ADVP (RB so) (RB loudly))))) (. ?)))", "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VP (VBZ is) (VP (VBG barking) (ADVP (RB so) (RB much))))) (. ?)))", "(ROOT (SBARQ (WHADVP (WRB Why)) (SQ (VBZ is) (NP (NNP Dave)) (VP (VBG becoming) (NP (DT a) (NN problem)))) (. ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NNP UAL) (NN stock) ) (ADJP (NN worth) )) (. ?)))", "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBP am) (NP (PRP I)) ) (. ?)))", "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VP (VBD told) (NP (PRP him)))) (. ?)))", "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (NP (DT a) (NN lawyer))) (. .)))", "(ROOT (S (NP (NNP Sue)) (VP (VBZ is) (ADJP (JJ intelligent))) (. .)))", "(ROOT (SBARQ (WHNP (WP Who)) (SQ (VBZ is) (ADJP (JJ nervous))) (. ?)))", "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN cow))) (PP (IN in) (NP (DT the) (NN field)))) (. .)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (EX there)) (PP (IN in) (NP (DT the) (NN field)))) (. ?)))", "(ROOT (SINV (ADVP (RB Here)) (VP (VBP are)) (NP (DT some) (NNS bags))))", "(ROOT (S (NP (PRP He)) (VP (VBZ is) (PP (IN in) (NP (DT the) (NN garden))))))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ 's) (PP (IN on) (NP (DT the) (NN test)))) (. ?)))", "(ROOT (SBARQ (WHADVP (WRB Why)) (SQ (VBZ is) (NP (DT the) (NN dog)) (ADJP (JJ pink))) (. ?)))", "(ROOT (S (NP (DT The) (NN dog)) (VP (VBZ is) (ADJP (JJ pink))) (. .)))", "(ROOT (SBARQ (WHNP (WDT What) (NN disease)) (SQ (VP (VBZ causes) (NP (NN pain)))) (. ?)))", "(ROOT (SBARQ (WHNP (WDT What) (NN disease)) (SQ (VBZ causes) (NP (NN pain))) (. ?)))", "(ROOT (S (VP (VB Be) (VP (VBG waiting) (PP (IN in) (NP (NN line))) (PP-TMP (IN at) (NP (CD 3) (NN p.m.))))) (. !)))", "(ROOT (S (VP (VB Be) (NP (DT a) (NN man))) (. !)))", "(ROOT (SBARQ (RB So) (WHNP (WP what)) (SQ (VBZ is) (NP (NNP Santa) (NNP Fe) ) (ADJP (IN worth) )) (. ?) ))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NP (PRP$ your) (NN sister) (POS 's)) (NN name))) (. ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (NP (DT the) (NN fear)) (PP (IN of) (NP (NNS cockroaches)))) (VP (VBN called))) (. ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBP am) (NP (PRP I)) (ADJP (JJ good) (PP (IN at)))) (. ?)))"};
        String[] basicAnswers = new String[]{"nsubj(speaking-3, Sue-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n", "nsubj(speaking-3, Who-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n", "cop(honest-2, Be-1)\nroot(ROOT-0, honest-2)\n", "dobj(doing-4, What-1)\naux(doing-4, is-2)\nnsubj(doing-4, he-3)\nroot(ROOT-0, doing-4)\n", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\nprep(doing-4, in-5)\nnn(Hole-7, Jackson-6)\npobj(in-5, Hole-7)\n", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\naux(judge-5, to-4)\nvmod(Who-1, judge-5)\n", "nsubj(man-5, Bill-1)\ncop(man-5, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nroot(ROOT-0, man-5)\n", "det(dignity-2, What-1)\nnsubj(is-3, dignity-2)\nroot(ROOT-0, is-3)\nexpl(is-3, there-4)\nprep(is-3, in-5)\npobj(in-5, that-6)\n", "nsubj(becoming-3, Hand-holding-1)\naux(becoming-3, is-2)\nroot(ROOT-0, becoming-3)\ndet(requirement-7, an-4)\nnn(requirement-7, investment-banking-5)\nnn(requirement-7, job-6)\nxcomp(becoming-3, requirement-7)\n", "nsubj(wrong-3, What-1)\ncop(wrong-3, is-2)\nroot(ROOT-0, wrong-3)\nprep(wrong-3, with-4)\npcomp(with-4, expecting-5)\ndobj(expecting-5, pizza-6)\n", "nsubj(going-3, Who-1)\naux(going-3, is-2)\nroot(ROOT-0, going-3)\naux(carry-5, to-4)\nxcomp(going-3, carry-5)\ndet(water-7, the-6)\ndobj(carry-5, water-7)\n", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\nvmod(doing-4, dating-5)\ndobj(dating-5, her-6)\n", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nnsubj(What-1, that-3)\n", "root(ROOT-0, Who-1)\ncop(Who-1, is-2)\nnsubj(Who-1, John-3)\n", "det(dog-2, What-1)\nnsubj(barking-4, dog-2)\naux(barking-4, is-3)\nroot(ROOT-0, barking-4)\nadvmod(loudly-6, so-5)\nadvmod(barking-4, loudly-6)\n", "nsubj(barking-3, Who-1)\naux(barking-3, is-2)\nroot(ROOT-0, barking-3)\nadvmod(much-5, so-4)\nadvmod(barking-3, much-5)\n", "advmod(becoming-4, Why-1)\naux(becoming-4, is-2)\nnsubj(becoming-4, Dave-3)\nroot(ROOT-0, becoming-4)\ndet(problem-6, a-5)\nxcomp(becoming-4, problem-6)\n", "dobj(worth-5, What-1)\ncop(worth-5, is-2)\nnn(stock-4, UAL-3)\nnsubj(worth-5, stock-4)\nroot(ROOT-0, worth-5)\n", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\n", "nsubj(told-2, Who-1)\nroot(ROOT-0, told-2)\ndobj(told-2, him-3)\n", "nsubj(lawyer-4, Sue-1)\ncop(lawyer-4, is-2)\ndet(lawyer-4, a-3)\nroot(ROOT-0, lawyer-4)\n", "nsubj(intelligent-3, Sue-1)\ncop(intelligent-3, is-2)\nroot(ROOT-0, intelligent-3)\n", "nsubj(nervous-3, Who-1)\ncop(nervous-3, is-2)\nroot(ROOT-0, nervous-3)\n", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(cow-4, a-3)\nnsubj(is-2, cow-4)\nprep(is-2, in-5)\ndet(field-7, the-6)\npobj(in-5, field-7)\n", "nsubj(is-2, What-1)\nroot(ROOT-0, is-2)\nexpl(is-2, there-3)\nprep(is-2, in-4)\ndet(field-6, the-5)\npobj(in-4, field-6)\n", "advmod(are-2, Here-1)\nroot(ROOT-0, are-2)\ndet(bags-4, some-3)\nnsubj(are-2, bags-4)\n", "nsubj(is-2, He-1)\nroot(ROOT-0, is-2)\nprep(is-2, in-3)\ndet(garden-5, the-4)\npobj(in-3, garden-5)\n", "nsubj('s-2, What-1)\nroot(ROOT-0, 's-2)\nprep('s-2, on-3)\ndet(test-5, the-4)\npobj(on-3, test-5)\n", "advmod(pink-5, Why-1)\ncop(pink-5, is-2)\ndet(dog-4, the-3)\nnsubj(pink-5, dog-4)\nroot(ROOT-0, pink-5)\n", "det(dog-2, The-1)\nnsubj(pink-4, dog-2)\ncop(pink-4, is-3)\nroot(ROOT-0, pink-4)\n", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n", "aux(waiting-2, Be-1)\nroot(ROOT-0, waiting-2)\nprep(waiting-2, in-3)\npobj(in-3, line-4)\nprep(waiting-2, at-5)\nnum(p.m.-7, 3-6)\npobj(at-5, p.m.-7)\n", "cop(man-3, Be-1)\ndet(man-3, a-2)\nroot(ROOT-0, man-3)\n", "advmod(worth-6, So-1)\ndobj(worth-6, what-2)\ncop(worth-6, is-3)\nnn(Fe-5, Santa-4)\nnsubj(worth-6, Fe-5)\nroot(ROOT-0, worth-6)\n", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nposs(sister-4, your-3)\nposs(name-6, sister-4)\npossessive(sister-4, 's-5)\nnsubj(What-1, name-6)\n", "dobj(called-7, What-1)\nauxpass(called-7, is-2)\ndet(fear-4, the-3)\nnsubjpass(called-7, fear-4)\nprep(fear-4, of-5)\npobj(of-5, cockroaches-6)\nroot(ROOT-0, called-7)\n", "pobj(at-5, What-1)\ncop(good-4, am-2)\nnsubj(good-4, I-3)\nroot(ROOT-0, good-4)\nprep(good-4, at-5)\n"};
        String[] noncollapsedAnswers = new String[]{"nsubj(speaking-3, Sue-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n", "nsubj(speaking-3, Who-1)\naux(speaking-3, is-2)\nroot(ROOT-0, speaking-3)\n", "cop(honest-2, Be-1)\nroot(ROOT-0, honest-2)\n", "dobj(doing-4, What-1)\naux(doing-4, is-2)\nnsubj(doing-4, he-3)\nroot(ROOT-0, doing-4)\n", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\nprep(doing-4, in-5)\nnn(Hole-7, Jackson-6)\npobj(in-5, Hole-7)\n", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\naux(judge-5, to-4)\nvmod(Who-1, judge-5)\n", "nsubj(man-5, Bill-1)\ncop(man-5, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nroot(ROOT-0, man-5)\n", "det(dignity-2, What-1)\nnsubj(is-3, dignity-2)\nroot(ROOT-0, is-3)\nexpl(is-3, there-4)\nprep(is-3, in-5)\npobj(in-5, that-6)\n", "nsubj(becoming-3, Hand-holding-1)\naux(becoming-3, is-2)\nroot(ROOT-0, becoming-3)\ndet(requirement-7, an-4)\nnn(requirement-7, investment-banking-5)\nnn(requirement-7, job-6)\nxcomp(becoming-3, requirement-7)\n", "nsubj(wrong-3, What-1)\ncop(wrong-3, is-2)\nroot(ROOT-0, wrong-3)\nprep(wrong-3, with-4)\npcomp(with-4, expecting-5)\ndobj(expecting-5, pizza-6)\n", "nsubj(going-3, Who-1)\nnsubj(carry-5, Who-1)\naux(going-3, is-2)\nroot(ROOT-0, going-3)\naux(carry-5, to-4)\nxcomp(going-3, carry-5)\ndet(water-7, the-6)\ndobj(carry-5, water-7)\n", "dobj(doing-4, What-1)\naux(doing-4, am-2)\nnsubj(doing-4, I-3)\nroot(ROOT-0, doing-4)\nvmod(doing-4, dating-5)\ndobj(dating-5, her-6)\n", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nnsubj(What-1, that-3)\n", "root(ROOT-0, Who-1)\ncop(Who-1, is-2)\nnsubj(Who-1, John-3)\n", "det(dog-2, What-1)\nnsubj(barking-4, dog-2)\naux(barking-4, is-3)\nroot(ROOT-0, barking-4)\nadvmod(loudly-6, so-5)\nadvmod(barking-4, loudly-6)\n", "nsubj(barking-3, Who-1)\naux(barking-3, is-2)\nroot(ROOT-0, barking-3)\nadvmod(much-5, so-4)\nadvmod(barking-3, much-5)\n", "advmod(becoming-4, Why-1)\naux(becoming-4, is-2)\nnsubj(becoming-4, Dave-3)\nroot(ROOT-0, becoming-4)\ndet(problem-6, a-5)\nxcomp(becoming-4, problem-6)\n", "dobj(worth-5, What-1)\ncop(worth-5, is-2)\nnn(stock-4, UAL-3)\nnsubj(worth-5, stock-4)\nroot(ROOT-0, worth-5)\n", "root(ROOT-0, Who-1)\ncop(Who-1, am-2)\nnsubj(Who-1, I-3)\n", "nsubj(told-2, Who-1)\nroot(ROOT-0, told-2)\ndobj(told-2, him-3)\n", "nsubj(lawyer-4, Sue-1)\ncop(lawyer-4, is-2)\ndet(lawyer-4, a-3)\nroot(ROOT-0, lawyer-4)\n", "nsubj(intelligent-3, Sue-1)\ncop(intelligent-3, is-2)\nroot(ROOT-0, intelligent-3)\n", "nsubj(nervous-3, Who-1)\ncop(nervous-3, is-2)\nroot(ROOT-0, nervous-3)\n", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(cow-4, a-3)\nnsubj(is-2, cow-4)\nprep(is-2, in-5)\ndet(field-7, the-6)\npobj(in-5, field-7)\n", "nsubj(is-2, What-1)\nroot(ROOT-0, is-2)\nexpl(is-2, there-3)\nprep(is-2, in-4)\ndet(field-6, the-5)\npobj(in-4, field-6)\n", "advmod(are-2, Here-1)\nroot(ROOT-0, are-2)\ndet(bags-4, some-3)\nnsubj(are-2, bags-4)\n", "nsubj(is-2, He-1)\nroot(ROOT-0, is-2)\nprep(is-2, in-3)\ndet(garden-5, the-4)\npobj(in-3, garden-5)\n", "nsubj('s-2, What-1)\nroot(ROOT-0, 's-2)\nprep('s-2, on-3)\ndet(test-5, the-4)\npobj(on-3, test-5)\n", "advmod(pink-5, Why-1)\ncop(pink-5, is-2)\ndet(dog-4, the-3)\nnsubj(pink-5, dog-4)\nroot(ROOT-0, pink-5)\n", "det(dog-2, The-1)\nnsubj(pink-4, dog-2)\ncop(pink-4, is-3)\nroot(ROOT-0, pink-4)\n", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n", "det(disease-2, What-1)\nnsubj(causes-3, disease-2)\nroot(ROOT-0, causes-3)\ndobj(causes-3, pain-4)\n", "aux(waiting-2, Be-1)\nroot(ROOT-0, waiting-2)\nprep(waiting-2, in-3)\npobj(in-3, line-4)\nprep(waiting-2, at-5)\nnum(p.m.-7, 3-6)\npobj(at-5, p.m.-7)\n", "cop(man-3, Be-1)\ndet(man-3, a-2)\nroot(ROOT-0, man-3)\n", "advmod(worth-6, So-1)\ndobj(worth-6, what-2)\ncop(worth-6, is-3)\nnn(Fe-5, Santa-4)\nnsubj(worth-6, Fe-5)\nroot(ROOT-0, worth-6)\n", "root(ROOT-0, What-1)\ncop(What-1, is-2)\nposs(sister-4, your-3)\nposs(name-6, sister-4)\npossessive(sister-4, 's-5)\nnsubj(What-1, name-6)\n", "dobj(called-7, What-1)\nauxpass(called-7, is-2)\ndet(fear-4, the-3)\nnsubjpass(called-7, fear-4)\nprep(fear-4, of-5)\npobj(of-5, cockroaches-6)\nroot(ROOT-0, called-7)\n", "pobj(at-5, What-1)\ncop(good-4, am-2)\nnsubj(good-4, I-3)\nroot(ROOT-0, good-4)\nprep(good-4, at-5)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array and basic answer array lengths mismatch!", (int)testTrees.length, (int)basicAnswers.length);
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array and noncollapsed answer array lengths mismatch!", (int)testTrees.length, (int)noncollapsedAnswers.length);
        NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory trf = new NPTmpRetainingTreeNormalizer.NPTmpAdvRetainingTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String basicAnswer = basicAnswers[i];
            String noncollapsedAnswer = noncollapsedAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), (String)basicAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependencies(GrammaticalStructure.Extras.NONE), tree, false, false, false));
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected noncollapsed dependencies for tree " + testTree), (String)noncollapsedAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependencies(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false));
        }
    }

    public void testBasicRelationsWithCopulaAsHead() {
        String[] testTrees = new String[]{"(ROOT (S (NP (NNP Reagan)) (VP (VBZ has) (VP (VBN died))) (. .)))", "(ROOT (S (NP (NNP Kennedy)) (VP (VBZ has) (VP (VBN been) (VP (VBN killed)))) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (NP (DT an) (JJ honest) (NN man))) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (ADJP (JJ big) (CC and) (JJ honest))) (. .)))", "(ROOT (S (NP (NNP Clinton)) (VP (VBD defeated) (NP (NNP Dole))) (. .)))", "(ROOT (S (SBAR (WHNP (WP What)) (S (NP (PRP she)) (VP (VBD said)))) (VP (VBZ is) (ADJP (JJ untrue))) (. .)))", "(ROOT (S (NP (NNP Dole)) (VP (VBD was) (VP (VBN defeated) (PP (IN by) (NP (NNP Clinton))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "(ROOT (S (NP (PRP We)) (VP (VBP have) (NP (NP (DT no) (JJ useful) (NN information)) (PP (IN on) (SBAR (IN whether) (S (NP (NNS users)) (VP (VBP are) (PP (IN at) (NP (NN risk))))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ certain) (SBAR (IN that) (S (NP (PRP he)) (VP (VBD did) (NP (PRP it))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP am) (ADJP (JJ ready) (S (VP (TO to) (VP (VB leave)))))) (. .)))", "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN statue)) (PP (IN in) (NP (DT the) (NN corner))))) (. .)))", "(ROOT (S (NP (DT The) (NN director)) (VP (VBZ is) (ADJP (NP (CD 65) (NNS years)) (JJ old))) (. .)))", "(ROOT (S (NP (DT The) (NN man)) (VP (VBZ is) (ADVP (RB here))) (. .)))", "(ROOT (S (NP (NNP Xml) (NN field)) (VP (MD should) (VP (VB include) (NP (PDT both) (NP (DT the) (NN entity) (NN id)) (CC and) (NP (DT the) (NN entity) (NN name))) (SBAR (IN since) (S (NP (DT the) (NN entity) (NNS names)) (VP (VBP are) (RB not) (ADJP (JJ unique))))))) (. .)))", "(ROOT (S (S (NP (DT The) (NN government)) (VP (VBZ counts) (NP (NN money)) (SBAR (IN as) (S (NP (PRP it)) (VP (VBZ is) (VP (VBN spent))))))) (: ;) (S (NP (NNP Dodge)) (VP (VBZ counts) (NP (NNS contracts)) (SBAR (WHADVP (WRB when)) (S (NP (PRP they)) (VP (VBP are) (VP (VBN awarded))))))) (. .)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBP am) (NP (PRP I)) (ADJP (JJ good) (PP (IN at)))) (. ?)))"};
        String[] testAnswers = new String[]{"nsubj(died-3, Reagan-1)\naux(died-3, has-2)\nroot(ROOT-0, died-3)\n", "nsubjpass(killed-4, Kennedy-1)\naux(killed-4, has-2)\nauxpass(killed-4, been-3)\nroot(ROOT-0, killed-4)\n", "nsubj(is-2, Bill-1)\nroot(ROOT-0, is-2)\ndet(man-5, an-3)\namod(man-5, honest-4)\nxcomp(is-2, man-5)\n", "nsubj(is-2, Bill-1)\nroot(ROOT-0, is-2)\nacomp(is-2, big-3)\ncc(big-3, and-4)\nconj(big-3, honest-5)\n", "nsubj(defeated-2, Clinton-1)\nroot(ROOT-0, defeated-2)\ndobj(defeated-2, Dole-3)\n", "dobj(said-3, What-1)\nnsubj(said-3, she-2)\ncsubj(is-4, said-3)\nroot(ROOT-0, is-4)\nacomp(is-4, untrue-5)\n", "nsubjpass(defeated-3, Dole-1)\nauxpass(defeated-3, was-2)\nroot(ROOT-0, defeated-3)\nprep(defeated-3, by-4)\npobj(by-4, Clinton-5)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\naux(swim-4, to-3)\nxcomp(like-2, swim-4)\n", "nsubj(have-2, We-1)\nroot(ROOT-0, have-2)\nneg(information-5, no-3)\namod(information-5, useful-4)\ndobj(have-2, information-5)\nprep(information-5, on-6)\nmark(are-9, whether-7)\nnsubj(are-9, users-8)\npcomp(on-6, are-9)\nprep(are-9, at-10)\npobj(at-10, risk-11)\n", "nsubj(am-2, I-1)\nroot(ROOT-0, am-2)\nacomp(am-2, certain-3)\nmark(did-6, that-4)\nnsubj(did-6, he-5)\nccomp(certain-3, did-6)\ndobj(did-6, it-7)\n", "nsubj(am-2, I-1)\nroot(ROOT-0, am-2)\nacomp(am-2, ready-3)\naux(leave-5, to-4)\nxcomp(ready-3, leave-5)\n", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(statue-4, a-3)\nnsubj(is-2, statue-4)\nprep(statue-4, in-5)\ndet(corner-7, the-6)\npobj(in-5, corner-7)\n", "det(director-2, The-1)\nnsubj(is-3, director-2)\nroot(ROOT-0, is-3)\nnum(years-5, 65-4)\nnpadvmod(old-6, years-5)\nacomp(is-3, old-6)\n", "det(man-2, The-1)\nnsubj(is-3, man-2)\nroot(ROOT-0, is-3)\nadvmod(is-3, here-4)\n", "nn(field-2, Xml-1)\nnsubj(include-4, field-2)\naux(include-4, should-3)\nroot(ROOT-0, include-4)\npreconj(id-8, both-5)\ndet(id-8, the-6)\nnn(id-8, entity-7)\ndobj(include-4, id-8)\ncc(id-8, and-9)\ndet(name-12, the-10)\nnn(name-12, entity-11)\nconj(id-8, name-12)\nmark(are-17, since-13)\ndet(names-16, the-14)\nnn(names-16, entity-15)\nnsubj(are-17, names-16)\nadvcl(include-4, are-17)\nneg(are-17, not-18)\nacomp(are-17, unique-19)\n", "det(government-2, The-1)\nnsubj(counts-3, government-2)\nroot(ROOT-0, counts-3)\ndobj(counts-3, money-4)\nmark(spent-8, as-5)\nnsubjpass(spent-8, it-6)\nauxpass(spent-8, is-7)\nadvcl(counts-3, spent-8)\nnsubj(counts-11, Dodge-10)\nparataxis(counts-3, counts-11)\ndobj(counts-11, contracts-12)\nadvmod(awarded-16, when-13)\nnsubjpass(awarded-16, they-14)\nauxpass(awarded-16, are-15)\nadvcl(counts-11, awarded-16)\n", "pobj(at-5, What-1)\nroot(ROOT-0, am-2)\nnsubj(am-2, I-3)\nacomp(am-2, good-4)\nprep(good-4, at-5)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree, new PennTreebankLanguagePack().punctuationWordRejectFilter(), new SemanticHeadFinder(false));
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependencies(GrammaticalStructure.Extras.NONE), tree, false, false, false));
        }
    }

    public void testNonCollapsedRelations() {
        String[] testTrees = new String[]{"(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "(ROOT (S (NP (PRP He)) (VP (VBZ says) (SBAR (IN that) (S (NP (PRP you)) (VP (VBP like) (S (VP (TO to) (VP (VB swim)))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP who)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NP (NN wife))) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN book)) (SBAR (WHNP (WDT which)) (S (NP (PRP you)) (VP (VBD bought)))))) (. .)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT the) (NN esophagus)) (VP (VBN used) (PP (IN for)))) (? ?)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN woman)) (SBAR (WHNP (WP whom)) (S (NP (PRP you)) (VP (VBD gave) (NP (DT the) (NN package)) (PP (TO to))))))) (. .)))"};
        String[] testAnswers = new String[]{"nsubj(like-2, I-1)\nnsubj(swim-4, I-1)\nroot(ROOT-0, like-2)\naux(swim-4, to-3)\nxcomp(like-2, swim-4)\n", "nsubj(says-2, He-1)\nroot(ROOT-0, says-2)\nmark(like-5, that-3)\nnsubj(like-5, you-4)\nnsubj(swim-7, you-4)\nccomp(says-2, like-5)\naux(swim-7, to-6)\nxcomp(like-5, swim-7)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nref(man-4, who-5)\ndobj(love-7, who-5)\nnsubj(love-7, you-6)\nrcmod(man-4, love-7)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nref(man-4, whose-5)\nposs(wife-6, whose-5)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nrcmod(man-4, love-8)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(book-4, the-3)\ndobj(saw-2, book-4)\nref(book-4, which-5)\ndobj(bought-7, which-5)\nnsubj(bought-7, you-6)\nrcmod(book-4, bought-7)\n", "pobj(for-6, What-1)\nauxpass(used-5, is-2)\ndet(esophagus-4, the-3)\nnsubjpass(used-5, esophagus-4)\nroot(ROOT-0, used-5)\nprep(used-5, for-6)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(woman-4, the-3)\ndobj(saw-2, woman-4)\nref(woman-4, whom-5)\npobj(to-10, whom-5)\nnsubj(gave-7, you-6)\nrcmod(woman-4, gave-7)\ndet(package-9, the-8)\ndobj(gave-7, package-9)\nprep(gave-7, to-10)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.allTypedDependencies(), tree, false, false, false));
        }
    }

    public void testNonCollapsedSeparator() {
        String[] testTrees = new String[]{"(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))"};
        String[] testAnswers = new String[]{"nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\naux(swim-4, to-3)\nxcomp(like-2, swim-4)\n======\nnsubj(swim-4, I-1)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.allTypedDependencies(), tree, false, true, false));
        }
    }

    public void testCollapsedRelations() {
        String[] testTrees = new String[]{"(ROOT (S (NP (NNP Dole)) (VP (VBD was) (VP (VBN defeated) (PP (IN by) (NP (NNP Clinton))))) (. .)))", "(ROOT (S (SBAR (IN That) (S (NP (PRP she)) (VP (VBD lied)))) (VP (VBD was) (VP (VBN suspected) (PP (IN by) (NP (NN everyone))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP like) (S (VP (TO to) (VP (VB swim))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD sat) (PP (IN on) (NP (DT the) (NN chair)))) (. .)))", "(ROOT (S (NP (PRP We)) (VP (VBP have) (NP (NP (DT no) (JJ useful) (NN information)) (PP (IN on) (SBAR (IN whether) (S (NP (NNS users)) (VP (VBP are) (PP (IN at) (NP (NN risk))))))))) (. .)))", "(ROOT (S (NP (PRP They)) (VP (VBD heard) (PP (IN about) (NP (NN asbestos))) (S (VP (VBG having) (NP (JJ questionable) (NNS properties))))) (. .)))", "(ROOT (S (NP (PRP He)) (VP (VBZ says) (SBAR (IN that) (S (NP (PRP you)) (VP (VBP like) (S (VP (TO to) (VP (VB swim)))))))) (. .)))", "(ROOT (S (NP (NNP U.S.) (NNS forces)) (VP (VBP have) (VP (VBN been) (VP (VBN engaged) (PP (IN in) (NP (JJ intense) (NN fighting))) (SBAR (IN after) (S (NP (NNS insurgents)) (VP (VBD launched) (NP (JJ simultaneous) (NNS attacks)))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP who)) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN man)) (SBAR (WHNP (WP$ whose) (NP (NN wife))) (S (NP (PRP you)) (VP (VBP love)))))) (. .)))", "(ROOT (S (NP (EX There)) (VP (VBZ is) (NP (NP (DT a) (NN statue)) (PP (IN in) (NP (DT the) (NN corner))))) (. .)))", "(ROOT (S (NP (PRP He)) (VP (VBD talked) (PP (TO to) (NP (DT the) (NN president))) (SBAR (IN in) (NN order) (S (VP (TO to) (VP (VB secure) (NP (DT the) (NN account))))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBD saw) (NP (NP (DT the) (NN book)) (SBAR (WHNP (WDT which)) (S (NP (PRP you)) (VP (VBD bought)))))) (. .)))", "(ROOT (S (NP (NNP Bill)) (VP (VBD picked) (NP (NP (NNP Fred)) (PP (IN for) (NP (NP (DT the) (NN team)) (VP (VBG demonstrating) (NP (PRP$ his) (NN incompetence))))))) (. .)))", "(ROOT (SBARQ (WHPP (IN In) (WHNP (WDT which) (NN city))) (SQ (VBP do) (NP (PRP you)) (VP (VB live))) (. ?)))", "(ROOT (SBARQ (WHNP (WP What)) (SQ (VBZ is) (NP (DT the) (NN esophagus)) (VP (VBN used) (PP (IN for)))) (? ?)))", "(ROOT (S (NP (CC Both) (NP (DT the) (NNS boys)) (CC and) (NP (DT the) (NNS girls))) (VP (VBP are) (ADVP (RB here))) (. .)))", "( (S (NP (NNP Fred)) (VP (VBD flew) (PP (IN across) (CC or) (IN across) (NP (NNP Serbia)))) (. .)))", "(ROOT (SBARQ (WHPP (IN For) (WHNP (WRB how) (JJ long))) (SQ (VBZ is) (NP (DT an) (NN elephant)) (ADJP (JJ pregnant))) (. ?)))", "( (S (NP-SBJ-1 (PRP He)) (VP (VBD achieved) (NP (DT this)) (PP-MNR (PP (IN in) (NP (NN part))) (IN through) (NP (DT an) (JJ uncanny) (NN talent)))) (. .)))", "(ROOT (S (NP (DT The) (NN turf)) (ADVP (RB recently)) (VP (VBZ has) (VP (VBN ranged) (PP (PP (IN from) (NP (NNP Chile))) (PP (TO to) (NP (NNP Austria))) (PP (TO to) (NP (NNP Portugal)))))) (. .)))", "( (S (CC But) (NP (NP (NNP Ms.) (NNP Poore)) (, ,) (NP (NP (DT the) (NN magazine) (POS 's)) (NN editor) (CC and) (NN publisher)) (, ,)) (VP (VBD resigned)) (. .)))", "( (S (NP (EX There)) (VP (VBZ 's) (ADVP (RB never)) (VP (VBN been) (NP (DT an) (NN exception)))) (. .)))", "( (S (NP (NNP Sotheby) (POS 's)) (PRN (, ,) (S (NP (PRP she)) (VP (VBZ says))) (, ,)) (VP (VBZ is) (VP (`` ``) (VBG wearing) (NP (DT both) (NNS hats)))) (. .) ('' '')))", "( (S (NP (NP (JJ Average) (NN maturity)) (PP (IN of) (NP (NP (NML (DT the) (NNS funds)) (POS ')) (NNS investments)))) (VP (VBD lengthened)) (. .)))"};
        String[] testAnswers = new String[]{"nsubjpass(defeated-3, Dole-1)\nauxpass(defeated-3, was-2)\nroot(ROOT-0, defeated-3)\nagent(defeated-3, Clinton-5)\n", "mark(lied-3, That-1)\nnsubj(lied-3, she-2)\ncsubjpass(suspected-5, lied-3)\nauxpass(suspected-5, was-4)\nroot(ROOT-0, suspected-5)\nagent(suspected-5, everyone-7)\n", "nsubj(like-2, I-1)\nnsubj(swim-4, I-1)\nroot(ROOT-0, like-2)\naux(swim-4, to-3)\nxcomp(like-2, swim-4)\n", "nsubj(sat-2, I-1)\nroot(ROOT-0, sat-2)\ndet(chair-5, the-4)\nprep_on(sat-2, chair-5)\n", "nsubj(have-2, We-1)\nroot(ROOT-0, have-2)\nneg(information-5, no-3)\namod(information-5, useful-4)\ndobj(have-2, information-5)\nmark(are-9, whether-7)\nnsubj(are-9, users-8)\nprepc_on(information-5, are-9)\nprep_at(are-9, risk-11)\n", "nsubj(heard-2, They-1)\nroot(ROOT-0, heard-2)\nprep_about(heard-2, asbestos-4)\nxcomp(heard-2, having-5)\namod(properties-7, questionable-6)\ndobj(having-5, properties-7)\n", "nsubj(says-2, He-1)\nroot(ROOT-0, says-2)\nmark(like-5, that-3)\nnsubj(like-5, you-4)\nnsubj(swim-7, you-4)\nccomp(says-2, like-5)\naux(swim-7, to-6)\nxcomp(like-5, swim-7)\n", "nn(forces-2, U.S.-1)\nnsubjpass(engaged-5, forces-2)\naux(engaged-5, have-3)\nauxpass(engaged-5, been-4)\nroot(ROOT-0, engaged-5)\namod(fighting-8, intense-7)\nprep_in(engaged-5, fighting-8)\nmark(launched-11, after-9)\nnsubj(launched-11, insurgents-10)\nadvcl(engaged-5, launched-11)\namod(attacks-13, simultaneous-12)\ndobj(launched-11, attacks-13)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\ndobj(love-7, man-4)\nnsubj(love-7, you-6)\nrcmod(man-4, love-7)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(man-4, the-3)\ndobj(saw-2, man-4)\nposs(wife-6, man-4)\ndobj(love-8, wife-6)\nnsubj(love-8, you-7)\nrcmod(man-4, love-8)\n", "expl(is-2, There-1)\nroot(ROOT-0, is-2)\ndet(statue-4, a-3)\nnsubj(is-2, statue-4)\ndet(corner-7, the-6)\nprep_in(statue-4, corner-7)\n", "nsubj(talked-2, He-1)\nroot(ROOT-0, talked-2)\ndet(president-5, the-4)\nprep_to(talked-2, president-5)\nmark(secure-9, in-6)\ndep(secure-9, order-7)\naux(secure-9, to-8)\nadvcl(talked-2, secure-9)\ndet(account-11, the-10)\ndobj(secure-9, account-11)\n", "nsubj(saw-2, I-1)\nroot(ROOT-0, saw-2)\ndet(book-4, the-3)\ndobj(saw-2, book-4)\ndobj(bought-7, book-4)\nnsubj(bought-7, you-6)\nrcmod(book-4, bought-7)\n", "nsubj(picked-2, Bill-1)\nroot(ROOT-0, picked-2)\ndobj(picked-2, Fred-3)\ndet(team-6, the-5)\nprep_for(Fred-3, team-6)\nvmod(team-6, demonstrating-7)\nposs(incompetence-9, his-8)\ndobj(demonstrating-7, incompetence-9)\n", "det(city-3, which-2)\nprep_in(live-6, city-3)\naux(live-6, do-4)\nnsubj(live-6, you-5)\nroot(ROOT-0, live-6)\n", "prep_for(used-5, What-1)\nauxpass(used-5, is-2)\ndet(esophagus-4, the-3)\nnsubjpass(used-5, esophagus-4)\nroot(ROOT-0, used-5)\n", "preconj(boys-3, Both-1)\ndet(boys-3, the-2)\nnsubj(are-7, boys-3)\ndet(girls-6, the-5)\nconj_and(boys-3, girls-6)\nroot(ROOT-0, are-7)\nadvmod(are-7, here-8)\n", "nsubj(flew-2, Fred-1)\nroot(ROOT-0, flew-2)\nprep_across(flew-2, Serbia-6)\n", "advmod(long-3, how-2)\nprep_for(pregnant-7, long-3)\ncop(pregnant-7, is-4)\ndet(elephant-6, an-5)\nnsubj(pregnant-7, elephant-6)\nroot(ROOT-0, pregnant-7)\n", "nsubj(achieved-2, He-1)\nroot(ROOT-0, achieved-2)\ndobj(achieved-2, this-3)\nprep_in(achieved-2, part-5)\ndet(talent-9, an-7)\namod(talent-9, uncanny-8)\nprep_through(achieved-2, talent-9)\n", "det(turf-2, The-1)\nnsubj(ranged-5, turf-2)\nadvmod(ranged-5, recently-3)\naux(ranged-5, has-4)\nroot(ROOT-0, ranged-5)\nprep_from(ranged-5, Chile-7)\nprep_to(ranged-5, Austria-9)\nprep_to(ranged-5, Portugal-11)\n", "cc(resigned-12, But-1)\nnn(Poore-3, Ms.-2)\nnsubj(resigned-12, Poore-3)\ndet(magazine-6, the-5)\nposs(editor-8, magazine-6)\nappos(Poore-3, editor-8)\nconj_and(editor-8, publisher-10)\nroot(ROOT-0, resigned-12)\n", "expl(exception-6, There-1)\nauxpass(exception-6, 's-2)\nneg(exception-6, never-3)\ncop(exception-6, been-4)\ndet(exception-6, an-5)\nroot(ROOT-0, exception-6)\n", "nsubj(wearing-9, Sotheby-1)\npossessive(Sotheby-1, 's-2)\nnsubj(says-5, she-4)\nparataxis(wearing-9, says-5)\naux(wearing-9, is-7)\nroot(ROOT-0, wearing-9)\ndet(hats-11, both-10)\ndobj(wearing-9, hats-11)\n", "amod(maturity-2, Average-1)\nnsubj(lengthened-8, maturity-2)\ndet(funds-5, the-4)\nposs(investments-7, funds-5)\nprep_of(maturity-2, investments-7)\nroot(ROOT-0, lengthened-8)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            String depString = GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected collapsed dependencies for tree " + testTree), (String)testAnswer, (String)depString);
        }
    }

    public void testCCProcessedRelations() {
        String[] testTrees = new String[]{"(ROOT (S (NP (NNP Bill)) (VP (VBZ is) (ADJP (JJ big) (CC and) (JJ honest))) (. .)))", "(ROOT (S (NP (CC Both) (NP (DT the) (NNS boys)) (CC and) (NP (DT the) (NNS girls))) (VP (VBP are) (ADVP (RB here))) (. .)))", "(ROOT (S (NP-SBJ-38 (DT Neither) (NP (PRP they) ) (CC nor) (NP (NNP Mr.) (NNP McAlpine) )) (VP (MD could) (VP (VB be) (VP (VBN reached) (NP (-NONE- *-38) ) (PP-PRP (IN for) (NP (NN comment) ))))) (. .) ))", "(ROOT (S (NP (NNP John)) (VP (VBZ works) (PP (DT both) (PP (IN in) (NP (NNP Zurich))) (CC and) (PP (IN in) (NP (NNP London))))) (. .)))", "(ROOT (S (NP (NP (NNS Languages)) (PP (PP (IN with) (NP (NNS alphabets))) (CC and) (PP (IN without) (NP (NNS alphabets))))) (VP (VBP are) (ADJP (JJ difficult))) (. .)))", "(ROOT (S (NP (PRP$ His) (NN term)) (VP (VP (VBZ has) (VP (VBN produced) (NP (NP (DT no) (JJ spectacular) (NNS failures)) (PP (PP (IN in) (NP (NNS politics))) (, ,) (PP (IN in) (NP (DT the) (NN economy))) (CC or) (PP (IN on) (NP (DT the) (JJ military) (NN front))))))) (, ,) (CC and) (VP (VBZ has) (VP (VBN chalked) (PRT (RP up)) (NP (DT some) (NNS successes))))) (. .)))", "(ROOT (S (NP (NNP Fred)) (VP (VBD walked) (PP (PP (IN out) (NP (DT the) (NN door))) (CC and) (PP (RB right) (IN into) (NP (DT a) (NN trap))))) (. .)))", "(ROOT (S (NP (NNP Fred)) (VP (VBD walked) (PP (PP (IN into) (NP (DT the) (NN house))) (CC and) (PP (RB right) (IN into) (NP (DT a) (NN trap))))) (. .)))", "(ROOT (S (NP (NNP Marie) (CC and) (NNP Chris)) (VP (VP (VBD went) (PRT (RP out))) (, ,) (VP (VBD drank) (NP (NN coffee))) (, ,) (CC and) (VP (VBD talked) (PP (IN about) (NP (NNP Stanford) (NNPS Dependencies))))) (. .)))", "(ROOT (S (NP-TMP (DT These) (NNS days)) (NP (PRP he)) (VP (VBZ hustles) (PP (TO to) (NP (JJ house-painting) (NNS jobs))) (PP (IN in) (NP (PRP$ his) (NNP Chevy) (NN pickup))) (PP (IN before) (CC and) (IN after) (S (VP (NN training) (PP (IN with) (NP (DT the) (NNPS Tropics))))))) (. .)))", "(ROOT (S (NP (NNP Jill)) (VP (VBD walked) (PP (PP (IN out) (NP (DT the) (NN door))) (, ,) (PP (IN over) (NP (DT the) (NN road))) (, ,) (PP (IN across) (NP (DT the) (JJ deserted) (NN block))) (, ,) (PP (IN around) (NP (DT the) (NN corner))) (, ,) (CC and) (PP (IN through) (NP (DT the) (NN park))))) (. .)))", "(ROOT (S (NP (NNP John)) (VP (VP (VBD noticed) (NP (DT a) (NN cockroach))) (CC and) (VP (VBD departed))) (. .)))", "( (S (S (NP (RBR More) (JJ common) (NN chrysotile) (NNS fibers)) (VP (VP (VBP are) (ADJP (JJ curly))) (CC and) (VP (VBP are) (VP (ADVP (RBR more) (RB easily)) (VBN rejected) (PP (IN by) (NP (DT the) (NN body))))))) (, ,) (NP (NNP Dr.) (NNP Mossman)) (VP (VBD explained)) (. .)))", "( (S (NP (NNP John)) (VP (VP (VBD is) (VP (VBN appalled))) (CC and) (VP (MD will) (VP (VB complain)))) (. .)))", "( (SBARQ (WHNP (WP What)) (SQ (VP (VBP are) (NP (NP (NP (NP (NNP Christopher) (NNP Marlowe) (POS 's)) (CC and) (NP (NNP Shakespeare) (POS 's))) (JJ literary) (NNS contributions)) (PP (TO to) (NP (JJ English) (NN literature)))))) (. ?)))", "( (SBARQ (WHNP (WP What)) (SQ (VP (VBP are) (NP (NP (NP (NP (NP (NNP Christopher) (NNP Marlowe)) (CC and) (NP (NNP Shakespeare))) (POS 's)) (JJ literary) (NNS contributions)) (PP (TO to) (NP (JJ English) (NN literature)))))) (. ?)))", "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NNS dogs)) (CONJP (RB as) (RB well) (IN as)) (NP (NNS cats)))) (. .)))", "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NNS dogs)) (CONJP (RB rather) (IN than)) (NP (NNS cats)))) (. .)))", "( (S (NP (PRP I)) (VP (VBP like) (NP (NP (NN brandy)) (CONJP (RB not) (TO to) (VB mention)) (NP (NN cognac)))) (. .)))", "( (S (NP (PRP I)) (VP (VBP like) (NP (CONJP (RB not) (RB only)) (NP (NNS cats)) (CONJP (CC but) (RB also)) (NP (NN dogs)))) (. .)))", "((S (NP (NNP Fred)) (VP (VBD flew) (PP (CONJP (RB not) (JJ only)) (PP (TO to) (NP (NNP Greece))) (CONJP (CC but) (RB also)) (PP (TO to) (NP (NNP Serbia))))) (. .)))", "( (SINV (ADVP-TMP (RB Only) (RB recently)) (SINV (VBZ has) (NP (PRP it)) (VP (VBN been) (VP (ADVP-MNR (RB attractively)) (VBN redesigned)))) (CC and) (SINV (NP (PRP$ its) (JJ editorial) (NN product)) (VP (VBN improved))) (. .)))", "( (S (NP-SBJ (JJP (JJ Political) (CC and) (NN currency)) (NNS gyrations)) (VP (MD can) (VP (VB whipsaw) (NP (DT the) (NNS funds)))) (. .)))", "(NP-SBJ (NNS Managers) (CC and) (NNS presenters))", "(NP (NN education) (, ,) (NN science) (CC and) (NN culture))", "(NP (NN education) (, ,) (NN science) (, ,) (CC and) (NN culture))", "(NP (NNP Digital) (, ,) (NNP Hewlett) (CC and) (NNP Sun) ) ", "(NP (NNP Digital) (, ,) (NNP Hewlett) (, ,) (CC and) (NNP Sun))", "(NP (NP (NNP Home) (NNP Depot) ) (, ,) (NP (NNP Sun) ) (, ,) (CC and) (NP (NNP Coke) ) )", "(NP (NP (NNP Home) (NNP Depot) ) (, ,) (NP (NNP Sun) ) (CC and)  (NP (NNP Coke) ) )", "(S (NP (NP (NN Activation)) (PP (IN of) (NP (NP (NN Akt)) (, ,) (NP (NN NFkappaB)) (, ,) (CC and) (NP (NN Stat3)) (CONJP (CC but) (RB not)) (NP (NN MAPK) (NNS pathways))))) (VP (VBP are) (NP (NP (NNS characteristics)) (VP (VBN associated) (PP (IN with) (NP (NP (JJ malignant) (NN transformation)) ))))))"};
        String[] testAnswers = new String[]{"nsubj(big-3, Bill-1)\nnsubj(honest-5, Bill-1)\ncop(big-3, is-2)\nroot(ROOT-0, big-3)\nconj_and(big-3, honest-5)\n", "preconj(boys-3, Both-1)\ndet(boys-3, the-2)\nnsubj(are-7, boys-3)\ndet(girls-6, the-5)\nconj_and(boys-3, girls-6)\nnsubj(are-7, girls-6)\nroot(ROOT-0, are-7)\nadvmod(are-7, here-8)\n", "preconj(they-2, Neither-1)\nnsubjpass(reached-8, they-2)\nnn(McAlpine-5, Mr.-4)\nconj_nor(they-2, McAlpine-5)\nnsubjpass(reached-8, McAlpine-5)\naux(reached-8, could-6)\nauxpass(reached-8, be-7)\nroot(ROOT-0, reached-8)\nprep_for(reached-8, comment-10)\n", "nsubj(works-2, John-1)\nroot(ROOT-0, works-2)\npreconj(works-2, both-3)\nprep_in(works-2, Zurich-5)\nprep_in(works-2, London-8)\nconj_and(Zurich-5, London-8)\n", "conj_and(Languages-1, Languages-1')\nnsubj(difficult-8, Languages-1)\nnsubj(difficult-8, Languages-1')\nprep_with(Languages-1, alphabets-3)\nprep_without(Languages-1', alphabets-6)\ncop(difficult-8, are-7)\nroot(ROOT-0, difficult-8)\n", "poss(term-2, His-1)\nnsubj(produced-4, term-2)\nnsubj(chalked-22, term-2)\naux(produced-4, has-3)\nroot(ROOT-0, produced-4)\nneg(failures-7, no-5)\namod(failures-7, spectacular-6)\ndobj(produced-4, failures-7)\ndobj(produced-4, failures-7')\ndobj(produced-4, failures-7'')\nconj_or(failures-7, failures-7')\nconj_or(failures-7, failures-7'')\nprep_in(failures-7, politics-9)\ndet(economy-13, the-12)\nprep_in(failures-7', economy-13)\ndet(front-18, the-16)\namod(front-18, military-17)\nprep_on(failures-7'', front-18)\naux(chalked-22, has-21)\nconj_and(produced-4, chalked-22)\nprt(chalked-22, up-23)\ndet(successes-25, some-24)\ndobj(chalked-22, successes-25)\n", "nsubj(walked-2, Fred-1)\nnsubj(walked-2', Fred-1)\nroot(ROOT-0, walked-2)\nconj_and(walked-2, walked-2')\ndet(door-5, the-4)\nprep_out(walked-2, door-5)\nadvmod(walked-2, right-7)\ndet(trap-10, a-9)\nprep_into(walked-2', trap-10)\n", "nsubj(walked-2, Fred-1)\nroot(ROOT-0, walked-2)\ndet(house-5, the-4)\nprep_into(walked-2, house-5)\nadvmod(walked-2, right-7)\ndet(trap-10, a-9)\nprep_into(walked-2, trap-10)\nconj_and(house-5, trap-10)\n", "nsubj(went-4, Marie-1)\nnsubj(drank-7, Marie-1)\nnsubj(talked-11, Marie-1)\nconj_and(Marie-1, Chris-3)\nnsubj(went-4, Chris-3)\nroot(ROOT-0, went-4)\nprt(went-4, out-5)\nconj_and(went-4, drank-7)\ndobj(drank-7, coffee-8)\nconj_and(went-4, talked-11)\nnn(Dependencies-14, Stanford-13)\nprep_about(talked-11, Dependencies-14)\n", "det(days-2, These-1)\ntmod(hustles-4, days-2)\nnsubj(hustles-4, he-3)\nnsubj(hustles-4', he-3)\nroot(ROOT-0, hustles-4)\nconj_and(hustles-4, hustles-4')\namod(jobs-7, house-painting-6)\nprep_to(hustles-4, jobs-7)\nposs(pickup-11, his-9)\nnn(pickup-11, Chevy-10)\nprep_in(hustles-4, pickup-11)\nprepc_after(hustles-4', training-15)\nprepc_before(hustles-4, training-15)\ndet(Tropics-18, the-17)\nprep_with(training-15, Tropics-18)\n", "nsubj(walked-2, Jill-1)\nnsubj(walked-2', Jill-1)\nnsubj(walked-2'', Jill-1)\nnsubj(walked-2''', Jill-1)\nnsubj(walked-2'''', Jill-1)\nroot(ROOT-0, walked-2)\nconj_and(walked-2, walked-2')\nconj_and(walked-2, walked-2'')\nconj_and(walked-2, walked-2''')\nconj_and(walked-2, walked-2'''')\ndet(door-5, the-4)\nprep_out(walked-2, door-5)\ndet(road-9, the-8)\nprep_over(walked-2', road-9)\ndet(block-14, the-12)\namod(block-14, deserted-13)\nprep_across(walked-2'', block-14)\ndet(corner-18, the-17)\nprep_around(walked-2''', corner-18)\ndet(park-23, the-22)\nprep_through(walked-2'''', park-23)\n", "nsubj(noticed-2, John-1)\nnsubj(departed-6, John-1)\nroot(ROOT-0, noticed-2)\ndet(cockroach-4, a-3)\ndobj(noticed-2, cockroach-4)\nconj_and(noticed-2, departed-6)\n", "advmod(fibers-4, More-1)\namod(fibers-4, common-2)\nnn(fibers-4, chrysotile-3)\nnsubj(curly-6, fibers-4)\nnsubjpass(rejected-11, fibers-4)\ncop(curly-6, are-5)\nccomp(explained-18, curly-6)\nauxpass(rejected-11, are-8)\nadvmod(easily-10, more-9)\nadvmod(rejected-11, easily-10)\nconj_and(curly-6, rejected-11)\nccomp(explained-18, rejected-11)\ndet(body-14, the-13)\nagent(rejected-11, body-14)\nnn(Mossman-17, Dr.-16)\nnsubj(explained-18, Mossman-17)\nroot(ROOT-0, explained-18)\n", "nsubjpass(appalled-3, John-1)\nnsubj(complain-6, John-1)\nauxpass(appalled-3, is-2)\nroot(ROOT-0, appalled-3)\naux(complain-6, will-5)\nconj_and(appalled-3, complain-6)\n", "nsubj(contributions-10, What-1)\ncop(contributions-10, are-2)\nnn(Marlowe-4, Christopher-3)\nposs(contributions-10, Marlowe-4)\nconj_and(Marlowe-4, Shakespeare-7)\nposs(contributions-10, Shakespeare-7)\namod(contributions-10, literary-9)\nroot(ROOT-0, contributions-10)\namod(literature-13, English-12)\nprep_to(contributions-10, literature-13)\n", "nsubj(contributions-9, What-1)\ncop(contributions-9, are-2)\nnn(Marlowe-4, Christopher-3)\nposs(contributions-9, Marlowe-4)\nconj_and(Marlowe-4, Shakespeare-6)\nposs(contributions-9, Shakespeare-6)\namod(contributions-9, literary-8)\nroot(ROOT-0, contributions-9)\namod(literature-12, English-11)\nprep_to(contributions-9, literature-12)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, dogs-3)\ndobj(like-2, cats-7)\nconj_and(dogs-3, cats-7)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, dogs-3)\ndobj(like-2, cats-6)\nconj_negcc(dogs-3, cats-6)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\ndobj(like-2, brandy-3)\ndobj(like-2, cognac-7)\nconj_and(brandy-3, cognac-7)\n", "nsubj(like-2, I-1)\nroot(ROOT-0, like-2)\nneg(only-4, not-3)\npreconj(cats-5, only-4)\ndobj(like-2, cats-5)\ndobj(like-2, dogs-8)\nconj_and(cats-5, dogs-8)\n", "nsubj(flew-2, Fred-1)\nroot(ROOT-0, flew-2)\nneg(only-4, not-3)\npreconj(flew-2, only-4)\nprep_to(flew-2, Greece-6)\nprep_to(flew-2, Serbia-10)\nconj_and(Greece-6, Serbia-10)\n", "advmod(recently-2, Only-1)\nadvmod(redesigned-7, recently-2)\naux(redesigned-7, has-3)\nnsubjpass(redesigned-7, it-4)\nauxpass(redesigned-7, been-5)\nadvmod(redesigned-7, attractively-6)\nroot(ROOT-0, redesigned-7)\nposs(product-11, its-9)\namod(product-11, editorial-10)\nnsubj(improved-12, product-11)\nconj_and(redesigned-7, improved-12)\n", "amod(gyrations-4, Political-1)\nconj_and(Political-1, currency-3)\namod(gyrations-4, currency-3)\nnsubj(whipsaw-6, gyrations-4)\naux(whipsaw-6, can-5)\nroot(ROOT-0, whipsaw-6)\ndet(funds-8, the-7)\ndobj(whipsaw-6, funds-8)\n", "root(ROOT-0, Managers-1)\nconj_and(Managers-1, presenters-3)\n", "root(ROOT-0, education-1)\nconj_and(education-1, science-3)\nconj_and(education-1, culture-5)\n", "root(ROOT-0, education-1)\nconj_and(education-1, science-3)\nconj_and(education-1, culture-6)\n", "root(ROOT-0, Digital-1)\nconj_and(Digital-1, Hewlett-3)\nconj_and(Digital-1, Sun-5)\n", "root(ROOT-0, Digital-1)\nconj_and(Digital-1, Hewlett-3)\nconj_and(Digital-1, Sun-6)\n", "nn(Depot-2, Home-1)\nroot(ROOT-0, Depot-2)\nconj_and(Depot-2, Sun-4)\nconj_and(Depot-2, Coke-7)\n", "nn(Depot-2, Home-1)\nroot(ROOT-0, Depot-2)\nconj_and(Depot-2, Sun-4)\nconj_and(Depot-2, Coke-6)\n", "nsubj(characteristics-14, Activation-1)\nprep_of(Activation-1, Akt-3)\nprep_of(Activation-1, NFkappaB-5)\nconj_and(Akt-3, NFkappaB-5)\nprep_of(Activation-1, Stat3-8)\nconj_and(Akt-3, Stat3-8)\nnn(pathways-12, MAPK-11)\nprep_of(Activation-1, pathways-12)\nconj_negcc(Akt-3, pathways-12)\ncop(characteristics-14, are-13)\nroot(ROOT-0, characteristics-14)\nvmod(characteristics-14, associated-15)\namod(transformation-18, malignant-17)\nprep_with(associated-15, transformation-18)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected CC processed dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false));
        }
    }

    public void testCopyNodes() {
        String[] testTrees = new String[]{"(ROOT (S (NP (NNP Bill)) (VP (VBD went) (PP (PP (IN over) (NP (DT the) (NN river))) (CC and) (PP (IN through) (NP (DT the) (NNS woods))))) (. .)))"};
        String[] testAnswers = new String[]{"nsubj(went-2, Bill-1)\nroot(ROOT-0, went-2)\nconj_and(went-2, went-2')\ndet(river-5, the-4)\nprep_over(went-2, river-5)\ndet(woods-9, the-8)\nprep_through(went-2', woods-9)\n"};
        EnglishGrammaticalStructureTest.assertEquals((String)"Test array lengths mismatch!", (int)testTrees.length, (int)testAnswers.length);
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (int i = 0; i < testTrees.length; ++i) {
            String testTree = testTrees[i];
            String testAnswer = testAnswers[i];
            Tree tree = Tree.valueOf(testTree, trf);
            EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(tree);
            EnglishGrammaticalStructureTest.assertEquals((String)("Unexpected basic dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependenciesCollapsed(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false));
        }
    }
}

