/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import junit.framework.TestCase;

public class SemanticHeadFinderTest
extends TestCase {
    private final HeadFinder shf = new SemanticHeadFinder();
    private final HeadFinder shfc = new SemanticHeadFinder(false);
    private Tree[] testTrees = new Tree[]{Tree.valueOf("(WHNP (WHADJP (WRB How) (JJ many)) (NNS cars))"), Tree.valueOf("(VP (VBZ is) (NP-PRD (DT a) (NN champion)))"), Tree.valueOf("(VP (VBZ has) (VP (VBN been) (VP (VBG feeling) (ADJP (JJ unwell)))))"), Tree.valueOf("(VP (VBG being) (NP (DT an) (NN idiot)))"), Tree.valueOf("(SBAR (WHNP (WDT that)) (S (NP (PRP you)) (VP (VB understand) (NP (PRP me)))))"), Tree.valueOf("(VP (VBD was) (VP (VBN defeated) (PP (IN by) (NP (NNP Clinton)))))"), Tree.valueOf("(VP (VBD was) (VP (VBG eating) (NP (NN pizza))))"), Tree.valueOf("(VP (VBN been) (VP (VBN overtaken)))"), Tree.valueOf("(VP (VBN been) (NP (DT a) (NN liar)))"), Tree.valueOf("(VP (VBZ is) (VP (VP (VBN purged) (PP (IN of) (NP (JJ threatening) (NNS elements)))) (, ,) (VP (VBN served) (PRT (RP up)) (PP (IN in) (NP (JJ bite-sized) (NNS morsels)))) (CC and) (VP (VBN accompanied) (PP (IN by) (NP-LGS (NNS visuals))))))"), Tree.valueOf("(VP (TO na) (VP (VB say) (NP (WP who)))))"), Tree.valueOf("(VP (VBZ s) (RB not) (NP-PRD (NP (DT any)) (PP (IN of) (NP (PRP you)))))"), Tree.valueOf("(VP (VBZ ve) (VP (VBN been) (VP (VBG feeling) (ADJP (JJ unwell)))))"), Tree.valueOf("(PP (SYM -) (NP (CD 3))))"), Tree.valueOf("(VP (`` \") (VBN forced) ('' \") (PP-CLR (IN into) (S-NOM (VP (VBG taking) (NP (DT a) (JJ hawkish) (NN line))))))")};
    private String[] shfHeads = new String[]{"NNS", "NP", "VP", "NP", "S", "VP", "VP", "VP", "NP", "VP", "VP", "NP", "VP", "SYM", "VBN"};
    private String[] shfcHeads = new String[]{"NNS", "VBZ", "VP", "VBG", "S", "VP", "VP", "VP", "VBN", "VP", "VP", "VBZ", "VP", "SYM", "VBN"};

    private void runTesting(HeadFinder hf, String[] heads) {
        SemanticHeadFinderTest.assertEquals((String)"Test arrays out of balance", (int)this.testTrees.length, (int)heads.length);
        for (int i = 0; i < this.testTrees.length; ++i) {
            Tree h = hf.determineHead(this.testTrees[i]);
            String headCat = h.value();
            SemanticHeadFinderTest.assertEquals((String)"Wrong head found", (String)heads[i], (String)headCat);
        }
    }

    public void testRegularSemanticHeadFinder() {
        this.runTesting(this.shf, this.shfHeads);
    }

    public void testCopulaHeadSemanticHeadFinder() {
        this.runTesting(this.shfc, this.shfcHeads);
    }
}

